/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<T> {
    private static IdGenerator sIdGenerator = new IdGenerator();
    private long iId = sIdGenerator.newId();
    private V iVariable = null;
    private long iAssignmentCounter = 0L;
    private long iLastAssignmentIteration = -1L;
    private long iLastUnassignmentIteration = -1L;
    protected double iValue = 0.0;
    private Object iExtra = null;

    public Value(V variable) {
        this.iVariable = variable;
    }

    public Value(V variable, double value) {
        this.iVariable = variable;
        this.iValue = value;
    }

    public V variable() {
        return this.iVariable;
    }

    public void setVariable(Variable variable) {
        this.iVariable = variable;
    }

    public void assigned(long iteration) {
        ++this.iAssignmentCounter;
        this.iLastAssignmentIteration = iteration;
    }

    public void unassigned(long iteration) {
        this.iLastUnassignmentIteration = iteration;
    }

    public long lastAssignmentIteration() {
        return this.iLastAssignmentIteration;
    }

    public long lastUnassignmentIteration() {
        return this.iLastUnassignmentIteration;
    }

    public long countAssignments() {
        return this.iAssignmentCounter;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public double toDouble() {
        return this.iValue;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public boolean valueEquals(T value) {
        if (value == null) {
            return false;
        }
        return this.toDouble() == ((Value)value).toDouble();
    }

    @Override
    public int compareTo(T value) {
        if (value == null) {
            return -1;
        }
        int cmp = Double.compare(this.toDouble(), ((Value)value).toDouble());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), ((Value)value).getId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Value)) {
            return false;
        }
        return this.getId() == ((Value)o).getId();
    }

    public Object getExtra() {
        return this.iExtra;
    }

    public void setExtra(Object object) {
        this.iExtra = object;
    }

    public boolean isConsistent(T value) {
        for (Constraint constraint : ((Variable)this.iVariable).constraints()) {
            if (constraint.isConsistent(this, (Value)value)) continue;
            return false;
        }
        for (Constraint constraint : ((Variable)this.iVariable).getModel().globalConstraints()) {
            if (constraint.isConsistent(this, (Value)value)) continue;
            return false;
        }
        return true;
    }

    public Set<T> conflicts() {
        HashSet conflicts = new HashSet();
        for (Constraint constraint : ((Variable)this.iVariable).constraints()) {
            constraint.computeConflicts(this, conflicts);
        }
        for (Constraint constraint : ((Variable)this.iVariable).getModel().globalConstraints()) {
            constraint.computeConflicts(this, conflicts);
        }
        if (!conflicts.isEmpty()) {
            return conflicts;
        }
        return null;
    }
}

