/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNeighbour<V extends Variable<V, T>, T extends Value<V, T>>
extends Neighbour<V, T> {
    private V iVariable = null;
    private T iValue = null;

    public SimpleNeighbour(V variable, T value) {
        this.iVariable = variable;
        this.iValue = value;
    }

    public V getVariable() {
        return this.iVariable;
    }

    public T getValue() {
        return this.iValue;
    }

    @Override
    public void assign(long iteration) {
        if (this.iVariable == null) {
            return;
        }
        if (this.iValue != null) {
            ((Variable)this.iVariable).assign(iteration, this.iValue);
        } else {
            ((Variable)this.iVariable).unassign(iteration);
        }
    }

    @Override
    public double value() {
        return (this.iValue == null ? 0.0 : ((Value)this.iValue).toDouble()) - (this.iVariable == null || ((Variable)this.iVariable).getAssignment() == null ? 0.0 : ((Value)((Variable)this.iVariable).getAssignment()).toDouble());
    }

    public String toString() {
        return ((Variable)this.iVariable).getName() + " " + (((Variable)this.iVariable).getAssignment() == null ? "null" : ((Value)((Variable)this.iVariable).getAssignment()).getName()) + " -> " + (this.iValue == null ? "null" : ((Value)this.iValue).getName());
    }
}

