/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.model.InfoProvider;
import net.sf.cpsolver.ifs.model.ModelListener;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model<V extends Variable<V, T>, T extends Value<V, T>> {
    private static Logger sLogger = Logger.getLogger(Model.class);
    protected static DecimalFormat sTimeFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sPercentageFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private List<V> iVariables = new ArrayList<V>();
    private List<Constraint<V, T>> iConstraints = new ArrayList<Constraint<V, T>>();
    private List<GlobalConstraint<V, T>> iGlobalConstraints = new ArrayList<GlobalConstraint<V, T>>();
    protected Collection<V> iUnassignedVariables = new HashSet<V>();
    protected Collection<V> iAssignedVariables = new HashSet<V>();
    private Collection<V> iVariablesWithInitialValueCache = null;
    protected Collection<V> iPerturbVariables = null;
    private List<ModelListener<V, T>> iModelListeners = new ArrayList<ModelListener<V, T>>();
    private List<InfoProvider<V>> iInfoProviders = new ArrayList<InfoProvider<V>>();
    private HashMap<String, Criterion<V, T>> iCriteria = new HashMap();
    private int iBestUnassignedVariables = -1;
    private int iBestPerturbations = 0;
    private int iNrAssignedVariables = 0;

    public List<V> variables() {
        return this.iVariables;
    }

    public int countVariables() {
        return this.iVariables.size();
    }

    public void addVariable(V variable) {
        ((Variable)variable).setModel(this);
        this.iVariables.add(variable);
        if (variable instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)variable);
        }
        if (((Variable)variable).getAssignment() == null) {
            if (this.iUnassignedVariables != null) {
                this.iUnassignedVariables.add(variable);
            }
        } else {
            if (this.iAssignedVariables != null) {
                this.iAssignedVariables.add(variable);
            }
            ++this.iNrAssignedVariables;
        }
        if (((Variable)variable).getAssignment() != null) {
            ((Variable)variable).assign(0L, ((Variable)variable).getAssignment());
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.variableAdded(variable);
        }
        this.invalidateVariablesWithInitialValueCache();
    }

    public void removeVariable(V variable) {
        ((Variable)variable).setModel(null);
        this.iVariables.remove(variable);
        if (variable instanceof InfoProvider) {
            this.iInfoProviders.remove(variable);
        }
        if (this.iUnassignedVariables != null && this.iUnassignedVariables.contains(variable)) {
            this.iUnassignedVariables.remove(variable);
        }
        if (this.iAssignedVariables != null && this.iAssignedVariables.contains(variable)) {
            this.iAssignedVariables.remove(variable);
        }
        if (((Variable)variable).getAssignment() != null) {
            --this.iNrAssignedVariables;
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.variableRemoved(variable);
        }
        this.invalidateVariablesWithInitialValueCache();
    }

    public List<Constraint<V, T>> constraints() {
        return this.iConstraints;
    }

    public int countConstraints() {
        return this.iConstraints.size();
    }

    public void addConstraint(Constraint<V, T> constraint) {
        constraint.setModel(this);
        this.iConstraints.add(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)constraint));
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.constraintAdded(constraint);
        }
    }

    public void removeConstraint(Constraint<V, T> constraint) {
        constraint.setModel(null);
        this.iConstraints.remove(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.remove(constraint);
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.constraintRemoved(constraint);
        }
    }

    public List<GlobalConstraint<V, T>> globalConstraints() {
        return this.iGlobalConstraints;
    }

    public int countGlobalConstraints() {
        return this.iGlobalConstraints.size();
    }

    public void addGlobalConstraint(GlobalConstraint<V, T> constraint) {
        constraint.setModel(this);
        this.iGlobalConstraints.add(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)constraint));
        }
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.constraintAdded(constraint);
        }
    }

    public void removeGlobalConstraint(GlobalConstraint<V, T> constraint) {
        constraint.setModel(null);
        this.iGlobalConstraints.remove(constraint);
        if (constraint instanceof InfoProvider) {
            this.iInfoProviders.remove(constraint);
        }
        for (ModelListener listener : this.iModelListeners) {
            listener.constraintRemoved(constraint);
        }
    }

    public Collection<V> unassignedVariables() {
        if (this.iUnassignedVariables != null) {
            return this.iUnassignedVariables;
        }
        ArrayList<Variable> un = new ArrayList<Variable>(this.iVariables.size());
        for (Variable variable : this.iVariables) {
            if (variable.getAssignment() != null) continue;
            un.add(variable);
        }
        return un;
    }

    public int nrUnassignedVariables() {
        if (this.iUnassignedVariables != null) {
            return this.iUnassignedVariables.size();
        }
        return this.iVariables.size() - this.iNrAssignedVariables;
    }

    public Collection<V> assignedVariables() {
        if (this.iAssignedVariables != null) {
            return this.iAssignedVariables;
        }
        ArrayList<Variable> as = new ArrayList<Variable>(this.iVariables.size());
        for (Variable variable : this.iVariables) {
            if (variable.getAssignment() == null) continue;
            as.add(variable);
        }
        return as;
    }

    public int nrAssignedVariables() {
        if (this.iAssignedVariables != null) {
            return this.iAssignedVariables.size();
        }
        return this.iNrAssignedVariables;
    }

    public Collection<V> perturbVariables() {
        if (this.iPerturbVariables == null) {
            this.iPerturbVariables = this.perturbVariables(this.variablesWithInitialValue());
        }
        return this.iPerturbVariables;
    }

    public List<V> perturbVariables(Collection<V> variables) {
        ArrayList<Variable> perturbances = new ArrayList<Variable>();
        for (Variable variable : variables) {
            if (variable.getInitialAssignment() == null) continue;
            if (variable.getAssignment() != null) {
                if (((Value)variable.getInitialAssignment()).equals(variable.getAssignment())) continue;
                perturbances.add(variable);
                continue;
            }
            boolean hasPerturbance = false;
            for (Constraint constraint : variable.hardConstraints()) {
                if (!constraint.inConflict(variable.getInitialAssignment())) continue;
                hasPerturbance = true;
                break;
            }
            if (!hasPerturbance) {
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    if (!globalConstraint.inConflict(variable.getInitialAssignment())) continue;
                    hasPerturbance = true;
                    break;
                }
            }
            if (!hasPerturbance) continue;
            perturbances.add(variable);
        }
        return perturbances;
    }

    public Set<T> conflictValues(T value) {
        HashSet conflictValues = new HashSet();
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            constraint.computeConflicts(value, conflictValues);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            globalConstraint.computeConflicts(value, conflictValues);
        }
        return conflictValues;
    }

    public boolean inConflict(T value) {
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            if (!constraint.inConflict(value)) continue;
            return true;
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            if (!globalConstraint.inConflict(value)) continue;
            return true;
        }
        return false;
    }

    public Collection<V> variablesWithInitialValue() {
        if (this.iVariablesWithInitialValueCache != null) {
            return this.iVariablesWithInitialValueCache;
        }
        this.iVariablesWithInitialValueCache = new ArrayList<V>();
        for (Variable variable : this.iVariables) {
            if (variable.getInitialAssignment() == null) continue;
            this.iVariablesWithInitialValueCache.add(variable);
        }
        return this.iVariablesWithInitialValueCache;
    }

    protected void invalidateVariablesWithInitialValueCache() {
        this.iVariablesWithInitialValueCache = null;
    }

    public void beforeAssigned(long iteration, T value) {
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.beforeAssigned(iteration, value);
        }
    }

    public void beforeUnassigned(long iteration, T value) {
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.beforeUnassigned(iteration, value);
        }
    }

    public void afterAssigned(long iteration, T value) {
        if (this.iUnassignedVariables != null) {
            this.iUnassignedVariables.remove(((Value)value).variable());
        }
        if (this.iAssignedVariables != null) {
            this.iAssignedVariables.add(((Value)value).variable());
        }
        ++this.iNrAssignedVariables;
        this.iPerturbVariables = null;
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.afterAssigned(iteration, value);
        }
    }

    public void afterUnassigned(long iteration, T value) {
        if (this.iUnassignedVariables != null) {
            this.iUnassignedVariables.add(((Value)value).variable());
        }
        if (this.iAssignedVariables != null) {
            this.iAssignedVariables.remove(((Value)value).variable());
        }
        --this.iNrAssignedVariables;
        this.iPerturbVariables = null;
        for (ModelListener<V, T> listener : this.iModelListeners) {
            listener.afterUnassigned(iteration, value);
        }
    }

    public String toString() {
        return "Model{\n    variables=" + ToolBox.col2string(this.variables(), 2) + ",\n    constraints=" + ToolBox.col2string(this.constraints(), 2) + ",\n    #unassigned=" + this.nrUnassignedVariables() + ",\n    unassigned=" + ToolBox.col2string(this.unassignedVariables(), 2) + ",\n    #perturbations=" + this.perturbVariables().size() + "+" + (this.variables().size() - this.variablesWithInitialValue().size()) + ",\n    perturbations=" + ToolBox.col2string(this.perturbVariables(), 2) + ",\n    info=" + this.getInfo() + "\n  }";
    }

    protected String getPerc(double value, double min, double max) {
        if (max == min) {
            return sPercentageFormat.format(100.0);
        }
        return sPercentageFormat.format(100.0 - 100.0 * (value - min) / (max - min));
    }

    protected String getPercRev(double value, double min, double max) {
        if (max == min) {
            return sPercentageFormat.format(0.0);
        }
        return sPercentageFormat.format(100.0 * (value - min) / (max - min));
    }

    public Map<String, String> getInfo() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Assigned variables", this.getPercRev(this.nrAssignedVariables(), 0.0, this.variables().size()) + "% (" + this.nrAssignedVariables() + "/" + this.variables().size() + ")");
        int nrVarsWithInitialValue = this.variablesWithInitialValue().size();
        if (nrVarsWithInitialValue > 0) {
            ret.put("Perturbation variables", this.getPercRev(this.perturbVariables().size(), 0.0, nrVarsWithInitialValue) + "% (" + this.perturbVariables().size() + " + " + (this.variables().size() - nrVarsWithInitialValue) + ")");
        }
        ret.put("Overall solution value", sDoubleFormat.format(this.getTotalValue()));
        for (InfoProvider<V> provider : this.iInfoProviders) {
            provider.getInfo(ret);
        }
        return ret;
    }

    public Map<String, String> getExtendedInfo() {
        return this.getInfo();
    }

    public Map<String, String> getInfo(Collection<V> variables) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int assigned = 0;
        int perturb = 0;
        int nrVarsWithInitialValue = 0;
        for (Variable variable : variables) {
            if (variable.getAssignment() != null) {
                ++assigned;
            }
            if (variable.getInitialAssignment() == null) continue;
            ++nrVarsWithInitialValue;
            if (variable.getAssignment() != null) {
                if (((Value)variable.getInitialAssignment()).equals(variable.getAssignment())) continue;
                ++perturb;
                continue;
            }
            boolean hasPerturbance = false;
            for (Constraint constraint : variable.hardConstraints()) {
                if (!constraint.inConflict(variable.getInitialAssignment())) continue;
                hasPerturbance = true;
                break;
            }
            if (!hasPerturbance) {
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    if (!globalConstraint.inConflict(variable.getInitialAssignment())) continue;
                    hasPerturbance = true;
                    break;
                }
            }
            if (!hasPerturbance) continue;
            ++perturb;
        }
        ret.put("Assigned variables", this.getPercRev(assigned, 0.0, variables.size()) + "% (" + assigned + "/" + variables.size() + ")");
        if (nrVarsWithInitialValue > 0) {
            ret.put("Perturbation variables", this.getPercRev(perturb, 0.0, nrVarsWithInitialValue) + "% (" + perturb + " + " + (variables.size() - nrVarsWithInitialValue) + ")");
        }
        ret.put("Overall solution value", sDoubleFormat.format(this.getTotalValue(variables)));
        for (InfoProvider infoProvider : this.iInfoProviders) {
            infoProvider.getInfo(ret, variables);
        }
        return ret;
    }

    public int getBestUnassignedVariables() {
        return this.iBestUnassignedVariables;
    }

    public int getBestPerturbations() {
        return this.iBestPerturbations;
    }

    public void saveBest() {
        this.iBestUnassignedVariables = this.nrUnassignedVariables();
        this.iBestPerturbations = this.perturbVariables().size();
        for (Variable variable : this.iVariables) {
            variable.setBestAssignment(variable.getAssignment());
        }
        for (Criterion criterion : this.getCriteria()) {
            criterion.bestSaved();
        }
    }

    public void clearBest() {
        this.iBestUnassignedVariables = -1;
        this.iBestPerturbations = 0;
        for (Variable variable : this.iVariables) {
            variable.setBestAssignment(null);
        }
    }

    protected void restoreBest(Comparator<V> assignmentOrder) {
        TreeSet<V> sortedVariables = new TreeSet<V>(assignmentOrder);
        for (Object variable : this.iVariables) {
            if (((Variable)variable).getAssignment() == null) {
                if (((Variable)variable).getBestAssignment() == null) continue;
                sortedVariables.add(variable);
                continue;
            }
            if (((Value)((Variable)variable).getAssignment()).equals(((Variable)variable).getBestAssignment())) continue;
            ((Variable)variable).unassign(0L);
            if (((Variable)variable).getBestAssignment() == null) continue;
            sortedVariables.add(variable);
        }
        HashSet<Object> problems = new HashSet<Object>();
        for (Variable variable : sortedVariables) {
            Set confs = this.conflictValues(variable.getBestAssignment());
            if (!confs.isEmpty()) {
                HashSet x;
                sLogger.error((Object)("restore best problem: assignment " + variable.getName() + " = " + ((Value)variable.getBestAssignment()).getName()));
                for (Constraint constraint : variable.hardConstraints()) {
                    x = new HashSet();
                    constraint.computeConflicts(variable.getBestAssignment(), x);
                    if (x.isEmpty()) continue;
                    if (constraint instanceof WeakeningConstraint) {
                        ((WeakeningConstraint)((Object)constraint)).weaken(variable.getBestAssignment());
                        sLogger.info((Object)("  constraint " + constraint.getClass().getName() + " " + constraint.getName() + " had to be weakened"));
                        continue;
                    }
                    sLogger.error((Object)("  constraint " + constraint.getClass().getName() + " " + constraint.getName() + " causes the following conflicts " + x));
                }
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    x = new HashSet();
                    globalConstraint.computeConflicts(variable.getBestAssignment(), x);
                    if (x.isEmpty()) continue;
                    if (globalConstraint instanceof WeakeningConstraint) {
                        ((WeakeningConstraint)((Object)globalConstraint)).weaken(variable.getBestAssignment());
                        sLogger.info((Object)("  constraint " + globalConstraint.getClass().getName() + " " + globalConstraint.getName() + " had to be weakened"));
                        continue;
                    }
                    sLogger.error((Object)("  global constraint " + globalConstraint.getClass().getName() + " " + globalConstraint.getName() + " causes the following conflicts " + x));
                }
                problems.add(variable.getBestAssignment());
                continue;
            }
            variable.assign(0L, variable.getBestAssignment());
        }
        int attempt = 0;
        int maxAttempts = 3 * problems.size();
        while (!problems.isEmpty() && attempt <= maxAttempts) {
            ++attempt;
            Value value = (Value)ToolBox.random(problems);
            problems.remove(value);
            Object variable = value.variable();
            Set<Value> set = this.conflictValues(value);
            if (!set.isEmpty()) {
                HashSet x;
                sLogger.error((Object)("restore best problem (again, att=" + attempt + "): assignment " + ((Variable)variable).getName() + " = " + value.getName()));
                for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                    x = new HashSet();
                    constraint.computeConflicts(value, x);
                    if (x.isEmpty()) continue;
                    sLogger.error((Object)("  constraint " + constraint.getClass().getName() + " " + constraint.getName() + " causes the following conflicts " + x));
                }
                for (GlobalConstraint globalConstraint : this.globalConstraints()) {
                    x = new HashSet();
                    globalConstraint.computeConflicts(value, x);
                    if (x.isEmpty()) continue;
                    sLogger.error((Object)("  constraint " + globalConstraint.getClass().getName() + " " + globalConstraint.getName() + " causes the following conflicts " + x));
                }
                for (Value value2 : set) {
                    ((Variable)value2.variable()).unassign(0L);
                }
                problems.addAll(set);
            }
            ((Variable)variable).assign(0L, (Value)value);
        }
        for (Criterion<V, T> criterion : this.getCriteria()) {
            criterion.bestRestored();
        }
    }

    public void restoreBest() {
        this.restoreBest(new Comparator<V>(){

            @Override
            public int compare(V v1, V v2) {
                if (((Variable)v1).getBestAssignmentIteration() < ((Variable)v2).getBestAssignmentIteration()) {
                    return -1;
                }
                if (((Variable)v1).getBestAssignmentIteration() > ((Variable)v2).getBestAssignmentIteration()) {
                    return 1;
                }
                return ((Variable)v1).compareTo(v2);
            }
        });
    }

    public Collection<V> bestUnassignedVariables() {
        if (this.iBestUnassignedVariables < 0) {
            return this.unassignedVariables();
        }
        ArrayList<Variable> ret = new ArrayList<Variable>(this.variables().size());
        for (Variable variable : this.variables()) {
            if (variable.getBestAssignment() != null) continue;
            ret.add(variable);
        }
        return ret;
    }

    public double getTotalValue() {
        double ret = 0.0;
        for (Variable v : this.assignedVariables()) {
            ret += ((Value)v.getAssignment()).toDouble();
        }
        return ret;
    }

    public double getTotalValue(Collection<V> variables) {
        double ret = 0.0;
        for (Variable v : variables) {
            if (v.getAssignment() == null) continue;
            ret += ((Value)v.getAssignment()).toDouble();
        }
        return ret;
    }

    public void addModelListener(ModelListener<V, T> listener) {
        this.iModelListeners.add(listener);
        if (listener instanceof InfoProvider) {
            this.iInfoProviders.add((InfoProvider)((Object)listener));
        }
        for (Constraint<V, T> constraint : this.iConstraints) {
            listener.constraintAdded(constraint);
        }
        for (Variable variable : this.iVariables) {
            listener.variableAdded(variable);
        }
    }

    public void removeModelListener(ModelListener<V, T> listener) {
        if (listener instanceof InfoProvider) {
            this.iInfoProviders.remove(listener);
        }
        for (Variable variable : this.iVariables) {
            listener.variableRemoved(variable);
        }
        for (Constraint constraint : this.iConstraints) {
            listener.constraintRemoved(constraint);
        }
        this.iModelListeners.remove(listener);
    }

    public boolean init(Solver<V, T> solver) {
        for (ModelListener<V, T> listener : new ArrayList<ModelListener<V, T>>(this.iModelListeners)) {
            if (listener.init(solver)) continue;
            return false;
        }
        return true;
    }

    public List<ModelListener<V, T>> getModelListeners() {
        return this.iModelListeners;
    }

    public ModelListener<V, T> modelListenerOfType(Class<ModelListener<V, T>> type) {
        for (ModelListener<V, T> listener : this.iModelListeners) {
            if (listener.getClass() != type) continue;
            return listener;
        }
        return null;
    }

    public Map<Constraint<V, T>, Set<T>> conflictConstraints(T value) {
        HashSet conflicts;
        HashMap conflictConstraints = new HashMap();
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            conflicts = new HashSet();
            constraint.computeConflicts(value, conflicts);
            if (conflicts.isEmpty()) continue;
            conflictConstraints.put(constraint, conflicts);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            conflicts = new HashSet();
            globalConstraint.computeConflicts(value, conflicts);
            if (conflicts.isEmpty()) continue;
            conflictConstraints.put(globalConstraint, conflicts);
        }
        return conflictConstraints;
    }

    public List<Constraint<V, T>> unassignedHardConstraints() {
        ArrayList<Constraint<V, T>> ret = new ArrayList<Constraint<V, T>>();
        block0: for (Constraint<V, T> constraint : this.constraints()) {
            if (!constraint.isHard()) continue;
            for (Variable v : constraint.variables()) {
                if (v.getAssignment() != null) continue;
                ret.add(constraint);
                continue block0;
            }
        }
        if (!this.unassignedVariables().isEmpty()) {
            ret.addAll(this.globalConstraints());
        }
        return ret;
    }

    protected List<InfoProvider<V>> getInfoProviders() {
        return this.iInfoProviders;
    }

    public void addCriterion(Criterion<V, T> criterion) {
        this.iCriteria.put(criterion.getClass().getName(), criterion);
        this.addModelListener(criterion);
    }

    public void removeCriterion(Criterion<V, T> criterion) {
        this.iCriteria.remove(criterion.getClass().getName());
        this.removeModelListener(criterion);
    }

    public void removeCriterion(Class<? extends Criterion<V, T>> criterion) {
        Criterion<V, T> c = this.iCriteria.remove(criterion.getName());
        if (c != null) {
            this.removeModelListener(c);
        }
    }

    public Criterion<V, T> getCriterion(Class<? extends Criterion<V, T>> criterion) {
        return this.iCriteria.get(criterion.getName());
    }

    public Collection<Criterion<V, T>> getCriteria() {
        return this.iCriteria.values();
    }

    public void weaken(T value) {
        for (Constraint constraint : ((Variable)((Value)value).variable()).hardConstraints()) {
            if (!(constraint instanceof WeakeningConstraint)) continue;
            ((WeakeningConstraint)((Object)constraint)).weaken(value);
        }
        for (GlobalConstraint globalConstraint : this.globalConstraints()) {
            if (!(globalConstraint instanceof WeakeningConstraint)) continue;
            ((WeakeningConstraint)((Object)globalConstraint)).weaken(value);
        }
    }
}

