/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyNeighbour<V extends Variable<V, T>, T extends Value<V, T>>
extends Neighbour<V, T> {
    private LazyNeighbourAcceptanceCriterion<V, T> iCriterion = null;

    public void setAcceptanceCriterion(LazyNeighbourAcceptanceCriterion<V, T> criterion) {
        this.iCriterion = criterion;
    }

    @Override
    public void assign(long iteration) {
        double before = this.getModel().getTotalValue();
        this.doAssign(iteration);
        double after = this.getModel().getTotalValue();
        if (!this.iCriterion.accept(this, after - before)) {
            this.undoAssign(iteration);
        }
    }

    @Override
    public double value() {
        return -1.0;
    }

    protected abstract void doAssign(long var1);

    protected abstract void undoAssign(long var1);

    public abstract Model<V, T> getModel();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LazyNeighbourAcceptanceCriterion<V extends Variable<V, T>, T extends Value<V, T>> {
        public boolean accept(LazyNeighbour<V, T> var1, double var2);
    }
}

