/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.ConstraintListener;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlobalConstraint<V extends Variable<V, T>, T extends Value<V, T>>
extends Constraint<V, T> {
    @Override
    public List<V> variables() {
        return this.getModel().variables();
    }

    @Override
    public Collection<V> assignedVariables() {
        return this.getModel().assignedVariables();
    }

    @Override
    public void addVariable(V variable) {
        throw new RuntimeException("A variable cannot be added to a global constraint.");
    }

    @Override
    public void removeVariable(V variable) {
        throw new RuntimeException("A variable cannot be removed from a global constraint.");
    }

    @Override
    public void assigned(long iteration, T value) {
        HashSet conf = null;
        if (this.isHard()) {
            conf = new HashSet();
            this.computeConflicts(value, conf);
        }
        if (this.constraintListeners() != null) {
            for (ConstraintListener listener : this.iConstraintListeners) {
                listener.constraintBeforeAssigned(iteration, this, value, conf);
            }
        }
        if (conf != null) {
            for (Value conflictValue : conf) {
                ((Variable)conflictValue.variable()).unassign(iteration);
            }
        }
        if (this.constraintListeners() != null) {
            for (ConstraintListener listener : this.iConstraintListeners) {
                listener.constraintAfterAssigned(iteration, this, value, conf);
            }
        }
    }

    @Override
    public void unassigned(long iteration, T value) {
    }
}

