/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.model.ConstraintListener;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constraint<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<Constraint<V, T>> {
    private static IdGenerator iIdGenerator = new IdGenerator();
    protected long iId = -1L;
    private List<V> iVariables = new ArrayList<V>();
    protected Collection<V> iAssignedVariables = new HashSet<V>();
    private Model<V, T> iModel = null;
    protected List<ConstraintListener<T>> iConstraintListeners = null;

    public Constraint() {
        this.iId = iIdGenerator.newId();
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    public void setModel(Model<V, T> model) {
        this.iModel = model;
    }

    public List<V> variables() {
        return this.iVariables;
    }

    public Collection<V> assignedVariables() {
        return this.iAssignedVariables;
    }

    public int countVariables() {
        return this.variables().size();
    }

    public int countAssignedVariables() {
        return this.assignedVariables().size();
    }

    public void addVariable(V variable) {
        this.iVariables.add(variable);
        ((Variable)variable).addContstraint(this);
        if (((Variable)variable).getAssignment() != null) {
            this.assigned(0L, ((Variable)variable).getAssignment());
            if (this.iAssignedVariables != null) {
                this.iAssignedVariables.add(variable);
            }
        }
    }

    public void removeVariable(V variable) {
        if (((Variable)variable).getAssignment() != null) {
            this.unassigned(0L, ((Variable)variable).getAssignment());
        }
        ((Variable)variable).removeContstraint(this);
        this.iVariables.remove(variable);
        if (this.iAssignedVariables != null && this.iAssignedVariables.contains(variable)) {
            this.iAssignedVariables.remove(variable);
        }
    }

    public abstract void computeConflicts(T var1, Set<T> var2);

    public boolean isConsistent(T value1, T value2) {
        return true;
    }

    public boolean inConflict(T value) {
        HashSet conflicts = new HashSet();
        this.computeConflicts(value, conflicts);
        return !conflicts.isEmpty();
    }

    public void assigned(long iteration, T value) {
        HashSet conf = null;
        if (this.isHard()) {
            conf = new HashSet();
            this.computeConflicts(value, conf);
        }
        if (this.iConstraintListeners != null) {
            for (ConstraintListener<Object> constraintListener : this.iConstraintListeners) {
                constraintListener.constraintBeforeAssigned(iteration, this, value, conf);
            }
        }
        if (conf != null) {
            for (Value value2 : conf) {
                if (value2.equals(value)) continue;
                ((Variable)value2.variable()).unassign(iteration);
            }
        }
        if (this.iAssignedVariables != null) {
            this.iAssignedVariables.add(((Value)value).variable());
        }
        if (this.iConstraintListeners != null) {
            for (ConstraintListener<Object> constraintListener : this.iConstraintListeners) {
                constraintListener.constraintAfterAssigned(iteration, this, value, conf);
            }
        }
    }

    public void unassigned(long iteration, T value) {
        if (this.iAssignedVariables != null) {
            this.iAssignedVariables.remove(((Value)value).variable());
        }
    }

    public void addConstraintListener(ConstraintListener<T> listener) {
        if (this.iConstraintListeners == null) {
            this.iConstraintListeners = new ArrayList<ConstraintListener<T>>();
        }
        this.iConstraintListeners.add(listener);
    }

    public void removeConstraintListener(ConstraintListener<T> listener) {
        if (this.iConstraintListeners != null) {
            this.iConstraintListeners.remove(listener);
        }
    }

    public List<ConstraintListener<T>> constraintListeners() {
        return this.iConstraintListeners;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public boolean isHard() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Constraint)) {
            return false;
        }
        return this.getId() == ((Constraint)o).getId();
    }

    @Override
    public int compareTo(Constraint<V, T> c) {
        return Double.compare(this.getId(), c.getId());
    }
}

