/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.heuristics;

import java.lang.reflect.Constructor;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.solver.SolverListener;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T> {
    protected static Logger sLogger = Logger.getLogger(StandardNeighbourSelection.class);
    private ValueSelection<V, T> iValueSelection = null;
    private VariableSelection<V, T> iVariableSelection = null;
    private Solver<V, T> iSolver = null;

    public void setValueSelection(ValueSelection<V, T> valueSelection) {
        this.iValueSelection = valueSelection;
    }

    public void setVariableSelection(VariableSelection<V, T> variableSelection) {
        this.iVariableSelection = variableSelection;
    }

    public ValueSelection<V, T> getValueSelection() {
        return this.iValueSelection;
    }

    public VariableSelection<V, T> getVariableSelection() {
        return this.iVariableSelection;
    }

    public StandardNeighbourSelection(DataProperties properties) throws Exception {
        String valueSelectionClassName = properties.getProperty("Value.Class", "net.sf.cpsolver.ifs.heuristics.GeneralValueSelection");
        sLogger.info((Object)("Using " + valueSelectionClassName));
        Class<?> valueSelectionClass = Class.forName(valueSelectionClassName);
        Constructor<?> valueSelectionConstructor = valueSelectionClass.getConstructor(DataProperties.class);
        this.setValueSelection((ValueSelection)valueSelectionConstructor.newInstance(properties));
        String variableSelectionClassName = properties.getProperty("Variable.Class", "net.sf.cpsolver.ifs.heuristics.GeneralVariableSelection");
        sLogger.info((Object)("Using " + variableSelectionClassName));
        Class<?> variableSelectionClass = Class.forName(variableSelectionClassName);
        Constructor<?> variableSelectionConstructor = variableSelectionClass.getConstructor(DataProperties.class);
        this.setVariableSelection((VariableSelection)variableSelectionConstructor.newInstance(properties));
    }

    @Override
    public void init(Solver<V, T> solver) {
        this.getValueSelection().init(solver);
        this.getVariableSelection().init(solver);
        this.iSolver = solver;
    }

    public V selectVariable(Solution<V, T> solution) {
        V variable = this.getVariableSelection().selectVariable(solution);
        for (SolverListener<V, T> listener : this.iSolver.getSolverListeners()) {
            if (listener.variableSelected(solution.getIteration(), variable)) continue;
            return null;
        }
        if (variable == null) {
            sLogger.debug((Object)"No variable selected.");
        }
        if (variable != null && !((Variable)variable).hasValues()) {
            sLogger.debug((Object)("Variable " + ((Variable)variable).getName() + " has no values."));
            return null;
        }
        return variable;
    }

    public T selectValue(Solution<V, T> solution, V variable) {
        T value = this.getValueSelection().selectValue(solution, variable);
        for (SolverListener<V, T> solverListener : this.iSolver.getSolverListeners()) {
            if (solverListener.valueSelected(solution.getIteration(), variable, value)) continue;
            return null;
        }
        if (value == null) {
            sLogger.debug((Object)("No value selected for variable " + variable + "."));
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!constraint.isHard() || !(constraint instanceof WeakeningConstraint)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken();
            }
            for (Constraint constraint : solution.getModel().globalConstraints()) {
                if (!constraint.isHard() || !(constraint instanceof WeakeningConstraint)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken();
            }
        } else {
            for (Constraint constraint : ((Variable)variable).hardConstraints()) {
                if (!(constraint instanceof WeakeningConstraint) || !constraint.inConflict(value)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken();
            }
            for (Constraint constraint : solution.getModel().globalConstraints()) {
                if (!(constraint instanceof WeakeningConstraint) || !constraint.inConflict(value)) continue;
                ((WeakeningConstraint)((Object)constraint)).weaken();
            }
        }
        return value;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        V variable = this.selectVariable(solution);
        if (variable == null) {
            return null;
        }
        T value = this.selectValue(solution, variable);
        if (value == null) {
            return null;
        }
        return new SimpleNeighbour<V, T>(variable, value);
    }
}

