/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.List;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRobinNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    private static Logger sLogger = Logger.getLogger(RoundRobinNeighbourSelection.class);
    private int iSelectionIdx = -1;
    private List<NeighbourSelection<V, T>> iSelections = new ArrayList<NeighbourSelection<V, T>>();
    private Solver<V, T> iSolver = null;

    public RoundRobinNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
    }

    public void registerSelection(NeighbourSelection<V, T> selection) {
        this.iSelections.add(selection);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iSolver = solver;
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        if (this.iSelectionIdx == -1) {
            this.iSelectionIdx = 0;
            this.iSelections.get(this.iSelectionIdx).init(this.iSolver);
        }
        NeighbourSelection<V, T> selection;
        Neighbour<V, T> neighbour;
        while ((neighbour = (selection = this.iSelections.get(this.iSelectionIdx)).selectNeighbour(solution)) == null) {
            this.changeSelection(solution);
        }
        return neighbour;
    }

    public void changeSelection(Solution<V, T> solution) {
        this.iSelectionIdx = (1 + this.iSelectionIdx) % this.iSelections.size();
        sLogger.debug((Object)("Phase changed to " + (this.iSelectionIdx + 1)));
        if (solution.getBestInfo() == null || this.iSolver.getSolutionComparator().isBetterThanBestSolution(solution)) {
            solution.saveBest();
        }
        this.iSelections.get(this.iSelectionIdx).init(this.iSolver);
    }
}

