/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.MacPropagation;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralVariableSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements VariableSelection<V, T> {
    private boolean iUnassignWhenNotGood = false;
    private double iUnassignWhenNotGoodRandWalk = 0.02;
    private boolean iRandomSelection = true;
    private MacPropagation<V, T> iProp = null;

    public GeneralVariableSelection(DataProperties properties) {
        this.iUnassignWhenNotGood = properties.getPropertyBoolean("Variable.UnassignWhenNoGood", this.iUnassignWhenNotGood);
        this.iUnassignWhenNotGoodRandWalk = properties.getPropertyDouble("Variable.UnassignWhenNoGoodRandomWalk", this.iUnassignWhenNotGoodRandWalk);
        this.iRandomSelection = properties.getPropertyBoolean("Variable.RandomSelection", this.iRandomSelection);
    }

    public GeneralVariableSelection() {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!MacPropagation.class.isInstance(extension)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    @Override
    public V selectVariable(Solution<V, T> solution) {
        if (solution.getModel().nrUnassignedVariables() == 0) {
            if (!solution.getModel().perturbVariables().isEmpty()) {
                return (V)((Variable)ToolBox.random(solution.getModel().perturbVariables()));
            }
            return (V)((Variable)ToolBox.random(solution.getModel().assignedVariables()));
        }
        if (this.iProp != null && this.iUnassignWhenNotGood) {
            ArrayList<Variable> noGoodVariables = new ArrayList<Variable>();
            for (Variable variable : solution.getModel().unassignedVariables()) {
                if (!this.iProp.goodValues(variable).isEmpty()) continue;
                noGoodVariables.add(variable);
            }
            if (!noGoodVariables.isEmpty()) {
                if (ToolBox.random() < this.iUnassignWhenNotGoodRandWalk) {
                    return (V)((Variable)ToolBox.random(solution.getModel().assignedVariables()));
                }
                for (int attempt = 0; attempt < 10; ++attempt) {
                    Variable noGoodVariable = (Variable)ToolBox.random(noGoodVariables);
                    Value noGoodValue = (Value)ToolBox.random(noGoodVariable.values());
                    Set<Value> noGood = this.iProp.noGood(noGoodValue);
                    if (noGood == null || noGood.isEmpty()) continue;
                    return ToolBox.random(noGood).variable();
                }
            }
        }
        if (this.iRandomSelection) {
            return (V)((Variable)ToolBox.random(solution.getModel().unassignedVariables()));
        }
        ArrayList<Integer> points = new ArrayList<Integer>();
        int totalPoints = 0;
        for (Variable variable : solution.getModel().unassignedVariables()) {
            int pointsThisVariable = variable.getInitialAssignment() != null ? 3 * (1 + solution.getModel().conflictValues(variable.getInitialAssignment()).size()) : 1;
            points.add(totalPoints += pointsThisVariable);
        }
        int rndPoints = ToolBox.random(totalPoints);
        Iterator<V> x = solution.getModel().unassignedVariables().iterator();
        for (int i = 0; x.hasNext() && i < points.size(); ++i) {
            Variable variable = (Variable)x.next();
            int tp = (Integer)points.get(i);
            if (tp <= rndPoints) continue;
            return (V)variable;
        }
        return (V)((Variable)ToolBox.random(solution.getModel().unassignedVariables()));
    }
}

