/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.constant.ConstantVariable;
import net.sf.cpsolver.ifs.extension.ConflictStatistics;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktrackNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    private ConflictStatistics<V, T> iStat = null;
    private static Logger sLog = Logger.getLogger(BacktrackNeighbourSelection.class);
    private int iTimeout = 5000;
    private int iDepth = 4;
    protected Solution<V, T> iSolution = null;
    protected BackTrackNeighbour iBackTrackNeighbour = null;
    protected double iValue = 0.0;
    private int iNrAssigned = 0;
    private long iT0;
    private long iT1;
    private boolean iTimeoutReached = false;
    private int iMaxIters = -1;
    private int iNrIters = 0;
    private boolean iMaxItersReached = false;

    public BacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iTimeout = properties.getPropertyInt("Neighbour.BackTrackTimeout", this.iTimeout);
        this.iDepth = properties.getPropertyInt("Neighbour.BackTrackDepth", this.iDepth);
        this.iMaxIters = properties.getPropertyInt("Neighbour.BackTrackMaxIters", this.iMaxIters);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        return this.selectNeighbour(solution, this.getVariableSelection().selectVariable(solution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Neighbour<V, T> selectNeighbour(Solution<V, T> solution, V variable) {
        if (variable == null) {
            return null;
        }
        this.iSolution = solution;
        this.iBackTrackNeighbour = null;
        this.iValue = solution.getModel().getTotalValue();
        this.iNrAssigned = solution.getModel().assignedVariables().size();
        this.iT0 = JProf.currentTimeMillis();
        this.iNrIters = 0;
        this.iTimeoutReached = false;
        this.iMaxItersReached = false;
        Solution<V, T> solution2 = solution;
        synchronized (solution2) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("-- before BT (" + ((Variable)variable).getName() + "): nrAssigned=" + this.iSolution.getModel().assignedVariables().size() + ",  value=" + this.iSolution.getModel().getTotalValue()));
            }
            ArrayList<V> variables2resolve = new ArrayList<V>(1);
            variables2resolve.add(variable);
            this.backtrack(variables2resolve, 0, this.iDepth);
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("-- after  BT (" + ((Variable)variable).getName() + "): nrAssigned=" + this.iSolution.getModel().assignedVariables().size() + ",  value=" + this.iSolution.getModel().getTotalValue()));
            }
        }
        this.iT1 = JProf.currentTimeMillis();
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("-- selected neighbour: " + this.iBackTrackNeighbour));
        }
        return this.iBackTrackNeighbour;
    }

    public long getTime() {
        return this.iT1 - this.iT0;
    }

    public boolean isTimeoutReached() {
        return this.iTimeoutReached;
    }

    public boolean isMaxItersReached() {
        return this.iMaxItersReached;
    }

    private boolean containsConstantValues(Collection<T> values) {
        for (Value value : values) {
            if (!(value.variable() instanceof ConstantVariable) || !((ConstantVariable)value.variable()).isConstant()) continue;
            return true;
        }
        return false;
    }

    protected Iterator<T> values(V variable) {
        return ((Variable)variable).values().iterator();
    }

    protected boolean checkBound(List<V> variables2resolve, int idx, int depth, T value, Set<T> conflicts) {
        int nrUnassigned = variables2resolve.size() - idx;
        if (nrUnassigned + conflicts.size() > depth) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"        -- too deap");
            }
            return false;
        }
        if (this.containsConstantValues(conflicts)) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"        -- contains constants values");
            }
            return false;
        }
        boolean containAssigned = false;
        Iterator<T> i = conflicts.iterator();
        while (!containAssigned && i.hasNext()) {
            Value conflict = (Value)i.next();
            int confIdx = variables2resolve.indexOf(conflict.variable());
            if (confIdx < 0 || confIdx > idx) continue;
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("        -- contains resolved variable " + conflict.variable()));
            }
            containAssigned = true;
        }
        return !containAssigned;
    }

    protected boolean canContinue(List<V> variables2resolve, int idx, int depth) {
        if (depth <= 0) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"    -- depth reached");
            }
            return false;
        }
        if (this.iTimeoutReached) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"    -- timeout reached");
            }
            return false;
        }
        if (this.iMaxItersReached) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"    -- max number of iterations reached");
            }
            return false;
        }
        return true;
    }

    protected boolean canContinueEvaluation() {
        return !this.iTimeoutReached && !this.iMaxItersReached;
    }

    protected void backtrack(List<V> variables2resolve, int idx, int depth) {
        int nrUnassigned;
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("  -- bt[" + depth + "]: " + idx + " of " + variables2resolve.size() + " " + variables2resolve));
        }
        if (!this.iTimeoutReached && this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)this.iTimeout) {
            this.iTimeoutReached = true;
        }
        if (!this.iMaxItersReached && this.iMaxIters > 0 && this.iNrIters++ > this.iMaxIters) {
            this.iMaxItersReached = true;
        }
        if ((nrUnassigned = variables2resolve.size() - idx) == 0) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)"    -- all assigned");
            }
            if (this.iSolution.getModel().assignedVariables().size() > this.iNrAssigned || this.iSolution.getModel().assignedVariables().size() == this.iNrAssigned && this.iValue > this.iSolution.getModel().getTotalValue()) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug((Object)"    -- better than current");
                }
                if (this.iBackTrackNeighbour == null || this.iBackTrackNeighbour.compareTo(this.iSolution) >= 0) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)"      -- better than best");
                    }
                    this.iBackTrackNeighbour = new BackTrackNeighbour(variables2resolve);
                }
            }
            return;
        }
        if (!this.canContinue(variables2resolve, idx, depth)) {
            return;
        }
        Variable variable = (Variable)variables2resolve.get(idx);
        if (sLog.isDebugEnabled()) {
            sLog.debug((Object)("    -- variable " + variable));
        }
        Iterator<T> e = this.values(variable);
        while (this.canContinueEvaluation() && e.hasNext()) {
            Value value = (Value)e.next();
            if (value.equals(variable.getAssignment())) continue;
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("      -- value " + value));
            }
            Set<Value> conflicts = this.iSolution.getModel().conflictValues(value);
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("      -- conflicts " + conflicts));
            }
            if (!this.checkBound(variables2resolve, idx, depth, value, conflicts)) continue;
            Object current = variable.getAssignment();
            ArrayList<V> newVariables2resolve = new ArrayList<V>(variables2resolve);
            for (Value conflict : conflicts) {
                ((Variable)conflict.variable()).unassign(0L);
                if (newVariables2resolve.contains(conflict.variable())) continue;
                newVariables2resolve.add(conflict.variable());
            }
            if (current != null) {
                ((Variable)((Value)current).variable()).unassign(0L);
            }
            ((Variable)value.variable()).assign(0L, (Value)value);
            this.backtrack(newVariables2resolve, idx + 1, depth - 1);
            if (current == null) {
                variable.unassign(0L);
            } else {
                variable.assign(0L, current);
            }
            for (Value conflict : conflicts) {
                ((Variable)conflict.variable()).assign(0L, (Value)conflict);
            }
        }
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public int getTimeout() {
        return this.iTimeout;
    }

    public void setTimeout(int timeout) {
        this.iTimeout = timeout;
    }

    public int getMaxIters() {
        return this.iMaxIters;
    }

    public void setMaxIters(int maxIters) {
        this.iMaxIters = maxIters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BackTrackNeighbour
    extends Neighbour<V, T> {
        private double iTotalValue = 0.0;
        private double iValue = 0.0;
        private List<T> iDifferentAssignments = null;

        public BackTrackNeighbour(List<V> resolvedVariables) {
            this.iTotalValue = BacktrackNeighbourSelection.this.iSolution.getModel().getTotalValue();
            this.iValue = 0.0;
            this.iDifferentAssignments = new ArrayList();
            for (Variable variable : resolvedVariables) {
                Object value = variable.getAssignment();
                this.iDifferentAssignments.add(value);
                this.iValue += ((Value)value).toDouble();
            }
        }

        public double getTotalValue() {
            return this.iTotalValue;
        }

        @Override
        public double value() {
            return this.iValue;
        }

        public List<T> getAssignments() {
            return this.iDifferentAssignments;
        }

        @Override
        public void assign(long iteration) {
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("-- before assignment: nrAssigned=" + BacktrackNeighbourSelection.this.iSolution.getModel().assignedVariables().size() + ",  value=" + BacktrackNeighbourSelection.this.iSolution.getModel().getTotalValue()));
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("  " + this));
            }
            int idx = 0;
            for (Value p : this.iDifferentAssignments) {
                if (((Variable)p.variable()).getAssignment() != null) {
                    if (idx > 0 && BacktrackNeighbourSelection.this.iStat != null) {
                        BacktrackNeighbourSelection.this.iStat.variableUnassigned(iteration, ((Variable)p.variable()).getAssignment(), (Value)this.iDifferentAssignments.get(0));
                    }
                    ((Variable)p.variable()).unassign(iteration);
                }
                ++idx;
            }
            for (Value p : this.iDifferentAssignments) {
                ((Variable)p.variable()).assign(iteration, (Value)p);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug((Object)("-- after assignment: nrAssigned=" + BacktrackNeighbourSelection.this.iSolution.getModel().assignedVariables().size() + ",  value=" + BacktrackNeighbourSelection.this.iSolution.getModel().getTotalValue()));
            }
        }

        public int compareTo(Solution<V, T> solution) {
            return Double.compare(this.iTotalValue, solution.getModel().getTotalValue());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("BT{value=" + (this.iTotalValue - BacktrackNeighbourSelection.this.iSolution.getModel().getTotalValue()) + ": ");
            Iterator e = this.iDifferentAssignments.iterator();
            while (e.hasNext()) {
                Value p = (Value)e.next();
                sb.append("\n    " + ((Variable)p.variable()).getName() + " " + p.getName() + (e.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

