/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViolatedInitials<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T> {
    private static Logger sLogger = Logger.getLogger(ViolatedInitials.class);
    private Map<T, Set<T>> iViolatedInitials = new HashMap<T, Set<T>>();

    public ViolatedInitials(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
    }

    public boolean init() {
        sLogger.info((Object)"Computation of violated initials enabled.");
        for (Variable variable : this.getModel().variables()) {
            if (variable.getInitialAssignment() == null) continue;
            for (Constraint constraint : variable.hardConstraints()) {
                for (Value value : this.conflictValues(constraint, variable.getInitialAssignment())) {
                    this.addViolatedInitial(value, variable.getInitialAssignment());
                }
            }
        }
        return true;
    }

    public Set<T> getViolatedInitials(T value) {
        return this.iViolatedInitials.get(value);
    }

    private void addViolatedInitial(T value, T anotherValue) {
        Set<T> violations = this.iViolatedInitials.get(value);
        if (violations == null) {
            violations = new HashSet<T>();
            this.iViolatedInitials.put(value, violations);
        }
        violations.add(anotherValue);
    }

    private List<T> conflictValues(Constraint<V, T> constraint, T aValue) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (Variable variable : constraint.variables()) {
            if (variable.equals(((Value)aValue).variable()) || variable.getAssignment() != null) continue;
            for (Value value : variable.values()) {
                if (constraint.isConsistent((Value)aValue, value)) continue;
                ret.add(value);
            }
        }
        return ret;
    }
}

