/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.extension.Assignment;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.ConstraintListener;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictStatistics<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T>
implements ConstraintListener<T> {
    private static final String PARAM_AGEING = "ConflictStatistics.Ageing";
    private static final String PARAM_HALF_AGE = "ConflictStatistics.AgeingHalfTime";
    private static final String PARAM_PRINT = "ConflictStatistics.Print";
    private double iAgeing = 1.0;
    private boolean iPrint = false;
    private Map<Assignment<T>, List<Assignment<T>>> iAssignments = new HashMap<Assignment<T>, List<Assignment<T>>>();
    private Map<V, List<Assignment<T>>> iUnassignedVariables = new HashMap<V, List<Assignment<T>>>();
    private Map<Assignment<T>, List<Assignment<T>>> iNoGoods = new HashMap<Assignment<T>, List<Assignment<T>>>();

    public ConflictStatistics(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iAgeing = properties.getPropertyDouble(PARAM_AGEING, this.iAgeing);
        int halfAge = properties.getPropertyInt(PARAM_HALF_AGE, 0);
        if (halfAge > 0) {
            this.iAgeing = Math.exp(Math.log(0.5) / (double)halfAge);
        }
        this.iPrint = properties.getPropertyBoolean(PARAM_PRINT, this.iPrint);
    }

    @Override
    public void register(Model<V, T> model) {
        super.register(model);
    }

    @Override
    public void unregister(Model<V, T> model) {
        super.unregister(model);
    }

    private void variableUnassigned(long iteration, T unassignedValue, Assignment<T> noGood) {
        if (iteration <= 0L) {
            return;
        }
        Assignment<T> unass = new Assignment<T>(iteration, unassignedValue, this.iAgeing);
        List<Assignment<T>> noGoodsForUnassignment = this.iNoGoods.get(unass);
        if (noGoodsForUnassignment != null) {
            if (noGoodsForUnassignment.contains(noGood)) {
                noGoodsForUnassignment.get(noGoodsForUnassignment.indexOf(noGood)).incCounter(iteration);
            } else {
                noGoodsForUnassignment.add(noGood);
            }
        } else {
            noGoodsForUnassignment = new ArrayList<Assignment<T>>();
            noGoodsForUnassignment.add(noGood);
            this.iNoGoods.put(unass, noGoodsForUnassignment);
        }
    }

    public void reset() {
        this.iUnassignedVariables.clear();
        this.iAssignments.clear();
    }

    public Map<Assignment<T>, List<Assignment<T>>> getNoGoods() {
        return this.iNoGoods;
    }

    public void variableUnassigned(long iteration, T unassignedValue, T assignedValue) {
        List<Object> asss;
        if (iteration <= 0L) {
            return;
        }
        Assignment<T> ass = new Assignment<T>(iteration, assignedValue, this.iAgeing);
        Assignment<T> unass = new Assignment<T>(iteration, unassignedValue, this.iAgeing);
        if (this.iAssignments.containsKey(unass)) {
            asss = this.iAssignments.get(unass);
            if (asss.contains(ass)) {
                ((Assignment)asss.get(asss.indexOf(ass))).incCounter(iteration);
            } else {
                asss.add(ass);
            }
        } else {
            asss = new ArrayList<Assignment<T>>();
            asss.add(ass);
            this.iAssignments.put(unass, asss);
        }
        if (this.iUnassignedVariables.containsKey(((Value)unassignedValue).variable())) {
            asss = this.iUnassignedVariables.get(((Value)unassignedValue).variable());
            if (asss.contains(ass)) {
                ((Assignment)asss.get(asss.indexOf(ass))).incCounter(iteration);
            } else {
                asss.add(ass);
            }
        } else {
            asss = new ArrayList();
            asss.add(ass);
            this.iUnassignedVariables.put((List<Object>)((Value)unassignedValue).variable(), (List<Assignment<T>>)asss);
        }
    }

    public double countRemovals(long iteration, Collection<T> conflictValues, T value) {
        long ret = 0L;
        for (Value conflictValue : conflictValues) {
            ret = (long)((double)ret + this.countRemovals(iteration, conflictValue, value));
        }
        return ret;
    }

    public double countRemovals(long iteration, T conflictValue, T value) {
        List<Assignment<T>> asss = this.iUnassignedVariables.get(((Value)conflictValue).variable());
        if (asss == null) {
            return 0.0;
        }
        Assignment<T> ass = new Assignment<T>(iteration, value, this.iAgeing);
        int idx = asss.indexOf(ass);
        if (idx < 0) {
            return 0.0;
        }
        return asss.get(idx).getCounter(iteration);
    }

    public long countPotentialConflicts(long iteration, T value, int limit) {
        List<Assignment<T>> asss = this.iAssignments.get(new Assignment<T>(iteration, value, this.iAgeing));
        if (asss == null) {
            return 0L;
        }
        long count = 0L;
        for (Assignment<T> ass : asss) {
            if (((Variable)((Value)ass.getValue()).variable()).getAssignment() != null) continue;
            if (limit >= 0) {
                count = (long)((double)count + ass.getCounter(iteration) * (double)Math.max(0, 1 + limit - ((Variable)((Value)value).variable()).getModel().conflictValues(ass.getValue()).size()));
                continue;
            }
            count = (long)((double)count + ass.getCounter(iteration));
        }
        return count;
    }

    private int countAssignments(V variable) {
        List<Assignment<T>> assignments = this.iUnassignedVariables.get(variable);
        if (assignments == null || assignments.isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (Assignment<T> assignment : assignments) {
            ret = (int)((double)ret + assignment.getCounter(0L));
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Statistics{");
        TreeSet<V> sortedUnassignedVariables = new TreeSet<V>(new Comparator<V>(){

            @Override
            public int compare(V v1, V v2) {
                int cmp = Double.compare(ConflictStatistics.this.countAssignments(v1), ConflictStatistics.this.countAssignments(v2));
                if (cmp != 0) {
                    return -cmp;
                }
                return ((Variable)v1).compareTo(v2);
            }
        });
        sortedUnassignedVariables.addAll(this.iUnassignedVariables.keySet());
        int printedVariables = 0;
        for (Variable variable : sortedUnassignedVariables) {
            sb.append("\n      ").append(this.countAssignments(variable) + "x ").append(variable.getName()).append(" <= {");
            TreeSet sortedAssignments = new TreeSet(new Assignment.AssignmentComparator(0L));
            sortedAssignments.addAll(this.iUnassignedVariables.get(variable));
            int printedAssignments = 0;
            for (Assignment x : sortedAssignments) {
                sb.append("\n        ").append(x.toString(0L, true));
                if (++printedAssignments != 20) continue;
                sb.append("\n        ...");
                break;
            }
            sb.append("\n      }");
            if (++printedVariables != 100) continue;
            sb.append("\n      ...");
            break;
        }
        sb.append("\n    }");
        return sb.toString();
    }

    @Override
    public void constraintBeforeAssigned(long iteration, Constraint<?, T> constraint, T assigned, Set<T> unassigned) {
    }

    @Override
    public void constraintAfterAssigned(long iteration, Constraint<?, T> constraint, T assigned, Set<T> unassigned) {
        if (iteration <= 0L) {
            return;
        }
        if (unassigned == null || unassigned.isEmpty()) {
            return;
        }
        if (this.iPrint) {
            Assignment<T> noGood = new Assignment<T>(iteration, assigned, this.iAgeing);
            noGood.setConstraint(constraint);
            for (Value unassignedValue : unassigned) {
                this.variableUnassigned(iteration, (T)unassignedValue, (T)noGood);
                this.variableUnassigned(iteration, unassignedValue, assigned);
            }
        } else {
            for (Value unassignedValue : unassigned) {
                this.variableUnassigned(iteration, unassignedValue, assigned);
            }
        }
    }

    @Override
    public void constraintAdded(Constraint<V, T> constraint) {
        constraint.addConstraintListener(this);
    }

    @Override
    public void constraintRemoved(Constraint<V, T> constraint) {
        constraint.removeConstraintListener(this);
    }
}

