/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.tt;

import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.ifs.example.tt.Activity;
import net.sf.cpsolver.ifs.example.tt.Location;
import net.sf.cpsolver.ifs.example.tt.TimetableModel;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource
extends Constraint<Activity, Location> {
    private String iName = null;
    private String iResourceId = null;
    private Activity[] iResource;
    private Set<Integer> iProhibitedSlots = new HashSet<Integer>();
    private Set<Integer> iDiscouragedSlots = new HashSet<Integer>();
    private int iType = 3;
    public static final int TYPE_ROOM = 0;
    public static final int TYPE_INSTRUCTOR = 1;
    public static final int TYPE_CLASS = 2;
    public static final int TYPE_OTHER = 3;

    public Resource(String id, int type, String name) {
        this.iResourceId = id;
        this.iName = name;
        this.iType = type;
    }

    @Override
    public void setModel(Model<Activity, Location> model) {
        super.setModel(model);
        TimetableModel m = (TimetableModel)model;
        this.iResource = new Activity[m.getNrDays() * m.getNrHours()];
        for (int i = 0; i < this.iResource.length; ++i) {
            this.iResource[i] = null;
        }
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public int getType() {
        return this.iType;
    }

    public Set<Integer> getProhibitedSlots() {
        return this.iProhibitedSlots;
    }

    public Set<Integer> getDiscouragedSlots() {
        return this.iDiscouragedSlots;
    }

    public void addProhibitedSlot(int day, int hour) {
        this.iProhibitedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addDiscouragedSlot(int day, int hour) {
        this.iDiscouragedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isProhibitedSlot(int day, int hour) {
        return this.iProhibitedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isDiscouragedSlot(int day, int hour) {
        return this.iDiscouragedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addProhibitedSlot(int slot) {
        this.iProhibitedSlots.add(slot);
    }

    public void addDiscouragedSlot(int slot) {
        this.iDiscouragedSlots.add(slot);
    }

    public boolean isProhibitedSlot(int slot) {
        return this.iProhibitedSlots.contains(slot);
    }

    public boolean isDiscouragedSlot(int slot) {
        return this.iDiscouragedSlots.contains(slot);
    }

    public boolean isProhibited(int day, int hour, int length) {
        int slot = ((TimetableModel)this.getModel()).getNrHours() * day + hour;
        for (int i = 0; i < length; ++i) {
            if (!this.iProhibitedSlots.contains(slot + i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void computeConflicts(Location location, Set<Location> conflicts) {
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            Activity conf = this.iResource[i];
            if (conf == null || activity.equals(conf)) continue;
            conflicts.add((Location)conf.getAssignment());
        }
    }

    @Override
    public boolean inConflict(Location location) {
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return false;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            if (this.iResource[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location l1, Location l2) {
        return !l1.containResource(this) || !l2.containResource(this) || !l1.hasIntersection(l2);
    }

    @Override
    public void assigned(long iteration, Location location) {
        super.assigned(iteration, location);
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            this.iResource[i] = activity;
        }
    }

    @Override
    public void unassigned(long iteration, Location location) {
        super.unassigned(iteration, location);
        Activity activity = (Activity)location.variable();
        if (!location.containResource(this)) {
            return;
        }
        for (int i = location.getSlot(); i < location.getSlot() + activity.getLength(); ++i) {
            this.iResource[i] = null;
        }
    }
}

