/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.tt;

import java.util.Set;
import net.sf.cpsolver.ifs.example.tt.Activity;
import net.sf.cpsolver.ifs.example.tt.Location;
import net.sf.cpsolver.ifs.model.BinaryConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dependence
extends BinaryConstraint<Activity, Location> {
    public static final int TYPE_NO_DEPENDENCE = 0;
    public static final int TYPE_BEFORE = 1;
    public static final int TYPE_CLOSELY_BEFORE = 2;
    public static final int TYPE_AFTER = 3;
    public static final int TYPE_CLOSELY_AFTER = 4;
    public static final int TYPE_CONCURRENCY = 5;
    private int iType = 0;
    private String iResourceId = null;

    public Dependence(String id, int type) {
        this.iType = type;
        this.iResourceId = id;
    }

    public int getType() {
        return this.iType;
    }

    public String getResourceId() {
        return this.iResourceId;
    }

    @Override
    public void computeConflicts(Location location, Set<Location> conflicts) {
        Activity activity = (Activity)location.variable();
        Activity another = this.another(activity);
        Location anotherLocation = (Location)another.getAssignment();
        if (anotherLocation == null) {
            return;
        }
        if (this.isFirst(activity)) {
            if (!this.isConsistent(location.getSlot(), activity.getLength(), anotherLocation.getSlot(), another.getLength())) {
                conflicts.add(anotherLocation);
            }
        } else if (!this.isConsistent(anotherLocation.getSlot(), another.getLength(), location.getSlot(), activity.getLength())) {
            conflicts.add(anotherLocation);
        }
    }

    public boolean isConsistent(int s1, int l1, int s2, int l2) {
        switch (this.iType) {
            case 1: {
                return s1 + l1 <= s2;
            }
            case 2: {
                return s1 + l1 == s2;
            }
            case 3: {
                return s2 + l2 <= s1;
            }
            case 4: {
                return s2 + l2 == s1;
            }
            case 5: {
                return s1 <= s2 && s2 + l2 <= s1 + l1 || s2 <= s1 && s1 + l1 <= s2 + l2;
            }
        }
        return true;
    }

    @Override
    public boolean inConflict(Location location) {
        Activity activity = (Activity)location.variable();
        Activity another = this.another(activity);
        Location anotherLocation = (Location)another.getAssignment();
        if (anotherLocation == null) {
            return false;
        }
        if (this.isFirst(activity)) {
            return !this.isConsistent(location.getSlot(), activity.getLength(), anotherLocation.getSlot(), another.getLength());
        }
        return !this.isConsistent(anotherLocation.getSlot(), another.getLength(), location.getSlot(), activity.getLength());
    }

    @Override
    public boolean isConsistent(Location l1, Location l2) {
        Activity a1 = (Activity)l1.variable();
        Activity a2 = (Activity)l2.variable();
        if (this.isFirst(a1)) {
            return !this.isConsistent(l1.getSlot(), a1.getLength(), l2.getSlot(), a2.getLength());
        }
        return !this.isConsistent(l2.getSlot(), a2.getLength(), l1.getSlot(), a1.getLength());
    }

    @Override
    public String getName() {
        switch (this.iType) {
            case 1: {
                return ((Activity)this.first()).getName() + "<" + ((Activity)this.second()).getName();
            }
            case 2: {
                return ((Activity)this.first()).getName() + "<|" + ((Activity)this.second()).getName();
            }
            case 3: {
                return ((Activity)this.first()).getName() + ">" + ((Activity)this.second()).getName();
            }
            case 4: {
                return ((Activity)this.first()).getName() + "|>" + ((Activity)this.second()).getName();
            }
            case 5: {
                return ((Activity)this.first()).getName() + "||" + ((Activity)this.second()).getName();
            }
        }
        return ((Activity)this.first()).getName() + "?" + ((Activity)this.second()).getName();
    }
}

