/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.tt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.ifs.example.tt.Location;
import net.sf.cpsolver.ifs.example.tt.Resource;
import net.sf.cpsolver.ifs.example.tt.TimetableModel;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activity
extends Variable<Activity, Location> {
    private int iLength = 1;
    private String iActivityId = null;
    private String iName = null;
    private ArrayList<List<Resource>> iResorces = new ArrayList();
    private Set<Integer> iProhibitedSlots = new HashSet<Integer>();
    private Set<Integer> iDiscouragedSlots = new HashSet<Integer>();

    public Activity(int length, String id, String name) {
        super(null);
        this.iLength = length;
        this.iActivityId = id;
        this.iName = name;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String getActivityId() {
        return this.iActivityId;
    }

    public int getLength() {
        return this.iLength;
    }

    public void addResourceGroup(List<Resource> resources) {
        for (Resource r : resources) {
            r.addVariable(this);
        }
        this.iResorces.add(resources);
    }

    public void addResourceGroup(Resource[] resources) {
        ArrayList<Resource> rg = new ArrayList<Resource>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            rg.add(resources[i]);
            resources[i].addVariable(this);
        }
        this.iResorces.add(rg);
    }

    public void addResourceGroup(Resource resource) {
        ArrayList<Resource> rg = new ArrayList<Resource>(1);
        rg.add(resource);
        this.iResorces.add(rg);
        resource.addVariable(this);
    }

    public List<Resource> getResourceGroup(int idx) {
        return this.iResorces.get(idx);
    }

    public List<List<Resource>> getResourceGroups() {
        return this.iResorces;
    }

    public Set<Integer> getProhibitedSlots() {
        return this.iProhibitedSlots;
    }

    public Set<Integer> getDiscouragedSlots() {
        return this.iDiscouragedSlots;
    }

    public void addProhibitedSlot(int day, int hour) {
        this.iProhibitedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addDiscouragedSlot(int day, int hour) {
        this.iDiscouragedSlots.add(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isProhibitedSlot(int day, int hour) {
        return this.iProhibitedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public boolean isDiscouragedSlot(int day, int hour) {
        return this.iDiscouragedSlots.contains(((TimetableModel)this.getModel()).getNrHours() * day + hour);
    }

    public void addProhibitedSlot(int slot) {
        this.iProhibitedSlots.add(slot);
    }

    public void addDiscouragedSlot(int slot) {
        this.iDiscouragedSlots.add(slot);
    }

    public boolean isProhibitedSlot(int slot) {
        return this.iProhibitedSlots.contains(slot);
    }

    public boolean isDiscouragedSlot(int slot) {
        return this.iDiscouragedSlots.contains(slot);
    }

    public boolean isProhibited(int day, int hour, int length) {
        int slot = ((TimetableModel)this.getModel()).getNrHours() * day + hour;
        for (int i = 0; i < length; ++i) {
            if (!this.iProhibitedSlots.contains(slot + i)) continue;
            return true;
        }
        return false;
    }

    public void init() {
        this.setValues(this.computeValues());
    }

    private void addValues(Collection<Location> values, int day, int hour, int level, Resource[] resources) {
        if (level == this.getResourceGroups().size()) {
            values.add(new Location(this, day, hour, (Resource[])resources.clone()));
            return;
        }
        Collection rg = this.getResourceGroups().get(level);
        for (Resource r : rg) {
            if (r.isProhibited(day, hour, this.getLength())) continue;
            resources[level] = r;
            this.addValues(values, day, hour, level + 1, resources);
        }
    }

    public List<Location> computeValues() {
        ArrayList<Location> values = new ArrayList<Location>();
        Resource[] res = new Resource[this.getResourceGroups().size()];
        for (int day = 0; day < ((TimetableModel)this.getModel()).getNrDays(); ++day) {
            for (int hour = 0; hour <= ((TimetableModel)this.getModel()).getNrHours() - this.getLength(); ++hour) {
                if (this.isProhibited(day, hour, this.getLength())) continue;
                this.addValues(values, day, hour, 0, res);
            }
        }
        return values;
    }
}

