/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.jobshop;

import java.util.ArrayList;
import java.util.List;
import net.sf.cpsolver.ifs.example.jobshop.Job;
import net.sf.cpsolver.ifs.example.jobshop.JobShopModel;
import net.sf.cpsolver.ifs.example.jobshop.Location;
import net.sf.cpsolver.ifs.example.jobshop.Machine;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
extends Variable<Operation, Location> {
    private Job iJob = null;
    private Machine iMachine = null;
    private int iProcessingTime = 0;
    private int iOperationNumber = 0;

    public Operation(Job job, Machine machine, int operationNumber, int processingTime) {
        super(null);
        this.iJob = job;
        this.iMachine = machine;
        this.iProcessingTime = processingTime;
        this.iOperationNumber = operationNumber;
    }

    public Job getJob() {
        return this.iJob;
    }

    public int getJobNumber() {
        return this.iJob.getJobNumner();
    }

    public int getOperationNumber() {
        return this.iOperationNumber;
    }

    public Machine getMachine() {
        return this.iMachine;
    }

    public int getMachineNumber() {
        return this.iMachine.getMachineNumber();
    }

    public int getProcessingTime() {
        return this.iProcessingTime;
    }

    public Operation getPrecedingOperation() {
        return this.iOperationNumber == 0 ? null : this.iJob.getOperation(this.iOperationNumber - 1);
    }

    public Operation getSubsequentOperation() {
        return this.iOperationNumber + 1 == this.iJob.countOperations() ? null : this.iJob.getOperation(this.iOperationNumber + 1);
    }

    public int getMinStartTime() {
        if (this.iOperationNumber == 0) {
            return 0;
        }
        return this.getPrecedingOperation().getMinStartTime() + this.iProcessingTime;
    }

    public int getMaxStartTime() {
        if (this.iOperationNumber + 1 == this.iJob.countOperations()) {
            return ((JobShopModel)this.getModel()).getTotalNumberOfSlots() - this.iProcessingTime;
        }
        return this.getSubsequentOperation().getMaxStartTime() - this.iProcessingTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)o;
        return this.getJobNumber() == op.getJobNumber() && this.getOperationNumber() == op.getOperationNumber();
    }

    public void init() {
        this.setValues(this.computeValues());
    }

    private List<Location> computeValues() {
        ArrayList<Location> ret = new ArrayList<Location>();
        for (int i = this.getMinStartTime(); i <= this.getMaxStartTime(); ++i) {
            ret.add(new Location(this, i));
        }
        return ret;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "O[" + this.getJobNumber() + "," + this.getOperationNumber() + "]";
    }
}

