/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.csp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.cpsolver.ifs.example.csp.CSPBinaryConstraint;
import net.sf.cpsolver.ifs.example.csp.CSPModel;
import net.sf.cpsolver.ifs.example.csp.CSPValue;
import net.sf.cpsolver.ifs.example.csp.CSPVariable;
import net.sf.cpsolver.ifs.example.csp.StructuredCSPModel;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ProgressWriter;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

public class Test {
    private static DecimalFormat sDoubleFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("dd-MMM-yy_HHmmss", Locale.US);
    private static Logger sLogger = Logger.getLogger(Test.class);

    private static void test(DataProperties properties) throws Exception {
        boolean sameProblemStep = properties.getPropertyBoolean("CSP.SameProblemEachStep", false);
        boolean sameProblemTest = properties.getPropertyBoolean("CSP.SameProblemEachTest", false);
        int nrVars = properties.getPropertyInt("CSP.NrVariables", 20);
        int nrKernels = properties.getPropertyInt("CSP.NrKernels", 2);
        int nrKernelVariables = properties.getPropertyInt("CSP.KernelSize", 8);
        int nrVariablesMin = properties.getPropertyInt("CSP.NrVariablesMin", nrVars);
        int nrVariablesMax = properties.getPropertyInt("CSP.NrVariablesMax", nrVars);
        int nrVariablesStep = properties.getPropertyInt("CSP.NrVariablesStep", 1);
        int nrValues = properties.getPropertyInt("CSP.DomainSize", 10);
        double nrValuesRatio = properties.getPropertyDouble("CSP.DomainSizeRatio", -1.0);
        float kernelTightness = properties.getPropertyFloat("CSP.KernelTightness", 0.097f);
        float kernelDensity = properties.getPropertyFloat("CSP.KernelDensity", 0.097f);
        float tightnessInit = properties.getPropertyFloat("CSP.Tightness", 0.4f);
        float tightnessMin = properties.getPropertyFloat("CSP.TightnessMin", tightnessInit);
        float tightnessMax = properties.getPropertyFloat("CSP.TightnessMax", tightnessInit) + 1.0E-6f;
        float tightnessStep = properties.getPropertyFloat("CSP.TightnessStep", 0.1f);
        float densityInit = properties.getPropertyFloat("CSP.Density", 0.4f);
        float densityMin = properties.getPropertyFloat("CSP.DensityMin", densityInit);
        float densityMax = properties.getPropertyFloat("CSP.DensityMax", densityInit) + 1.0E-6f;
        float densityStep = properties.getPropertyFloat("CSP.DensityStep", 0.1f);
        long seed = properties.getPropertyLong("CSP.Seed", System.currentTimeMillis());
        int nrTests = properties.getPropertyInt("CPS.NrTests", 10);
        boolean mpp = properties.getPropertyBoolean("General.MPP", false);
        PrintWriter logStat = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "rcsp_" + nrVariablesMin + "_" + nrValues + ".csv"));
        PrintWriter logAvgStat = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "avg_stat.csv"));
        PrintWriter log = new PrintWriter(new FileWriter(properties.getProperty("General.Output") + File.separator + "info.txt"));
        logStat.println("testNr;nrVars;nrVals;density[%];tightness[%];time[s];iters;speed[it/s];unassConstr;assigned;assigned[%]" + (mpp ? ";perts;perts[%]" : "") + ";value;totalValue");
        logAvgStat.println("nrVars;nrVals;density[%];tightness[%];time[s];RMStime[s];iters;RMSiters;speed[it/s];unassConst;assigned;RMSassigned;assigned[%]" + (mpp ? ";perts;RMSperts;perts[%]" : "") + ";value;RMSvalue;totalValue;RMStotalValue");
        System.out.println("Number of variables: " + nrVariablesMin + " .. " + nrVariablesMax + "  (step=" + nrVariablesStep + ")");
        System.out.println("Density:             " + densityMin + " .. " + densityMax + "  (step=" + densityStep + ")");
        System.out.println("Tightness:           " + tightnessMin + " .. " + tightnessMax + "  (step=" + tightnessStep + ")");
        for (int nrVariables = nrVariablesMin; nrVariables <= nrVariablesMax; nrVariables += nrVariablesStep) {
            if (nrValuesRatio > 0.0) {
                nrValues = (int)Math.round(nrValuesRatio * (double)nrVariables);
            }
            for (float density = densityMin; density <= densityMax; density += densityStep) {
                for (float tightness = tightnessMin; tightness <= tightnessMax; tightness += tightnessStep) {
                    log.println("CSP{#Var=" + nrVariables + ", #Val=" + nrValues + ", P(density)=" + sDoubleFormat.format(100.0 * (double)density) + "%, P(tighness)=" + sDoubleFormat.format(100.0 * (double)tightness) + ", " + nrKernels + "x Kernel{#Var=" + nrKernelVariables + ", P(density)=" + sDoubleFormat.format(100.0 * (double)kernelDensity) + "%, P(tighness)=" + sDoubleFormat.format(100.0 * (double)kernelTightness) + "%}}");
                    double sumTime = 0.0;
                    double sumTime2 = 0.0;
                    int sumIters = 0;
                    int sumIters2 = 0;
                    int sumConfl = 0;
                    int sumAssign = 0;
                    int sumAssign2 = 0;
                    int sumPert = 0;
                    int sumPert2 = 0;
                    int sumVal = 0;
                    int sumVal2 = 0;
                    int sumTotalVal = 0;
                    int sumTotalVal2 = 0;
                    for (int test = 1; test <= nrTests; ++test) {
                        log.println("  " + test + ". test");
                        log.flush();
                        properties.setProperty("CSP.NrVariables", String.valueOf(nrVariables));
                        properties.setProperty("CSP.Tightness", String.valueOf(tightness));
                        properties.setProperty("CSP.Density", String.valueOf(density));
                        long currentSeed = seed * 1000000L + 1000L * (long)((double)(sameProblemStep ? densityMin : density) * 1000.0) + (long)((double)(sameProblemStep ? tightnessMin : tightness) * 1000.0);
                        currentSeed = currentSeed * (long)nrTests + (long)(sameProblemTest ? 0 : test - 1);
                        sLogger.debug((Object)("Seed: " + currentSeed));
                        StructuredCSPModel csp = new StructuredCSPModel(properties, currentSeed);
                        Solver<CSPVariable, CSPValue> s = new Solver<CSPVariable, CSPValue>(properties);
                        s.setInitalSolution(csp);
                        s.currentSolution().clearBest();
                        s.start();
                        try {
                            s.getSolverThread().join();
                        }
                        catch (NullPointerException npe) {
                            // empty catch block
                        }
                        if (s.lastSolution().getBestInfo() == null) {
                            sLogger.error((Object)"No solution found :-(");
                        }
                        sLogger.debug((Object)("Last solution:" + s.lastSolution().getInfo()));
                        Solution best = s.lastSolution();
                        sLogger.debug((Object)("Best solution:" + s.lastSolution().getBestInfo()));
                        best.restoreBest();
                        int val = 0;
                        Iterator iv = best.getModel().assignedVariables().iterator();
                        while (iv.hasNext()) {
                            val += (int)((CSPValue)((CSPVariable)iv.next()).getAssignment()).toDouble();
                        }
                        int totalVal = val + best.getModel().unassignedVariables().size() * nrValues;
                        sLogger.debug((Object)("Last solution:" + best.getInfo()));
                        logStat.println(test + ";" + nrVariables + ";" + nrValues + ";" + sDoubleFormat.format(density) + ";" + sDoubleFormat.format(tightness) + ";" + sDoubleFormat.format(best.getTime()) + ";" + best.getIteration() + ";" + sDoubleFormat.format((double)best.getIteration() / best.getTime()) + ";" + best.getModel().unassignedHardConstraints().size() + ";" + best.getModel().assignedVariables().size() + ";" + sDoubleFormat.format(100.0 * (double)best.getModel().assignedVariables().size() / (double)best.getModel().variables().size()) + (mpp ? ";" + (best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size()) + ";" + sDoubleFormat.format(100.0 * (double)(best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size()) / (double)best.getModel().variables().size()) : "") + ";" + val + ";" + totalVal);
                        log.println("    seed:         " + currentSeed);
                        log.println("    constraints:  " + best.getModel().constraints().size());
                        for (CSPBinaryConstraint cSPBinaryConstraint : best.getModel().constraints()) {
                            log.println("      " + cSPBinaryConstraint.getName() + " (" + ((CSPVariable)cSPBinaryConstraint.first()).getName() + "," + ((CSPVariable)cSPBinaryConstraint.second()).getName() + ")");
                            for (CSPValue v0 : ((CSPVariable)cSPBinaryConstraint.first()).values()) {
                                log.print("        ");
                                for (CSPValue v1 : ((CSPVariable)cSPBinaryConstraint.second()).values()) {
                                    log.print(cSPBinaryConstraint.isConsistent(v0, v1) ? "1 " : "0 ");
                                }
                            }
                            log.println();
                        }
                        log.println("    time:         " + sDoubleFormat.format(best.getTime()) + " s");
                        log.println("    iteration:    " + best.getIteration());
                        log.println("    speed:        " + sDoubleFormat.format((double)best.getIteration() / best.getTime()) + " it/s");
                        log.println("    assigned:     " + best.getModel().assignedVariables().size() + " (" + sDoubleFormat.format(100.0 * (double)best.getModel().assignedVariables().size() / (double)best.getModel().variables().size()) + "%)");
                        log.println("    total value:  " + val);
                        if (mpp) {
                            log.println("    perturbations:" + (best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size()) + " (" + sDoubleFormat.format(100.0 * (double)(best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size()) / (double)best.getModel().variables().size()) + "%)");
                        }
                        log.print("    solution:     ");
                        for (CSPVariable cSPVariable : ((CSPModel)best.getModel()).variables()) {
                            if (cSPVariable.getBestAssignment() == null) continue;
                            log.print(cSPVariable.getName() + "=" + ((CSPValue)cSPVariable.getBestAssignment()).getName());
                            log.print(", ");
                        }
                        log.println();
                        sumTime += best.getTime();
                        sumTime2 += best.getTime() * best.getTime();
                        sumIters = (int)((long)sumIters + best.getIteration());
                        sumIters2 = (int)((long)sumIters2 + best.getIteration() * best.getIteration());
                        sumConfl += best.getModel().unassignedHardConstraints().size();
                        sumAssign += best.getModel().assignedVariables().size();
                        sumAssign2 += best.getModel().assignedVariables().size() * best.getModel().assignedVariables().size();
                        sumVal += val;
                        sumVal2 += val * val;
                        sumTotalVal += totalVal;
                        sumTotalVal2 += totalVal * totalVal;
                        if (mpp) {
                            sumPert += best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size();
                            sumPert2 += (best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size()) * (best.getModel().perturbVariables().size() + best.getModel().unassignedVariables().size());
                        }
                        log.flush();
                        logStat.flush();
                    }
                    logAvgStat.println(nrVariables + ";" + nrValues + ";" + sDoubleFormat.format(density) + ";" + sDoubleFormat.format(tightness) + ";" + sDoubleFormat.format(sumTime / (double)nrTests) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, sumTime, sumTime2)) + ";" + sDoubleFormat.format((double)sumIters / (double)nrTests) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, sumIters, sumIters2)) + ";" + sDoubleFormat.format((double)sumIters / sumTime) + ";" + sDoubleFormat.format((double)sumConfl / (double)nrTests) + ";" + sDoubleFormat.format((double)sumAssign / (double)nrTests) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, sumAssign, sumAssign2)) + ";" + sDoubleFormat.format(100.0 * (double)sumAssign / (double)(nrVariables * nrTests)) + (mpp ? ";" + sDoubleFormat.format((double)sumPert / (double)nrTests) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, sumPert, sumPert2)) + ";" + sDoubleFormat.format(100.0 * (double)sumPert / (double)(nrVariables * nrTests)) : "") + ";" + sDoubleFormat.format((double)sumVal / (double)(nrTests * nrVariables)) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, (double)sumVal / (double)nrVariables, (double)sumVal2 / (double)(nrVariables * nrVariables))) + ";" + sDoubleFormat.format((double)sumTotalVal / (double)nrTests) + ";" + sDoubleFormat.format(ToolBox.rms(nrTests, sumTotalVal, sumTotalVal2)));
                    logAvgStat.flush();
                }
            }
        }
        log.flush();
        log.close();
        logStat.flush();
        logStat.close();
        logAvgStat.flush();
        logAvgStat.close();
    }

    private static void test(File inputCfg, String name, String include, String regexp, String outDir) throws Exception {
        if (regexp != null) {
            String incFile;
            if (regexp.indexOf(59) > 0) {
                incFile = regexp.substring(0, regexp.indexOf(59));
                regexp = regexp.substring(regexp.indexOf(59) + 1);
            } else {
                incFile = regexp;
                regexp = null;
            }
            if (incFile.startsWith("[") && incFile.endsWith("]")) {
                Test.test(inputCfg, name, include, regexp, outDir);
                incFile = incFile.substring(1, incFile.length() - 1);
            }
            if (incFile.indexOf(123) >= 0 && incFile.indexOf(125) >= 0) {
                String prefix = incFile.substring(0, incFile.indexOf(123));
                StringTokenizer middle = new StringTokenizer(incFile.substring(incFile.indexOf(123) + 1, incFile.indexOf(125)), "|");
                String sufix = incFile.substring(incFile.indexOf(125) + 1);
                while (middle.hasMoreTokens()) {
                    String m = middle.nextToken();
                    Test.test(inputCfg, (name == null ? "" : name + "_") + m, (include == null ? "" : include + ";") + prefix + m + sufix, regexp, outDir);
                }
            } else {
                Test.test(inputCfg, name, (include == null ? "" : include + ";") + incFile, regexp, outDir);
            }
        } else {
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            StringTokenizer inc = new StringTokenizer(include, ";");
            while (inc.hasMoreTokens()) {
                String aFile = inc.nextToken();
                System.out.println("  Loading included file '" + aFile + "' ... ");
                FileInputStream is = null;
                if (new File(aFile).exists()) {
                    is = new FileInputStream(aFile);
                }
                if (new File(inputCfg.getParent() + File.separator + aFile).exists()) {
                    is = new FileInputStream(inputCfg.getParent() + File.separator + aFile);
                }
                if (is == null) {
                    System.err.println("Unable to find include file '" + aFile + "'.");
                }
                properties.load(is);
                is.close();
            }
            String outDirThisTest = (outDir == null ? properties.getProperty("General.Output", ".") : outDir) + File.separator + name + File.separator + sDateFormat.format(new Date());
            properties.setProperty("General.Output", outDirThisTest.toString());
            System.out.println("Output folder: " + properties.getProperty("General.Output"));
            new File(outDirThisTest).mkdirs();
            ToolBox.configureLogging(outDirThisTest, null);
            FileOutputStream fos = new FileOutputStream(outDirThisTest + File.separator + "rcsp.conf");
            properties.store(fos, "Random CSP problem configuration file");
            fos.flush();
            fos.close();
            Test.test(properties);
        }
    }

    public static void main(String[] args) {
        try {
            Progress.getInstance().addProgressListener(new ProgressWriter(System.out));
            File inputCfg = new File(args[0]);
            DataProperties properties = ToolBox.loadProperties(inputCfg);
            if (properties.getProperty("INCLUDE_REGEXP") != null) {
                Test.test(inputCfg, null, null, properties.getProperty("INCLUDE_REGEXP"), args.length > 1 ? args[1] : null);
            } else {
                String outDir = properties.getProperty("General.Output", ".") + File.separator + inputCfg.getName().substring(0, inputCfg.getName().lastIndexOf(46)) + File.separator + sDateFormat.format(new Date());
                if (args.length > 1) {
                    outDir = args[1] + File.separator + sDateFormat.format(new Date());
                }
                properties.setProperty("General.Output", outDir.toString());
                System.out.println("Output folder: " + properties.getProperty("General.Output"));
                new File(outDir).mkdirs();
                ToolBox.configureLogging(outDir, null);
                Test.test(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

