/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.csp;

import net.sf.cpsolver.ifs.example.csp.CSPModel;
import net.sf.cpsolver.ifs.example.csp.CSPValue;
import net.sf.cpsolver.ifs.example.csp.CSPVariable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.BasicConfigurator;

public class SimpleTest {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        int nrVariables = 25;
        int nrValues = 12;
        int nrConstraints = 198;
        double tigtness = 0.25;
        int nrAllPairs = nrValues * nrValues;
        int nrCompatiblePairs = (int)((1.0 - tigtness) * (double)nrAllPairs);
        long seed = System.currentTimeMillis();
        System.out.println("CSP(" + nrVariables + "," + nrValues + "," + nrConstraints + "/" + nrVariables * (nrVariables - 1) / 2 + "," + (nrAllPairs - nrCompatiblePairs) + "/" + nrAllPairs + ")");
        DataProperties cfg = new DataProperties();
        cfg.setProperty("Termination.Class", "net.sf.cpsolver.ifs.termination.GeneralTerminationCondition");
        cfg.setProperty("Termination.StopWhenComplete", "true");
        cfg.setProperty("Termination.TimeOut", "60");
        cfg.setProperty("Comparator.Class", "net.sf.cpsolver.ifs.solution.GeneralSolutionComparator");
        cfg.setProperty("Value.Class", "net.sf.cpsolver.ifs.heuristics.GeneralValueSelection");
        cfg.setProperty("Value.WeightConflicts", "1");
        cfg.setProperty("Variable.Class", "net.sf.cpsolver.ifs.heuristics.GeneralVariableSelection");
        cfg.setProperty("Extensions.Classes", "net.sf.cpsolver.ifs.extension.ConflictStatistics");
        CSPModel model = new CSPModel(nrVariables, nrValues, nrConstraints, nrCompatiblePairs, seed);
        Solver<CSPVariable, CSPValue> solver = new Solver<CSPVariable, CSPValue>(cfg);
        solver.setInitalSolution(model);
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Solution solution = solver.lastSolution();
        solution.restoreBest();
        System.out.println("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations).");
        System.out.println("Number of assigned variables is " + solution.getModel().assignedVariables().size());
        System.out.println("Total value of the solution is " + solution.getModel().getTotalValue());
        int idx = 1;
        for (CSPVariable v : ((CSPModel)solution.getModel()).variables()) {
            if (v.getAssignment() == null) continue;
            System.out.println("Var" + idx++ + "=" + ((CSPValue)v.getAssignment()).toDouble());
        }
    }
}

