/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.csp;

import java.util.Random;
import java.util.Set;
import net.sf.cpsolver.ifs.example.csp.CSPValue;
import net.sf.cpsolver.ifs.example.csp.CSPVariable;
import net.sf.cpsolver.ifs.model.BinaryConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSPBinaryConstraint
extends BinaryConstraint<CSPVariable, CSPValue> {
    private boolean[][] iIsConsistent = null;
    private int iNrCompatiblePairs;

    public CSPBinaryConstraint(int id, int nrCompatiblePairs) {
        this.iId = id;
        this.iNrCompatiblePairs = nrCompatiblePairs;
    }

    private void swap(int[][] allPairs, int first, int second) {
        int[] a = allPairs[first];
        allPairs[first] = allPairs[second];
        allPairs[second] = a;
    }

    public void init(Random rndNumGen) {
        int numberOfAllPairs = ((CSPVariable)this.first()).values().size() * ((CSPVariable)this.second()).values().size();
        int[][] allPairs = new int[numberOfAllPairs][];
        int idx = 0;
        this.iIsConsistent = new boolean[((CSPVariable)this.first()).values().size()][((CSPVariable)this.second()).values().size()];
        for (CSPValue v1 : ((CSPVariable)this.first()).values()) {
            for (CSPValue v2 : ((CSPVariable)this.second()).values()) {
                this.iIsConsistent[(int)v1.toDouble()][(int)v2.toDouble()] = false;
                allPairs[idx++] = new int[]{(int)v1.toDouble(), (int)v2.toDouble()};
            }
        }
        for (int i = 0; i < this.iNrCompatiblePairs; ++i) {
            this.swap(allPairs, i, i + (int)(rndNumGen.nextDouble() * (double)(numberOfAllPairs - i)));
            this.iIsConsistent[allPairs[i][0]][allPairs[i][1]] = true;
        }
    }

    @Override
    public boolean isConsistent(CSPValue value1, CSPValue value2) {
        if (value1 == null || value2 == null) {
            return true;
        }
        if (this.isFirst(value1.variable())) {
            return this.iIsConsistent[(int)value1.toDouble()][(int)value2.toDouble()];
        }
        return this.iIsConsistent[(int)value2.toDouble()][(int)value1.toDouble()];
    }

    @Override
    public void computeConflicts(CSPValue aValue, Set<CSPValue> conflicts) {
        if (this.isFirst(aValue.variable())) {
            if (!this.isConsistent(aValue, (CSPValue)((CSPVariable)this.second()).getAssignment())) {
                conflicts.add((CSPValue)((CSPVariable)this.second()).getAssignment());
            }
        } else if (!this.isConsistent((CSPValue)((CSPVariable)this.first()).getAssignment(), aValue)) {
            conflicts.add((CSPValue)((CSPVariable)this.first()).getAssignment());
        }
    }

    @Override
    public String getName() {
        return "C" + this.getId();
    }
}

