/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.dbt;

import java.util.HashSet;
import net.sf.cpsolver.ifs.extension.MacPropagation;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.solver.SolverListener;
import net.sf.cpsolver.ifs.util.DataProperties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbtPropagation<V extends Variable<V, T>, T extends Value<V, T>>
extends MacPropagation<V, T>
implements SolverListener<V, T> {
    private static Logger sLogger = Logger.getLogger(DbtPropagation.class);

    public DbtPropagation(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        solver.addSolverListener(this);
    }

    @Override
    public void afterAssigned(long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.warn((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value assigned (noGood:" + this.noGood(value) + ")"));
            this.setGood(value);
        }
        HashSet<T> noGood = new HashSet<T>(1);
        noGood.add(value);
        for (Value anotherValue : ((Variable)((Value)value).variable()).values()) {
            if (anotherValue.equals(value) || !this.isGood(anotherValue)) continue;
            this.setNoGood(anotherValue, noGood);
        }
        this.propagate(((Value)value).variable());
    }

    @Override
    public void afterUnassigned(long iteration, T value) {
        this.iIteration = iteration;
        if (!this.isGood(value)) {
            sLogger.error((Object)(((Variable)((Value)value).variable()).getName() + " = " + ((Value)value).getName() + " -- not good value unassigned (noGood:" + this.noGood(value) + ")"));
        }
        this.undoPropagate(((Value)value).variable());
    }

    @Override
    public boolean variableSelected(long iteration, V variable) {
        if (variable == null) {
            sLogger.debug((Object)"No variable selected -> backtrack.");
            Variable lastVariable = null;
            for (Object var : this.getModel().assignedVariables()) {
                if (lastVariable != null && ((Value)lastVariable.getAssignment()).lastAssignmentIteration() >= ((Value)((Variable)var).getAssignment()).lastAssignmentIteration()) continue;
                lastVariable = var;
            }
            if (lastVariable == null) {
                sLogger.error((Object)"No assignment -> fail");
                this.getSolver().stopSolver();
                return false;
            }
            sLogger.debug((Object)("Unassign:" + lastVariable.getName()));
            HashSet noGoods = new HashSet();
            for (Variable var : this.getModel().assignedVariables()) {
                if (var.equals(lastVariable)) continue;
                noGoods.add(var.getAssignment());
            }
            Object value = lastVariable.getAssignment();
            lastVariable.unassign(iteration);
            this.setNoGood(value, noGoods);
            return false;
        }
        if (((Variable)variable).getAssignment() != null) {
            sLogger.error((Object)"Assigned value selected -- not supported by DBT.");
            return false;
        }
        return true;
    }

    @Override
    public boolean valueSelected(long iteration, V variable, T value) {
        if (variable != null && value == null) {
            HashSet<Object> noGoods = new HashSet<Object>();
            for (Object val : ((Variable)variable).values()) {
                if (this.noGood(val) == null) continue;
                noGoods.addAll(this.noGood(val));
            }
            if (noGoods.isEmpty()) {
                sLogger.debug((Object)"Fail");
                this.getSolver().stopSolver();
                return false;
            }
            Variable lastVariable = null;
            for (Value value2 : noGoods) {
                Object var = value2.variable();
                if (lastVariable != null && ((Value)lastVariable.getAssignment()).lastAssignmentIteration() >= ((Value)((Variable)var).getAssignment()).lastAssignmentIteration()) continue;
                lastVariable = var;
            }
            Object assignment = lastVariable.getAssignment();
            noGoods.remove(assignment);
            lastVariable.unassign(iteration);
            this.setNoGood(assignment, noGoods);
        }
        return true;
    }

    @Override
    public boolean neighbourSelected(long iteration, Neighbour<V, T> neighbour) {
        return true;
    }
}

