/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import net.sf.cpsolver.ifs.constant.ConstantModel;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionMove<V extends Variable<V, T>, T extends Value<V, T>>
extends RandomSwapMove<V, T> {
    protected int iSuggestionDepth = 3;
    protected int iTimeLimit = 200;

    public SuggestionMove(DataProperties config) throws Exception {
        super(config);
        this.iMaxAttempts = config.getPropertyInt("SuggestionMove.MaxAttempts", this.iMaxAttempts);
        this.iSuggestionDepth = config.getPropertyInt("SuggestionMove.Depth", this.iSuggestionDepth);
        this.iTimeLimit = config.getPropertyInt("SuggestionMove.TimeLimit", this.iTimeLimit);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Variable variable = (Variable)ToolBox.random(solution.getModel().variables());
        RandomSwapMove.SwapNeighbour n = this.backtrack(solution, solution.getModel().getTotalValue(), solution.getModel().nrUnassignedVariables(), JProf.currentTimeMillis(), variable, new HashMap(), new HashMap(), this.iSuggestionDepth);
        return n;
    }

    private boolean containsCommited(Solution<V, T> solution, Collection<T> values) {
        ConstantModel model;
        if (solution.getModel() instanceof ConstantModel && (model = (ConstantModel)solution.getModel()).hasConstantVariables()) {
            for (Value value : values) {
                if (!model.isConstant(value.variable())) continue;
                return true;
            }
        }
        return false;
    }

    private RandomSwapMove.SwapNeighbour backtrack(Solution<V, T> solution, double total, int un, long startTime, V initial, Map<V, T> resolvedVariables, HashMap<V, T> conflictsToResolve, int depth) {
        List values;
        int nrUnassigned = conflictsToResolve.size();
        if (initial == null && nrUnassigned == 0) {
            if (solution.getModel().nrUnassignedVariables() > un) {
                return null;
            }
            double value = solution.getModel().getTotalValue() - total;
            if (!this.iHC || value <= 0.0) {
                return new RandomSwapMove.SwapNeighbour(new ArrayList<T>(resolvedVariables.values()), value);
            }
            return null;
        }
        if (depth <= 0) {
            return null;
        }
        Object lecture = initial;
        if (lecture == null) {
            for (Variable l : conflictsToResolve.keySet()) {
                if (resolvedVariables.containsKey(l)) continue;
                lecture = l;
                break;
            }
            if (lecture == null) {
                return null;
            }
        } else if (resolvedVariables.containsKey(lecture)) {
            return null;
        }
        if ((values = ((Variable)lecture).values()).isEmpty()) {
            return null;
        }
        int idx = ToolBox.random(values.size());
        int nrAttempts = 0;
        block1: for (int i = 0; i < values.size() && nrAttempts < this.iMaxAttempts && !this.isTimeLimitReached(startTime); ++i) {
            Set<Value> conflicts;
            Value value = (Value)values.get((i + idx) % values.size());
            if (value.equals(((Variable)lecture).getAssignment()) || nrUnassigned + (conflicts = solution.getModel().conflictValues(value)).size() > depth || conflicts.contains(value) || this.containsCommited(solution, conflicts)) continue;
            for (Value value2 : conflicts) {
                if (!resolvedVariables.containsKey(value2.variable())) continue;
                continue block1;
            }
            Object cur = ((Variable)lecture).getAssignment();
            for (Value c3 : conflicts) {
                ((Variable)c3.variable()).unassign(0L);
            }
            if (cur != null) {
                ((Variable)lecture).unassign(0L);
            }
            ((Variable)lecture).assign(0L, value);
            for (Value c : conflicts) {
                conflictsToResolve.put((Value)c.variable(), (T)c);
            }
            Value value3 = (Value)conflictsToResolve.remove(lecture);
            resolvedVariables.put((Value)lecture, value);
            RandomSwapMove.SwapNeighbour n = this.backtrack(solution, total, un, startTime, null, resolvedVariables, conflictsToResolve, depth - 1);
            ++nrAttempts;
            resolvedVariables.remove(lecture);
            if (cur == null) {
                ((Variable)lecture).unassign(0L);
            } else {
                ((Variable)lecture).assign(0L, cur);
            }
            for (Value c4 : conflicts) {
                ((Variable)c4.variable()).assign(0L, (Value)c4);
                conflictsToResolve.remove(c4.variable());
            }
            if (value3 != null) {
                conflictsToResolve.put((Value)lecture, value3);
            }
            if (n == null) continue;
            return n;
        }
        return null;
    }
}

