/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.List;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomMove<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
HillClimberSelection {
    protected boolean iHC = false;

    public RandomMove(DataProperties config) {
    }

    @Override
    public void setHcMode(boolean hcMode) {
        this.iHC = hcMode;
    }

    @Override
    public void init(Solver<V, T> solver) {
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Model<V, Value> model = solution.getModel();
        int varIdx = ToolBox.random(model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            Variable variable = (Variable)model.variables().get((i + varIdx) % model.variables().size());
            List values = variable.values();
            if (values.isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            for (int j = 0; j < values.size(); ++j) {
                Value value = (Value)values.get((j + valIdx) % values.size());
                if (model.inConflict(value)) continue;
                SimpleNeighbour<Variable, Value> n = new SimpleNeighbour<Variable, Value>(variable, value);
                if (this.iHC && !(n.value() <= 0.0)) continue;
                return n;
            }
        }
        return null;
    }
}

