/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import net.sf.cpsolver.ifs.algorithms.HillClimber;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepCountingHillClimber<V extends Variable<V, T>, T extends Value<V, T>>
extends HillClimber<V, T> {
    protected Double iBound = null;
    protected int iCounter = 0;
    protected int iCounterLimit = 100;
    protected Mode iCounterMode = Mode.ACCEPTED;

    public StepCountingHillClimber(DataProperties properties, String name) {
        super(properties);
        this.iSetHCMode = false;
    }

    @Override
    public void activate(Solution<V, T> solution) {
        super.activate(solution);
        this.iBound = solution.getModel().getTotalValue();
        this.iCounter = 0;
    }

    @Override
    public void incIteration(Solution<V, T> solution) {
        ++this.iIter;
        if (this.iIter % 10000 == 0) {
            this.iLog.info((Object)("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + this.iDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + this.iDF2.format(1000.0 * (double)this.iIter / (double)this.getTimeMillis()) + " it/s, Bound=" + this.iDF2.format(this.iBound)));
            this.logNeibourStatus();
        }
        this.iProgress.setProgress(Math.round(100.0 * (double)(this.iIter - this.iLastImprovingIter) / (double)this.iMaxIdleIters));
        if (this.iCounter >= this.iCounterLimit) {
            this.iBound = solution.getModel().getTotalValue();
            this.iCounter = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean accept(Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
        if (value <= 0.0) ** GOTO lbl-1000
        v0 = lazy != false ? model.getTotalValue() : value + model.getTotalValue();
        if (v0 < this.iBound) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        accept = v1;
        switch (1.$SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode[this.iCounterMode.ordinal()]) {
            case 1: {
                ++this.iCounter;
                break;
            }
            case 2: {
                if (!accept) break;
                ++this.iCounter;
                break;
            }
            case 3: {
                if (!(value < 0.0)) break;
                ++this.iCounter;
            }
        }
        return accept;
    }

    @Override
    protected boolean canContinue(Solution<V, T> solution) {
        return super.canContinue(solution) || this.iCounter < this.iCounterLimit || solution.getModel().getTotalValue() < this.iBound;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode;

        static {
            $SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode = new int[Mode.values().length];
            try {
                1.$SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode[Mode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode[Mode.ACCEPTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sf$cpsolver$ifs$algorithms$StepCountingHillClimber$Mode[Mode.IMPROVING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ALL,
        ACCEPTED,
        IMPROVING;

    }
}

