/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import net.sf.cpsolver.ifs.algorithms.NeighbourSearch;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulatedAnnealing<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    private DecimalFormat iDF5 = new DecimalFormat("0.00000");
    private DecimalFormat iDF10 = new DecimalFormat("0.0000000000");
    private double iInitialTemperature = 1.5;
    private double iCoolingRate = 0.95;
    private double iReheatRate = -1.0;
    private long iTemperatureLength = 25000L;
    private long iReheatLength = 0L;
    private long iRestoreBestLength = 0L;
    private double iTemperature = 0.0;
    private double iReheatLengthCoef = 5.0;
    private double iRestoreBestLengthCoef = -1.0;
    private long iLastImprovingIter = 0L;
    private long iLastReheatIter = 0L;
    private long iLastCoolingIter = 0L;
    private int[] iAcceptIter = new int[]{0, 0, 0};
    private boolean iStochasticHC = false;
    private int iMoves = 0;
    private double iAbsValue = 0.0;
    private double iBestValue = 0.0;
    private boolean iRelativeAcceptance = true;

    public SimulatedAnnealing(DataProperties properties) {
        super(properties);
        this.iInitialTemperature = properties.getPropertyDouble(this.getParameterBaseName() + ".InitialTemperature", this.iInitialTemperature);
        this.iReheatRate = properties.getPropertyDouble(this.getParameterBaseName() + ".ReheatRate", this.iReheatRate);
        this.iCoolingRate = properties.getPropertyDouble(this.getParameterBaseName() + ".CoolingRate", this.iCoolingRate);
        this.iRelativeAcceptance = properties.getPropertyBoolean(this.getParameterBaseName() + ".RelativeAcceptance", this.iRelativeAcceptance);
        this.iStochasticHC = properties.getPropertyBoolean(this.getParameterBaseName() + ".StochasticHC", this.iStochasticHC);
        this.iTemperatureLength = properties.getPropertyLong(this.getParameterBaseName() + ".TemperatureLength", this.iTemperatureLength);
        this.iReheatLengthCoef = properties.getPropertyDouble(this.getParameterBaseName() + ".ReheatLengthCoef", this.iReheatLengthCoef);
        this.iRestoreBestLengthCoef = properties.getPropertyDouble(this.getParameterBaseName() + ".RestoreBestLengthCoef", this.iRestoreBestLengthCoef);
        if (this.iReheatRate < 0.0) {
            this.iReheatRate = Math.pow(1.0 / this.iCoolingRate, this.iReheatLengthCoef * 1.7);
        }
        if (this.iRestoreBestLengthCoef < 0.0) {
            this.iRestoreBestLengthCoef = this.iReheatLengthCoef * this.iReheatLengthCoef;
        }
    }

    @Override
    protected void activate(Solution<V, T> solution) {
        super.activate(solution);
        this.iTemperature = this.iInitialTemperature;
        this.iReheatLength = Math.round(this.iReheatLengthCoef * (double)this.iTemperatureLength);
        this.iRestoreBestLength = Math.round(this.iRestoreBestLengthCoef * (double)this.iTemperatureLength);
        this.iLastImprovingIter = this.iIter;
    }

    protected void cool(Solution<V, T> solution) {
        this.iTemperature *= this.iCoolingRate;
        this.iLog.info((Object)("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + this.iDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + this.iDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
        this.iLog.info((Object)("Temperature decreased to " + this.iDF5.format(this.iTemperature) + " " + "(#moves=" + this.iMoves + ", rms(value)=" + this.iDF2.format(Math.sqrt(this.iAbsValue / (double)this.iMoves)) + ", " + "accept=-" + this.iDF2.format(100.0 * (double)this.iAcceptIter[0] / (double)this.iMoves) + "/" + this.iDF2.format(100.0 * (double)this.iAcceptIter[1] / (double)this.iMoves) + "/+" + this.iDF2.format(100.0 * (double)this.iAcceptIter[2] / (double)this.iMoves) + "%, " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + this.iDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+0.1)=" + this.iDF2.format(100.0 * this.prob(0.1)) + "%, " + "p(+1)=" + this.iDF2.format(100.0 * this.prob(1.0)) + "%, " + "p(+10)=" + this.iDF5.format(100.0 * this.prob(10.0)) + "%)"));
        this.logNeibourStatus();
        this.iLastCoolingIter = this.iIter;
        this.iAcceptIter = new int[]{0, 0, 0};
        this.iMoves = 0;
        this.iAbsValue = 0.0;
    }

    protected void reheat(Solution<V, T> solution) {
        this.iTemperature *= this.iReheatRate;
        this.iLog.info((Object)("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + this.iDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + this.iDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
        this.iLog.info((Object)("Temperature increased to " + this.iDF5.format(this.iTemperature) + " " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + this.iDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+1)=" + this.iDF2.format(100.0 * this.prob(1.0)) + "%, " + "p(+10)=" + this.iDF5.format(100.0 * this.prob(10.0)) + "%, " + "p(+100)=" + this.iDF10.format(100.0 * this.prob(100.0)) + "%)"));
        this.logNeibourStatus();
        this.iLastReheatIter = this.iIter;
        this.iProgress.setPhase("Simulated Annealing [" + this.iDF2.format(this.iTemperature) + "]...");
    }

    protected void restoreBest(Solution<V, T> solution) {
        this.iLog.info((Object)"Best restored");
        this.iLastImprovingIter = this.iIter;
    }

    protected double prob(double value) {
        if (this.iStochasticHC) {
            return 1.0 / (1.0 + Math.exp(value / this.iTemperature));
        }
        return value <= 0.0 ? 1.0 : Math.exp(-value / this.iTemperature);
    }

    @Override
    protected boolean accept(Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
        ++this.iMoves;
        this.iAbsValue += value * value;
        double prob = this.prob(this.iRelativeAcceptance ? value : (lazy ? model.getTotalValue() : value + model.getTotalValue()) - this.iBestValue);
        if (prob >= 1.0 || ToolBox.random() < prob) {
            int n = value < 0.0 ? 0 : (value > 0.0 ? 2 : 1);
            this.iAcceptIter[n] = this.iAcceptIter[n] + 1;
            return true;
        }
        return false;
    }

    @Override
    protected void incIteration(Solution<V, T> solution) {
        super.incIteration(solution);
        ++this.iIter;
        if ((long)this.iIter > this.iLastImprovingIter + this.iRestoreBestLength) {
            this.restoreBest(solution);
        }
        if ((long)this.iIter > Math.max(this.iLastReheatIter, this.iLastImprovingIter) + this.iReheatLength) {
            this.reheat(solution);
        }
        if ((long)this.iIter > this.iLastCoolingIter + this.iTemperatureLength) {
            this.cool(solution);
        }
        this.iProgress.setProgress(Math.round(100.0 * (double)((long)this.iIter - Math.max(this.iLastReheatIter, this.iLastImprovingIter)) / (double)this.iReheatLength));
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iBestValue = solution.getBestValue();
        }
        this.iLastImprovingIter = this.iIter;
    }

    @Override
    public String getParameterBaseName() {
        return "SimulatedAnnealing";
    }
}

