/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import net.sf.cpsolver.ifs.algorithms.GreatDeluge;
import net.sf.cpsolver.ifs.algorithms.HillClimber;
import net.sf.cpsolver.ifs.algorithms.SimulatedAnnealing;
import net.sf.cpsolver.ifs.algorithms.StepCountingHillClimber;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.termination.TerminationCondition;
import net.sf.cpsolver.ifs.util.Callback;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSearch<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
TerminationCondition<V, T> {
    private Logger iLog = Logger.getLogger(SimpleSearch.class);
    private NeighbourSelection<V, T> iCon = null;
    private boolean iConstructionUntilComplete = false;
    private StandardNeighbourSelection<V, T> iStd = null;
    private SimulatedAnnealing<V, T> iSA = null;
    private HillClimber<V, T> iHC = null;
    private HillClimber<V, T> iFin = null;
    private GreatDeluge<V, T> iGD = null;
    private int iPhase = -1;
    private boolean iUseGD = true;
    private Progress iProgress = null;
    private Callback iFinalPhaseFinished = null;
    private boolean iCanContinue = true;
    private TerminationCondition<V, T> iTerm = null;

    public SimpleSearch(DataProperties properties) throws Exception {
        String construction = properties.getProperty("Construction.Class");
        if (construction != null) {
            try {
                Class<?> constructionClass = Class.forName(properties.getProperty("Construction.Class"));
                this.iCon = (NeighbourSelection)constructionClass.getConstructor(DataProperties.class).newInstance(properties);
                this.iConstructionUntilComplete = properties.getPropertyBoolean("Construction.UntilComplete", this.iConstructionUntilComplete);
            }
            catch (Exception e) {
                this.iLog.error((Object)("Unable to use " + construction + ": " + e.getMessage()));
            }
        }
        this.iStd = new StandardNeighbourSelection(properties);
        this.iSA = new SimulatedAnnealing(properties);
        this.iHC = properties.getPropertyBoolean("Search.CountSteps", false) ? new StepCountingHillClimber(properties, "Step Counting Hill Climbing") : new HillClimber(properties);
        this.iFin = new HillClimber(properties);
        this.iFin.setPhase("Finalization");
        this.iGD = new GreatDeluge(properties);
        this.iUseGD = properties.getPropertyBoolean("Search.GreatDeluge", this.iUseGD);
    }

    @Override
    public void init(Solver<V, T> solver) {
        this.iStd.init(solver);
        if (this.iCon != null) {
            this.iCon.init(solver);
        }
        this.iSA.init(solver);
        this.iHC.init(solver);
        this.iFin.init(solver);
        this.iGD.init(solver);
        if (this.iTerm == null) {
            this.iTerm = solver.getTerminationCondition();
            solver.setTerminalCondition(this);
        }
        this.iCanContinue = true;
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
    }

    @Override
    public synchronized Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Neighbour<V, T> n = null;
        if (!this.isFinalPhase() && !this.iTerm.canContinue(solution)) {
            this.setFinalPhase(null);
        }
        switch (this.iPhase) {
            case -1: {
                ++this.iPhase;
                this.iLog.info((Object)"***** construction phase *****");
                if (solution.getModel().nrUnassignedVariables() > 0) {
                    this.iProgress.setPhase("Searching for initial solution...", solution.getModel().variables().size());
                }
            }
            case 0: {
                if (this.iCon != null && solution.getModel().nrUnassignedVariables() > 0) {
                    this.iProgress.setProgress(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
                    n = this.iCon.selectNeighbour(solution);
                    if (n != null || this.iConstructionUntilComplete) {
                        return n;
                    }
                }
                ++this.iPhase;
                this.iLog.info((Object)"***** ifs phase *****");
            }
            case 1: {
                if (this.iStd != null && solution.getModel().nrUnassignedVariables() > 0) {
                    this.iProgress.setProgress(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
                    return this.iStd.selectNeighbour(solution);
                }
                ++this.iPhase;
                this.iLog.info((Object)"***** hill climbing phase *****");
            }
            case 2: {
                if (solution.getModel().nrUnassignedVariables() > 0) {
                    return (this.iCon == null ? this.iStd : this.iCon).selectNeighbour(solution);
                }
                n = this.iHC.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                ++this.iPhase;
                this.iLog.info((Object)("***** " + (this.iUseGD ? "great deluge" : "simulated annealing") + " phase *****"));
            }
            case 3: {
                if (solution.getModel().nrUnassignedVariables() > 0) {
                    return (this.iCon == null ? this.iStd : this.iCon).selectNeighbour(solution);
                }
                if (this.iUseGD) {
                    return this.iGD.selectNeighbour(solution);
                }
                return this.iSA.selectNeighbour(solution);
            }
            case 9999: {
                n = this.iFin.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                this.iPhase = -1;
                if (this.iFinalPhaseFinished != null) {
                    this.iFinalPhaseFinished.execute();
                }
                this.iCanContinue = false;
            }
        }
        return null;
    }

    public synchronized void setFinalPhase(Callback finalPhaseFinished) {
        this.iLog.info((Object)"***** final phase *****");
        this.iFinalPhaseFinished = finalPhaseFinished;
        this.iPhase = 9999;
    }

    public boolean isFinalPhase() {
        return this.iPhase == 9999;
    }

    @Override
    public boolean canContinue(Solution<V, T> currentSolution) {
        return this.iCanContinue;
    }
}

