/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import net.sf.cpsolver.ifs.algorithms.NeighbourSearch;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreatDeluge<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    private DecimalFormat sDF2 = new DecimalFormat("0.00");
    private DecimalFormat sDF5 = new DecimalFormat("0.00000");
    private double iBound = 0.0;
    private double iCoolRate = 0.9999999;
    private double iUpperBound;
    private double iUpperBoundRate = 1.05;
    private double iLowerBoundRate = 0.95;
    private int iMoves = 0;
    private int iAcceptedMoves = 0;
    private int iNrIdle = 0;
    private long iLastImprovingIter = 0L;
    private double iBestValue = 0.0;

    public GreatDeluge(DataProperties properties) {
        super(properties);
        this.iCoolRate = properties.getPropertyDouble(this.getParameterBaseName() + ".CoolRate", this.iCoolRate);
        this.iUpperBoundRate = properties.getPropertyDouble(this.getParameterBaseName() + ".UpperBoundRate", this.iUpperBoundRate);
        this.iLowerBoundRate = properties.getPropertyDouble(this.getParameterBaseName() + ".LowerBoundRate", this.iLowerBoundRate);
    }

    @Override
    protected boolean accept(Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
        block3: {
            block2: {
                ++this.iMoves;
                if (value <= 0.0) break block2;
                double d = lazy ? model.getTotalValue() : value + model.getTotalValue();
                if (!(d < this.iBound)) break block3;
            }
            ++this.iAcceptedMoves;
            return true;
        }
        return false;
    }

    @Override
    protected void activate(Solution<V, T> solution) {
        super.activate(solution);
        this.iNrIdle = 0;
        this.iLastImprovingIter = 0L;
        this.iUpperBound = this.iBound = solution.getBestValue() > 0.0 ? this.iUpperBoundRate * solution.getBestValue() : solution.getBestValue() / this.iUpperBoundRate;
    }

    @Override
    protected void incIteration(Solution<V, T> solution) {
        double lowerBound;
        super.incIteration(solution);
        this.iBound = solution.getBestValue() >= 0.0 ? (this.iBound *= this.iCoolRate) : (this.iBound /= this.iCoolRate);
        if (this.iIter % 10000 == 0) {
            this.iLog.info((Object)("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + this.sDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + this.sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
            this.iLog.info((Object)("Bound is " + this.sDF2.format(this.iBound) + ", " + "best value is " + this.sDF2.format(solution.getBestValue()) + " (" + this.sDF2.format(100.0 * this.iBound / solution.getBestValue()) + "%), " + "current value is " + this.sDF2.format(solution.getModel().getTotalValue()) + " (" + this.sDF2.format(100.0 * this.iBound / solution.getModel().getTotalValue()) + "%), " + "#idle=" + this.iNrIdle + ", " + "Pacc=" + this.sDF5.format(100.0 * (double)this.iAcceptedMoves / (double)this.iMoves) + "%"));
            this.logNeibourStatus();
            this.iMoves = 0;
            this.iAcceptedMoves = 0;
        }
        double d = lowerBound = solution.getBestValue() >= 0.0 ? Math.pow(this.iLowerBoundRate, 1 + this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(this.iLowerBoundRate, 1 + this.iNrIdle);
        if (this.iBound < lowerBound) {
            ++this.iNrIdle;
            this.iUpperBound = this.iBound = Math.max(solution.getBestValue() + 2.0, solution.getBestValue() >= 0.0 ? Math.pow(this.iUpperBoundRate, this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(this.iUpperBoundRate, this.iNrIdle));
            this.iProgress.setPhase("Great Deluge [" + (1 + this.iNrIdle) + "]...");
        }
        this.iProgress.setProgress(100L - Math.round(100.0 * (this.iBound - lowerBound) / (this.iUpperBound - lowerBound)));
        ++this.iMoves;
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iNrIdle = 0;
            this.iBestValue = solution.getBestValue();
        }
    }

    @Override
    public String getParameterBaseName() {
        return "GreatDeluge";
    }
}

