/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.weights;

import java.util.Set;
import net.sf.cpsolver.ifs.solution.SolutionComparator;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.weights.EqualStudentWeights;
import net.sf.cpsolver.studentsct.weights.OriginalStudentWeights;
import net.sf.cpsolver.studentsct.weights.PriorityStudentWeights;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface StudentWeights
extends SolutionComparator<Request, Enrollment> {
    public double getBound(Request var1);

    public double getWeight(Enrollment var1);

    public double getWeight(Enrollment var1, Set<DistanceConflict.Conflict> var2, Set<TimeOverlapsCounter.Conflict> var3);

    public double getDistanceConflictWeight(DistanceConflict.Conflict var1);

    public double getTimeOverlapConflictWeight(Enrollment var1, TimeOverlapsCounter.Conflict var2);

    public boolean isFreeTimeAllowOverlaps();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Implementation {
        Priority(PriorityStudentWeights.class),
        Equal(EqualStudentWeights.class),
        Legacy(OriginalStudentWeights.class);

        private Class<? extends StudentWeights> iImplementation;

        private Implementation(Class<? extends StudentWeights> implementation) {
            this.iImplementation = implementation;
        }

        public Class<? extends StudentWeights> getImplementation() {
            return this.iImplementation;
        }
    }
}

