/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.weights;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.weights.StudentWeights;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityStudentWeights
implements StudentWeights {
    protected double iPriorityFactor = 0.501;
    protected double iFirstAlternativeFactor = 0.501;
    protected double iSecondAlternativeFactor = 0.251;
    protected double iDistanceConflict = 0.01;
    protected double iTimeOverlapFactor = 0.5;
    protected double iTimeOverlapMaxLimit = 0.5;
    protected boolean iLeftoverSpread = false;
    protected double iBalancingFactor = 0.005;
    protected double iAlternativeRequestFactor = 0.126;
    protected double iProjectedStudentWeight = 0.01;

    public PriorityStudentWeights(DataProperties config) {
        this.iPriorityFactor = config.getPropertyDouble("StudentWeights.Priority", this.iPriorityFactor);
        this.iFirstAlternativeFactor = config.getPropertyDouble("StudentWeights.FirstAlternative", this.iFirstAlternativeFactor);
        this.iSecondAlternativeFactor = config.getPropertyDouble("StudentWeights.SecondAlternative", this.iSecondAlternativeFactor);
        this.iDistanceConflict = config.getPropertyDouble("StudentWeights.DistanceConflict", this.iDistanceConflict);
        this.iTimeOverlapFactor = config.getPropertyDouble("StudentWeights.TimeOverlapFactor", this.iTimeOverlapFactor);
        this.iTimeOverlapMaxLimit = config.getPropertyDouble("StudentWeights.TimeOverlapMaxLimit", this.iTimeOverlapMaxLimit);
        this.iLeftoverSpread = config.getPropertyBoolean("StudentWeights.LeftoverSpread", this.iLeftoverSpread);
        this.iBalancingFactor = config.getPropertyDouble("StudentWeights.BalancingFactor", this.iBalancingFactor);
        this.iAlternativeRequestFactor = config.getPropertyDouble("StudentWeights.AlternativeRequestFactor", this.iAlternativeRequestFactor);
        this.iProjectedStudentWeight = config.getPropertyDouble("StudentWeights.ProjectedStudentWeight", this.iProjectedStudentWeight);
    }

    public double getWeight(Request request) {
        if (request.getStudent().isDummy() && this.iProjectedStudentWeight >= 0.0) {
            double weight = this.iProjectedStudentWeight;
            if (request.isAlternative()) {
                weight *= this.iAlternativeRequestFactor;
            }
            return weight;
        }
        double total = 10000.0;
        int nrReq = request.getStudent().nrRequests();
        double remain = this.iLeftoverSpread ? Math.floor(10000.0 * Math.pow(this.iPriorityFactor, nrReq) / (double)nrReq) : 0.0;
        for (int idx = 0; idx < request.getStudent().getRequests().size(); ++idx) {
            Request r = request.getStudent().getRequests().get(idx);
            boolean last = idx + 1 == request.getStudent().getRequests().size();
            boolean lastNotAlt = !r.isAlternative() && (last || request.getStudent().getRequests().get(1 + idx).isAlternative());
            double w = Math.ceil(this.iPriorityFactor * total) + remain;
            if (lastNotAlt || last) {
                w = total;
            } else {
                total -= w;
            }
            if (!r.equals(request)) continue;
            return w / 10000.0;
        }
        return 0.0;
    }

    public double getCachedWeight(Request request) {
        Double w = (Double)request.getExtra();
        if (w == null) {
            w = this.getWeight(request);
            request.setExtra(w);
        }
        return w;
    }

    @Override
    public double getBound(Request request) {
        return this.getCachedWeight(request);
    }

    protected double round(double value) {
        return Math.ceil(10000.0 * value) / 10000.0;
    }

    @Override
    public double getWeight(Enrollment enrollment) {
        double weight = this.getCachedWeight(enrollment.getRequest());
        switch (enrollment.getPriority()) {
            case 1: {
                weight *= this.iFirstAlternativeFactor;
                break;
            }
            case 2: {
                weight *= this.iSecondAlternativeFactor;
            }
        }
        if (enrollment.isCourseRequest() && this.iBalancingFactor != 0.0) {
            double configUsed = enrollment.getConfig().getEnrollmentWeight(enrollment.getRequest()) + enrollment.getRequest().getWeight();
            double disbalanced = 0.0;
            double total = 0.0;
            for (Section section : enrollment.getSections()) {
                double desired;
                Subpart subpart = section.getSubpart();
                if (subpart.getSections().size() <= 1) continue;
                double used = section.getEnrollmentWeight(enrollment.getRequest()) + enrollment.getRequest().getWeight();
                double d = desired = subpart.getLimit() > 0 ? (double)section.getLimit() * (configUsed / (double)subpart.getLimit()) : configUsed / (double)subpart.getSections().size();
                disbalanced = used > desired ? (disbalanced += Math.min(enrollment.getRequest().getWeight(), used - desired) / enrollment.getRequest().getWeight()) : (disbalanced -= Math.min(enrollment.getRequest().getWeight(), desired - used) / enrollment.getRequest().getWeight());
                total += 1.0;
            }
            if (disbalanced > 0.0) {
                weight *= 1.0 - disbalanced / total * this.iBalancingFactor;
            }
        }
        return this.round(weight);
    }

    @Override
    public double getDistanceConflictWeight(DistanceConflict.Conflict c) {
        if (c.getR1().getPriority() < c.getR2().getPriority()) {
            return this.round(this.getWeight(c.getE2()) * this.iDistanceConflict);
        }
        return this.round(this.getWeight(c.getE1()) * this.iDistanceConflict);
    }

    @Override
    public double getTimeOverlapConflictWeight(Enrollment e, TimeOverlapsCounter.Conflict c) {
        double toc = Math.min(this.iTimeOverlapMaxLimit * (double)c.getShare() / (double)e.getNrSlots(), this.iTimeOverlapMaxLimit);
        return this.round(this.getWeight(e) * toc);
    }

    @Override
    public double getWeight(Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
        double base = this.getWeight(enrollment);
        double dc = 0.0;
        if (distanceConflicts != null) {
            for (DistanceConflict.Conflict c : distanceConflicts) {
                Enrollment other;
                Enrollment enrollment2 = other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                if (other.getRequest().getPriority() <= enrollment.getRequest().getPriority()) {
                    dc += base * this.iDistanceConflict;
                    continue;
                }
                dc += this.getWeight(other) * this.iDistanceConflict;
            }
        }
        double toc = 0.0;
        if (timeOverlappingConflicts != null) {
            for (TimeOverlapsCounter.Conflict c : timeOverlappingConflicts) {
                toc += base * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)enrollment.getNrSlots(), this.iTimeOverlapMaxLimit);
                Enrollment other = c.getE1().equals(enrollment) ? c.getE2() : c.getE1();
                toc += this.getWeight(other) * Math.min(this.iTimeOverlapFactor * (double)c.getShare() / (double)other.getNrSlots(), this.iTimeOverlapMaxLimit);
            }
        }
        return this.round(base - dc - toc);
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        return currentSolution.getBestInfo() == null || currentSolution.getModel().getTotalValue() < currentSolution.getBestValue();
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return false;
    }

    public static void main(String[] args) {
        HashSet<DistanceConflict.Conflict> dc;
        Enrollment e;
        HashSet<Section> sections;
        Config cfg;
        int i;
        double[] w;
        CourseRequest cr;
        PriorityStudentWeights pw = new PriorityStudentWeights(new DataProperties());
        DecimalFormat df = new DecimalFormat("0.0000");
        Student s = new Student(0L);
        new CourseRequest(1L, 0, false, s, ToolBox.toList(new Course(1L, "A", "1", new Offering(0L, "A")), new Course(1L, "A", "2", new Offering(0L, "A")), new Course(1L, "A", "3", new Offering(0L, "A"))), false, null);
        new CourseRequest(2L, 1, false, s, ToolBox.toList(new Course(1L, "B", "1", new Offering(0L, "B")), new Course(1L, "B", "2", new Offering(0L, "B")), new Course(1L, "B", "3", new Offering(0L, "B"))), false, null);
        new CourseRequest(3L, 2, false, s, ToolBox.toList(new Course(1L, "C", "1", new Offering(0L, "C")), new Course(1L, "C", "2", new Offering(0L, "C")), new Course(1L, "C", "3", new Offering(0L, "C"))), false, null);
        new CourseRequest(4L, 3, false, s, ToolBox.toList(new Course(1L, "D", "1", new Offering(0L, "D")), new Course(1L, "D", "2", new Offering(0L, "D")), new Course(1L, "D", "3", new Offering(0L, "D"))), false, null);
        new CourseRequest(5L, 4, false, s, ToolBox.toList(new Course(1L, "E", "1", new Offering(0L, "E")), new Course(1L, "E", "2", new Offering(0L, "E")), new Course(1L, "E", "3", new Offering(0L, "E"))), false, null);
        new CourseRequest(6L, 5, true, s, ToolBox.toList(new Course(1L, "F", "1", new Offering(0L, "F")), new Course(1L, "F", "2", new Offering(0L, "F")), new Course(1L, "F", "3", new Offering(0L, "F"))), false, null);
        new CourseRequest(7L, 6, true, s, ToolBox.toList(new Course(1L, "G", "1", new Offering(0L, "G")), new Course(1L, "G", "2", new Offering(0L, "G")), new Course(1L, "G", "3", new Offering(0L, "G"))), false, null);
        Placement p = new Placement(null, new TimeLocation(1, 90, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList());
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet<Section>();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                w[i] = pw.getWeight(e, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With one distance conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                dc = new HashSet<DistanceConflict.Conflict>();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                w[i] = pw.getWeight(e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With two distance conflicts:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                dc = new HashSet();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null)));
                w[i] = pw.getWeight(e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With 25% time overlapping conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                HashSet<TimeOverlapsCounter.Conflict> toc = new HashSet<TimeOverlapsCounter.Conflict>();
                toc.add(new TimeOverlapsCounter.Conflict(s, 3, e, (Assignment)sections.iterator().next(), e, (Assignment)sections.iterator().next()));
                w[i] = pw.getWeight(e, null, toc);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Disbalanced sections (by 2 / 10 students):");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                Subpart x = new Subpart(0L, "Lec", "Lec", cfg, null);
                Section a = new Section(0L, 10, "x", x, p, null, null, null);
                new Section(1L, 10, "y", x, p, null, null, null);
                sections.add(a);
                a.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                a.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                cfg.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                cfg.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                Enrollment e2 = new Enrollment(cr, i, cfg, sections);
                w[i] = pw.getWeight(e2, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
    }
}

