/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.weights;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.weights.PriorityStudentWeights;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualStudentWeights
extends PriorityStudentWeights {
    public EqualStudentWeights(DataProperties config) {
        super(config);
    }

    @Override
    public double getWeight(Request request) {
        if (request.getStudent().isDummy() && this.iProjectedStudentWeight >= 0.0) {
            double weight = this.iProjectedStudentWeight;
            if (request.isAlternative()) {
                weight *= this.iAlternativeRequestFactor;
            }
            return weight;
        }
        double weight = 1.0 / (double)request.getStudent().nrRequests();
        if (request.isAlternative()) {
            weight *= this.iAlternativeRequestFactor;
        }
        return this.round(weight);
    }

    @Override
    public boolean isBetterThanBestSolution(Solution<Request, Enrollment> currentSolution) {
        if (currentSolution.getBestInfo() == null) {
            return true;
        }
        int unassigned = currentSolution.getModel().nrUnassignedVariables();
        if (currentSolution.getModel().getBestUnassignedVariables() != unassigned) {
            return currentSolution.getModel().getBestUnassignedVariables() > unassigned;
        }
        return currentSolution.getModel().getTotalValue() < currentSolution.getBestValue();
    }

    @Override
    public boolean isFreeTimeAllowOverlaps() {
        return true;
    }

    public static void main(String[] args) {
        HashSet<DistanceConflict.Conflict> dc;
        Enrollment e;
        HashSet<Section> sections;
        Config cfg;
        int i;
        double[] w;
        CourseRequest cr;
        EqualStudentWeights pw = new EqualStudentWeights(new DataProperties());
        DecimalFormat df = new DecimalFormat("0.0000");
        Student s = new Student(0L);
        new CourseRequest(1L, 0, false, s, ToolBox.toList(new Course(1L, "A", "1", new Offering(0L, "A")), new Course(1L, "A", "2", new Offering(0L, "A")), new Course(1L, "A", "3", new Offering(0L, "A"))), false, null);
        new CourseRequest(2L, 1, false, s, ToolBox.toList(new Course(1L, "B", "1", new Offering(0L, "B")), new Course(1L, "B", "2", new Offering(0L, "B")), new Course(1L, "B", "3", new Offering(0L, "B"))), false, null);
        new CourseRequest(3L, 2, false, s, ToolBox.toList(new Course(1L, "C", "1", new Offering(0L, "C")), new Course(1L, "C", "2", new Offering(0L, "C")), new Course(1L, "C", "3", new Offering(0L, "C"))), false, null);
        new CourseRequest(5L, 4, false, s, ToolBox.toList(new Course(1L, "E", "1", new Offering(0L, "E")), new Course(1L, "E", "2", new Offering(0L, "E")), new Course(1L, "E", "3", new Offering(0L, "E"))), false, null);
        new CourseRequest(6L, 5, true, s, ToolBox.toList(new Course(1L, "F", "1", new Offering(0L, "F")), new Course(1L, "F", "2", new Offering(0L, "F")), new Course(1L, "F", "3", new Offering(0L, "F"))), false, null);
        new CourseRequest(7L, 6, true, s, ToolBox.toList(new Course(1L, "G", "1", new Offering(0L, "G")), new Course(1L, "G", "2", new Offering(0L, "G")), new Course(1L, "G", "3", new Offering(0L, "G"))), false, null);
        Placement p = new Placement(null, new TimeLocation(1, 90, 12, 0, 0.0, null, null, new BitSet(), 10), new ArrayList());
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet<Section>();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                w[i] = pw.getWeight(e, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With one distance conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                dc = new HashSet<DistanceConflict.Conflict>();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                w[i] = pw.getWeight(e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With two distance conflicts:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                dc = new HashSet();
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, (Section)sections.iterator().next()));
                dc.add(new DistanceConflict.Conflict(s, e, (Section)sections.iterator().next(), e, new Section(1L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null)));
                w[i] = pw.getWeight(e, dc, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("With 25% time overlapping conflict:");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                sections.add(new Section(0L, 1, "x", new Subpart(0L, "Lec", "Lec", cfg, null), p, null, null, null));
                e = new Enrollment(cr, i, cfg, sections);
                HashSet<TimeOverlapsCounter.Conflict> toc = new HashSet<TimeOverlapsCounter.Conflict>();
                toc.add(new TimeOverlapsCounter.Conflict(s, 3, e, (Assignment)sections.iterator().next(), e, (Assignment)sections.iterator().next()));
                w[i] = pw.getWeight(e, null, toc);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
        System.out.println("Disbalanced sections (by 2 / 10 students):");
        for (Request r : s.getRequests()) {
            cr = (CourseRequest)r;
            w = new double[]{0.0, 0.0, 0.0};
            for (i = 0; i < cr.getCourses().size(); ++i) {
                cfg = new Config(0L, -1, "", cr.getCourses().get(i).getOffering());
                sections = new HashSet();
                Subpart x = new Subpart(0L, "Lec", "Lec", cfg, null);
                Section a = new Section(0L, 10, "x", x, p, null, null, null);
                new Section(1L, 10, "y", x, p, null, null, null);
                sections.add(a);
                a.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                a.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                cfg.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                cfg.assigned(new Enrollment(s.getRequests().get(0), i, cfg, sections));
                Enrollment e2 = new Enrollment(cr, i, cfg, sections);
                w[i] = pw.getWeight(e2, null, null);
            }
            System.out.println(cr + ": " + df.format(w[0]) + "  " + df.format(w[1]) + "  " + df.format(w[2]));
        }
    }
}

