/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.reservation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reservation
implements Comparable<Reservation> {
    private long iId = 0L;
    private boolean iExpired;
    private Offering iOffering;
    private Set<Config> iConfigs = new HashSet<Config>();
    private Map<Subpart, Set<Section>> iSections = new HashMap<Subpart, Set<Section>>();
    private Set<Enrollment> iEnrollments = new HashSet<Enrollment>();
    private double iUsed = 0.0;
    private Double iCachedRestrictivity = null;
    private Double iLimitCap = null;

    public Reservation(long id, Offering offering) {
        this.iId = id;
        this.iOffering = offering;
        this.iOffering.getReservations().add(this);
        this.iOffering.clearReservationCache();
    }

    public long getId() {
        return this.iId;
    }

    public abstract double getReservationLimit();

    public abstract int getPriority();

    public abstract boolean isApplicable(Student var1);

    public Offering getOffering() {
        return this.iOffering;
    }

    public Set<Config> getConfigs() {
        return this.iConfigs;
    }

    public void addConfig(Config config) {
        this.iConfigs.add(config);
        this.clearLimitCapCache();
    }

    public Map<Subpart, Set<Section>> getSections() {
        return this.iSections;
    }

    public Set<Section> getSections(Subpart subpart) {
        return this.iSections.get(subpart);
    }

    public void addSection(Section section) {
        this.addConfig(section.getSubpart().getConfig());
        while (section != null) {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null) {
                sections = new HashSet<Section>();
                this.iSections.put(section.getSubpart(), sections);
            }
            sections.add(section);
            section = section.getParent();
        }
        this.clearLimitCapCache();
    }

    public boolean isIncluded(Enrollment enrollment) {
        if (enrollment.getConfig() == null) {
            return false;
        }
        if (!this.iOffering.equals(enrollment.getConfig().getOffering())) {
            return false;
        }
        if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(enrollment.getConfig())) {
            return false;
        }
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null || sections.contains(section)) continue;
            return false;
        }
        return true;
    }

    public boolean canEnroll(Enrollment enrollment) {
        if (!this.isApplicable(enrollment.getStudent())) {
            return false;
        }
        if (!this.isIncluded(enrollment)) {
            return false;
        }
        return this.getLimit() < 0.0 || this.getUsedSpace() + enrollment.getRequest().getWeight() <= this.getLimit();
    }

    public void assigned(Enrollment enrollment) {
        this.iEnrollments.add(enrollment);
        this.iUsed += enrollment.getRequest().getWeight();
    }

    public void unassigned(Enrollment enrollment) {
        this.iEnrollments.remove(enrollment);
        this.iUsed -= enrollment.getRequest().getWeight();
    }

    public Set<Enrollment> getEnrollments() {
        return this.iEnrollments;
    }

    public double getUsedSpace() {
        return this.iUsed;
    }

    public double getReservedAvailableSpace(Request excludeRequest) {
        if (this.getLimit() < 0.0) {
            return Double.MAX_VALUE;
        }
        double reserved = this.getLimit() - this.getUsedSpace();
        if (excludeRequest != null && excludeRequest.getAssignment() != null && this.iEnrollments.contains(excludeRequest.getAssignment())) {
            reserved += excludeRequest.getWeight();
        }
        return reserved;
    }

    public abstract boolean canAssignOverLimit();

    public abstract boolean mustBeUsed();

    public double getRestrictivity() {
        if (this.iCachedRestrictivity == null) {
            if (this.getConfigs().isEmpty()) {
                return 1.0;
            }
            int nrChoices = 0;
            int nrMatchingChoices = 0;
            for (Config config : this.getOffering().getConfigs()) {
                int[] x = this.nrChoices(config, 0, new HashSet<Section>(), this.getConfigs().contains(config));
                nrChoices += x[0];
                nrMatchingChoices += x[1];
            }
            this.iCachedRestrictivity = (double)nrMatchingChoices / (double)nrChoices;
        }
        return this.iCachedRestrictivity;
    }

    private int[] nrChoices(Config config, int idx, HashSet<Section> sections, boolean matching) {
        if (config.getSubparts().size() == idx) {
            return new int[]{1, matching ? 1 : 0};
        }
        Subpart subpart = config.getSubparts().get(idx);
        Set<Section> matchingSections = this.getSections(subpart);
        int choicesThisSubpart = 0;
        int matchingChoicesThisSubpart = 0;
        for (Section section : subpart.getSections()) {
            if (section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections)) continue;
            sections.add(section);
            boolean m = matching && (matchingSections == null || matchingSections.contains(section));
            int[] x = this.nrChoices(config, 1 + idx, sections, m);
            choicesThisSubpart += x[0];
            matchingChoicesThisSubpart += x[1];
            sections.remove(section);
        }
        return new int[]{choicesThisSubpart, matchingChoicesThisSubpart};
    }

    @Override
    public int compareTo(Reservation r) {
        if (this.getPriority() != r.getPriority()) {
            return this.getPriority() < r.getPriority() ? -1 : 1;
        }
        int cmp = Double.compare(this.getRestrictivity(), r.getRestrictivity());
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Double.compare(this.getReservedAvailableSpace(null), r.getReservedAvailableSpace(null));
        if (cmp != 0) {
            return cmp;
        }
        return new Long(this.getId()).compareTo(r.getId());
    }

    private static double min(double l1, double l2) {
        return l1 < 0.0 ? l2 : (l2 < 0.0 ? l1 : Math.min(l1, l2));
    }

    private static double add(double l1, double l2) {
        return l1 < 0.0 ? -1.0 : (l2 < 0.0 ? -1.0 : l1 + l2);
    }

    public double getLimitCap() {
        if (this.iLimitCap == null) {
            this.iLimitCap = this.getLimitCapNoCache();
        }
        return this.iLimitCap;
    }

    private double getLimitCapNoCache() {
        if (this.getConfigs().isEmpty()) {
            return -1.0;
        }
        if (this.canAssignOverLimit()) {
            return -1.0;
        }
        double cap = 0.0;
        for (Config config : this.iConfigs) {
            cap = Reservation.add(cap, config.getLimit());
        }
        for (Set set : this.getSections().values()) {
            double subpartCap = 0.0;
            for (Section section : set) {
                subpartCap = Reservation.add(subpartCap, section.getLimit());
            }
            cap = Reservation.min(cap, subpartCap);
        }
        return cap;
    }

    private void clearLimitCapCache() {
        this.iLimitCap = null;
    }

    public double getLimit() {
        return Reservation.min(this.getLimitCap(), this.getReservationLimit());
    }

    public boolean isAllowOverlap() {
        return false;
    }

    public void setExpired(boolean expired) {
        this.iExpired = expired;
    }

    public boolean isExpired() {
        return this.iExpired;
    }
}

