/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.AcademicAreaCode;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumReservation
extends Reservation {
    private double iLimit;
    private String iAcadArea;
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();

    public CurriculumReservation(long id, double limit, Offering offering, String acadArea, Collection<String> classifications, Collection<String> majors) {
        super(id, offering);
        this.iLimit = limit;
        this.iAcadArea = acadArea;
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    @Override
    public boolean canAssignOverLimit() {
        return false;
    }

    @Override
    public boolean mustBeUsed() {
        return false;
    }

    @Override
    public double getReservationLimit() {
        return this.iLimit;
    }

    public void setReservationLimit(double limit) {
        this.iLimit = limit;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    public String getAcademicArea() {
        return this.iAcadArea;
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    @Override
    public boolean isApplicable(Student student) {
        boolean match = false;
        if (student.getAcademicAreaClasiffications() == null) {
            return false;
        }
        for (AcademicAreaCode aac : student.getAcademicAreaClasiffications()) {
            if (!this.getAcademicArea().equals(aac.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(aac.getCode())) continue;
            match = true;
            break;
        }
        if (!match) {
            return false;
        }
        for (AcademicAreaCode aac : student.getMajors()) {
            if (!this.getAcademicArea().equals(aac.getArea()) || !this.getMajors().isEmpty() && !this.getMajors().contains(aac.getCode())) continue;
            return true;
        }
        return this.getMajors().isEmpty();
    }
}

