/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.ifs.util.CSVFile;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.DistanceMetric;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.report.CourseSection;
import net.sf.cpsolver.studentsct.report.StudentSectioningReport;
import org.apache.log4j.Logger;

public class DistanceConflictTable
implements StudentSectioningReport {
    private static Logger sLog = Logger.getLogger(DistanceConflictTable.class);
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private static DecimalFormat sDF2 = new DecimalFormat("0.0000");
    private StudentSectioningModel iModel = null;
    private DistanceConflict iDC = null;
    private DistanceMetric iDM = null;

    public DistanceConflictTable(StudentSectioningModel model) {
        this.iModel = model;
        this.iDC = model.getDistanceConflict();
        if (this.iDC == null) {
            this.iDM = new DistanceMetric(model.getProperties());
            this.iDC = new DistanceConflict(this.iDM, model.getProperties());
        } else {
            this.iDM = this.iDC.getDistanceMetric();
        }
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile createTable(boolean includeLastLikeStudents, boolean includeRealStudents) {
        Map<CourseSection, Double> pair;
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Course"), new CSVFile.CSVField("Total\nConflicts"), new CSVFile.CSVField("Class"), new CSVFile.CSVField("Meeting Time"), new CSVFile.CSVField("Room"), new CSVFile.CSVField("Distance\nConflicts"), new CSVFile.CSVField("% of Total\nConflicts"), new CSVFile.CSVField("Conflicting\nClass"), new CSVFile.CSVField("Conflicting\nMeeting Time"), new CSVFile.CSVField("Conflicting\nRoom"), new CSVFile.CSVField("Distance [m]"), new CSVFile.CSVField("Distance [min]"), new CSVFile.CSVField("Joined\nConflicts"), new CSVFile.CSVField("% of Total\nConflicts")});
        HashSet<DistanceConflict.Conflict> confs = new HashSet<DistanceConflict.Conflict>();
        for (Request r1 : this.getModel().variables()) {
            if (r1.getAssignment() == null || !(r1 instanceof CourseRequest)) continue;
            confs.addAll(this.iDC.conflicts((Enrollment)r1.getAssignment()));
            for (Request request : r1.getStudent().getRequests()) {
                if (request.getAssignment() == null || r1.getId() >= request.getId() || !(request instanceof CourseRequest)) continue;
                confs.addAll(this.iDC.conflicts((Enrollment)r1.getAssignment(), (Enrollment)request.getAssignment()));
            }
        }
        HashMap<Course, HashSet<Long>> totals = new HashMap<Course, HashSet<Long>>();
        HashMap<CourseSection, Map<CourseSection, Double>> conflictingPairs = new HashMap<CourseSection, Map<CourseSection, Double>>();
        HashMap sectionOverlaps = new HashMap();
        for (DistanceConflict.Conflict conflict : confs) {
            if (conflict.getStudent().isDummy() && !includeLastLikeStudents || !conflict.getStudent().isDummy() && !includeRealStudents) continue;
            Section s1 = conflict.getS1();
            Section s2 = conflict.getS2();
            Course c1 = null;
            Course c2 = null;
            Request r1 = null;
            Request r2 = null;
            for (Request request : conflict.getStudent().getRequests()) {
                Set<Long> total;
                Enrollment enrollment = (Enrollment)request.getAssignment();
                if (enrollment == null || !enrollment.isCourseRequest()) continue;
                if (c1 == null && enrollment.getAssignments().contains(s1)) {
                    c1 = enrollment.getCourse();
                    r1 = request;
                    total = (HashSet<Long>)totals.get(enrollment.getCourse());
                    if (total == null) {
                        total = new HashSet<Long>();
                        totals.put(enrollment.getCourse(), (HashSet<Long>)total);
                    }
                    total.add(enrollment.getStudent().getId());
                }
                if (c2 != null || !enrollment.getAssignments().contains(s2)) continue;
                c2 = enrollment.getCourse();
                r2 = request;
                total = (Set)totals.get(enrollment.getCourse());
                if (total == null) {
                    total = new HashSet();
                    totals.put(enrollment.getCourse(), (HashSet<Long>)total);
                }
                total.add(enrollment.getStudent().getId());
            }
            if (c1 == null) {
                sLog.error((Object)("Unable to find a course for " + s1));
                continue;
            }
            if (c2 == null) {
                sLog.error((Object)("Unable to find a course for " + s2));
                continue;
            }
            CourseSection a = new CourseSection(c1, s1);
            CourseSection b = new CourseSection(c2, s2);
            Set<Long> total = (HashSet<Long>)sectionOverlaps.get(a);
            if (total == null) {
                total = new HashSet<Long>();
                sectionOverlaps.put(a, total);
            }
            total.add(r1.getStudent().getId());
            pair = (HashMap<CourseSection, Double>)conflictingPairs.get(a);
            if (pair == null) {
                pair = new HashMap<CourseSection, Double>();
                conflictingPairs.put(a, pair);
            }
            Double prev = (Double)pair.get(b);
            pair.put(b, r2.getWeight() + (prev == null ? 0.0 : prev));
            total = (Set)sectionOverlaps.get(b);
            if (total == null) {
                total = new HashSet();
                sectionOverlaps.put(b, total);
            }
            total.add(r2.getStudent().getId());
            pair = (Map)conflictingPairs.get(b);
            if (pair == null) {
                pair = new HashMap();
                conflictingPairs.put(b, pair);
            }
            prev = (Double)pair.get(a);
            pair.put(a, r1.getWeight() + (prev == null ? 0.0 : prev));
        }
        Comparator<Course> comparator = new Comparator<Course>(){

            @Override
            public int compare(Course a, Course b) {
                int cmp = a.getName().compareTo(b.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        Comparator<Section> sectionComparator = new Comparator<Section>(){

            @Override
            public int compare(Section a, Section b) {
                int cmp = a.getSubpart().getConfig().getOffering().getName().compareTo(b.getSubpart().getConfig().getOffering().getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getSubpart().getInstructionalType().compareTo(b.getSubpart().getInstructionalType());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        TreeSet<Course> courses = new TreeSet<Course>(comparator);
        courses.addAll(totals.keySet());
        for (Course course : courses) {
            Set total = (Set)totals.get(course);
            TreeSet<Section> sections = new TreeSet<Section>(sectionComparator);
            for (Map.Entry entry : sectionOverlaps.entrySet()) {
                if (!course.equals(((CourseSection)entry.getKey()).getCourse())) continue;
                sections.add(((CourseSection)entry.getKey()).getSection());
            }
            boolean firstCourse = true;
            for (Section section : sections) {
                Set sectionOverlap = (Set)sectionOverlaps.get(new CourseSection(course, section));
                pair = (Map)conflictingPairs.get(new CourseSection(course, section));
                boolean firstClass = true;
                String rooms = "";
                if (section.getRooms() != null) {
                    for (RoomLocation r : section.getRooms()) {
                        if (!rooms.isEmpty()) {
                            rooms = rooms + "\n";
                        }
                        rooms = rooms + r.getName();
                    }
                }
                for (CourseSection other : new TreeSet(pair.keySet())) {
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(firstCourse && firstClass ? course.getName() : ""));
                    line.add(new CSVFile.CSVField(firstCourse && firstClass ? Integer.valueOf(total.size()) : ""));
                    line.add(new CSVFile.CSVField(firstClass ? section.getSubpart().getName() + " " + section.getName(course.getId()) : ""));
                    line.add(new CSVFile.CSVField(firstClass ? (section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader() + " - " + section.getTime().getEndTimeHeader()) : ""));
                    line.add(new CSVFile.CSVField(firstClass ? rooms : ""));
                    line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? String.valueOf(sectionOverlap.size()) : ""));
                    line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? sDF2.format((double)sectionOverlap.size() / (double)total.size()) : ""));
                    line.add(new CSVFile.CSVField(other.getCourse().getName() + " " + other.getSection().getSubpart().getName() + " " + other.getSection().getName(other.getCourse().getId())));
                    line.add(new CSVFile.CSVField(other.getSection().getTime().getDayHeader() + " " + other.getSection().getTime().getStartTimeHeader() + " - " + other.getSection().getTime().getEndTimeHeader()));
                    String or = "";
                    if (other.getSection().getRooms() != null) {
                        for (RoomLocation r : other.getSection().getRooms()) {
                            if (!or.isEmpty()) {
                                or = or + "\n";
                            }
                            or = or + r.getName();
                        }
                    }
                    line.add(new CSVFile.CSVField(or));
                    line.add(new CSVFile.CSVField(sDF2.format(Placement.getDistanceInMeters((DistanceMetric)this.iDM, (Placement)section.getPlacement(), (Placement)other.getSection().getPlacement()))));
                    line.add(new CSVFile.CSVField(String.valueOf(Placement.getDistanceInMinutes((DistanceMetric)this.iDM, (Placement)section.getPlacement(), (Placement)other.getSection().getPlacement()))));
                    line.add(new CSVFile.CSVField(sDF1.format(pair.get(other))));
                    line.add(new CSVFile.CSVField(sDF2.format((Double)pair.get(other) / (double)total.size())));
                    csv.addLine(line);
                    firstClass = false;
                }
                firstCourse = false;
            }
            csv.addLine();
        }
        return csv;
    }

    public CSVFile create(DataProperties properties) {
        return this.createTable(properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true));
    }
}

