/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Choice;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Section
implements Assignment,
Comparable<Section> {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private long iId = -1L;
    private String iName = null;
    private Map<Long, String> iNameByCourse = null;
    private Subpart iSubpart = null;
    private Section iParent = null;
    private Placement iPlacement = null;
    private int iLimit = 0;
    private Set<Enrollment> iEnrollments = new HashSet<Enrollment>();
    private Choice iChoice = null;
    private double iPenalty = 0.0;
    private double iEnrollmentWeight = 0.0;
    private double iMaxEnrollmentWeight = 0.0;
    private double iMinEnrollmentWeight = 0.0;
    private double iSpaceExpected = 0.0;
    private double iSpaceHeld = 0.0;
    private String iNote = null;
    private Set<Long> iIgnoreConflictsWith = null;
    private Double iTotalUnreservedSpace = null;
    private List<Reservation> iReservations = null;
    private List<Reservation> iSectionReservations = null;

    public Section(long id, int limit, String name, Subpart subpart, Placement placement, String instructorIds, String instructorNames, Section parent) {
        this.iId = id;
        this.iLimit = limit;
        this.iName = name;
        this.iSubpart = subpart;
        this.iSubpart.getSections().add(this);
        this.iPlacement = placement;
        this.iParent = parent;
        this.iChoice = new Choice(this.getSubpart().getConfig().getOffering(), this.getSubpart().getInstructionalType(), this.getTime(), instructorIds, instructorNames);
    }

    @Override
    public long getId() {
        return this.iId;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Subpart getSubpart() {
        return this.iSubpart;
    }

    public Section getParent() {
        return this.iParent;
    }

    public Placement getPlacement() {
        return this.iPlacement;
    }

    public void setPlacement(Placement placement) {
        this.iPlacement = placement;
    }

    @Override
    public TimeLocation getTime() {
        return this.iPlacement == null ? null : this.iPlacement.getTimeLocation();
    }

    @Override
    public int getNrRooms() {
        return this.iPlacement == null ? 0 : this.iPlacement.getNrRooms();
    }

    @Override
    public List<RoomLocation> getRooms() {
        if (this.iPlacement == null) {
            return null;
        }
        if (this.iPlacement.getRoomLocations() == null && this.iPlacement.getRoomLocation() != null) {
            ArrayList<RoomLocation> ret = new ArrayList<RoomLocation>(1);
            ret.add(this.iPlacement.getRoomLocation());
            return ret;
        }
        return this.iPlacement.getRoomLocations();
    }

    @Override
    public boolean isOverlapping(Assignment assignment) {
        if (this.isAllowOverlap() || assignment.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignment.getTime() == null) {
            return false;
        }
        if (assignment instanceof Section && this.isToIgnoreStudentConflictsWith(assignment.getId())) {
            return false;
        }
        return this.getTime().hasIntersection(assignment.getTime());
    }

    @Override
    public boolean isOverlapping(Set<? extends Assignment> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignments == null) {
            return false;
        }
        for (Assignment assignment : assignments) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null || assignment instanceof Section && this.isToIgnoreStudentConflictsWith(assignment.getId()) || !this.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assigned(Enrollment enrollment) {
        if (this.iEnrollments.isEmpty()) {
            this.iMinEnrollmentWeight = this.iMaxEnrollmentWeight = enrollment.getRequest().getWeight();
        } else {
            this.iMaxEnrollmentWeight = Math.max(this.iMaxEnrollmentWeight, enrollment.getRequest().getWeight());
            this.iMinEnrollmentWeight = Math.min(this.iMinEnrollmentWeight, enrollment.getRequest().getWeight());
        }
        this.iEnrollments.add(enrollment);
        this.iEnrollmentWeight += enrollment.getRequest().getWeight();
    }

    @Override
    public void unassigned(Enrollment enrollment) {
        this.iEnrollments.remove(enrollment);
        this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
        if (this.iEnrollments.isEmpty()) {
            this.iMaxEnrollmentWeight = 0.0;
            this.iMinEnrollmentWeight = 0.0;
        } else if (this.iMinEnrollmentWeight != this.iMaxEnrollmentWeight) {
            if (this.iMinEnrollmentWeight == enrollment.getRequest().getWeight()) {
                double newMinEnrollmentWeight = Double.MAX_VALUE;
                for (Enrollment e : this.iEnrollments) {
                    if (e.getRequest().getWeight() == this.iMinEnrollmentWeight) {
                        newMinEnrollmentWeight = this.iMinEnrollmentWeight;
                        break;
                    }
                    newMinEnrollmentWeight = Math.min(newMinEnrollmentWeight, e.getRequest().getWeight());
                }
                this.iMinEnrollmentWeight = newMinEnrollmentWeight;
            }
            if (this.iMaxEnrollmentWeight == enrollment.getRequest().getWeight()) {
                double newMaxEnrollmentWeight = Double.MIN_VALUE;
                for (Enrollment e : this.iEnrollments) {
                    if (e.getRequest().getWeight() == this.iMaxEnrollmentWeight) {
                        newMaxEnrollmentWeight = this.iMaxEnrollmentWeight;
                        break;
                    }
                    newMaxEnrollmentWeight = Math.max(newMaxEnrollmentWeight, e.getRequest().getWeight());
                }
                this.iMaxEnrollmentWeight = newMaxEnrollmentWeight;
            }
        }
    }

    @Override
    public Set<Enrollment> getEnrollments() {
        return this.iEnrollments;
    }

    public double getEnrollmentWeight(Request excludeRequest) {
        double weight = this.iEnrollmentWeight;
        if (excludeRequest != null && excludeRequest.getAssignment() != null && this.iEnrollments.contains(excludeRequest.getAssignment())) {
            weight -= excludeRequest.getWeight();
        }
        return weight;
    }

    public double getMaxEnrollmentWeight() {
        return this.iMaxEnrollmentWeight;
    }

    public double getMinEnrollmentWeight() {
        return this.iMinEnrollmentWeight;
    }

    public String getLongName() {
        return this.getSubpart().getName() + " " + this.getName() + " " + (this.getTime() == null ? "" : " " + this.getTime().getLongName()) + (this.getNrRooms() == 0 ? "" : " " + this.getPlacement().getRoomName(",")) + (this.getChoice().getInstructorNames() == null ? "" : " " + this.getChoice().getInstructorNames());
    }

    public String toString() {
        return this.getSubpart().getConfig().getOffering().getName() + " " + this.getSubpart().getName() + " " + this.getName() + (this.getTime() == null ? "" : " " + this.getTime().getLongName()) + (this.getNrRooms() == 0 ? "" : " " + this.getPlacement().getRoomName(",")) + (this.getChoice().getInstructorNames() == null ? "" : " " + this.getChoice().getInstructorNames()) + " (L:" + (this.getLimit() < 0 ? "unlimited" : "" + this.getLimit()) + (this.getPenalty() == 0.0 ? "" : ",P:" + sDF.format(this.getPenalty())) + ")";
    }

    public Choice getChoice() {
        return this.iChoice;
    }

    public double getPenalty() {
        return this.iPenalty;
    }

    public void setPenalty(double penalty) {
        this.iPenalty = penalty;
    }

    @Override
    public int compareTo(Section s) {
        int cmp = Double.compare(this.getPenalty(), s.getPenalty());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare((double)this.getLimit() - this.getEnrollmentWeight(null), (double)s.getLimit() - s.getEnrollmentWeight(null));
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), s.getId());
    }

    public double getSpaceHeld() {
        return this.iSpaceHeld;
    }

    public void setSpaceHeld(double spaceHeld) {
        this.iSpaceHeld = spaceHeld;
    }

    public double getSpaceExpected() {
        return this.iSpaceExpected;
    }

    public void setSpaceExpected(double spaceExpected) {
        this.iSpaceExpected = spaceExpected;
    }

    public double getOnlineSectioningPenalty() {
        if (this.getLimit() <= 0) {
            return 0.0;
        }
        double available = (double)this.getLimit() - this.getEnrollmentWeight(null);
        double penalty = (this.getSpaceExpected() - available) / (double)this.getLimit();
        return Math.max(-1.0, Math.min(1.0, penalty));
    }

    @Override
    public boolean isAllowOverlap() {
        return this.iSubpart.isAllowOverlap();
    }

    @Override
    public int compareById(Assignment a) {
        if (a instanceof Section) {
            return new Long(this.getId()).compareTo(((Section)a).getId());
        }
        return -1;
    }

    public double getUnreservedSpace(Request excludeRequest) {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getSectionReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = (double)this.getLimit() - this.getEnrollmentWeight(excludeRequest);
        for (Reservation r : this.getSectionReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            double reserved = r.getReservedAvailableSpace(excludeRequest);
            available -= Math.max(0.0, reserved);
        }
        return available;
    }

    public double getTotalUnreservedSpace() {
        if (this.iTotalUnreservedSpace == null) {
            this.iTotalUnreservedSpace = this.getTotalUnreservedSpaceNoCache();
        }
        return this.iTotalUnreservedSpace;
    }

    private double getTotalUnreservedSpaceNoCache() {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getSectionReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = this.getLimit();
        double reserved = 0.0;
        double exclusive = 0.0;
        HashSet<Section> sections = new HashSet<Section>();
        block1: for (Reservation r : this.getSectionReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            for (Section s : r.getSections(this.getSubpart())) {
                if (s.equals(this)) continue;
                if (s.getLimit() < 0) continue block1;
                if (!sections.add(s)) continue;
                available += (double)s.getLimit();
            }
            reserved += r.getLimit();
            if (r.getSections(this.getSubpart()).size() != 1) continue;
            exclusive += r.getLimit();
        }
        return Math.min(available - reserved, (double)this.getLimit() - exclusive);
    }

    public List<Reservation> getReservations() {
        if (this.iReservations == null) {
            this.iReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getSubpart().getConfig().getOffering().getReservations()) {
                if (r.getSections(this.getSubpart()) != null && !r.getSections(this.getSubpart()).contains(this)) continue;
                this.iReservations.add(r);
            }
        }
        return this.iReservations;
    }

    public List<Reservation> getSectionReservations() {
        if (this.iSectionReservations == null) {
            this.iSectionReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getSubpart().getSectionReservations()) {
                if (!r.getSections(this.getSubpart()).contains(this)) continue;
                this.iSectionReservations.add(r);
            }
        }
        return this.iSectionReservations;
    }

    public void clearReservationCache() {
        this.iReservations = null;
        this.iSectionReservations = null;
        this.iTotalUnreservedSpace = null;
    }

    public String getName(long courseId) {
        if (this.iNameByCourse == null) {
            return this.getName();
        }
        String name = this.iNameByCourse.get(courseId);
        return name == null ? this.getName() : name;
    }

    public void setName(long courseId, String name) {
        if (this.iNameByCourse == null) {
            this.iNameByCourse = new HashMap<Long, String>();
        }
        this.iNameByCourse.put(courseId, name);
    }

    public Map<Long, String> getNameByCourse() {
        return this.iNameByCourse;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Section)) {
            return false;
        }
        return this.getId() == ((Section)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public void addIgnoreConflictWith(long sectionId) {
        if (this.iIgnoreConflictsWith == null) {
            this.iIgnoreConflictsWith = new HashSet<Long>();
        }
        this.iIgnoreConflictsWith.add(sectionId);
    }

    public boolean isToIgnoreStudentConflictsWith(long sectionId) {
        return this.iIgnoreConflictsWith != null && this.iIgnoreConflictsWith.contains(sectionId);
    }

    public Set<Long> getIgnoreConflictWithSectionIds() {
        return this.iIgnoreConflictsWith;
    }
}

