/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.Choice;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Offering {
    private long iId = -1L;
    private String iName = null;
    private List<Config> iConfigs = new ArrayList<Config>();
    private List<Course> iCourses = new ArrayList<Course>();
    private List<Reservation> iReservations = new ArrayList<Reservation>();
    Double iTotalUnreservedSpace = null;

    public Offering(long id, String name) {
        this.iId = id;
        this.iName = name;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public List<Config> getConfigs() {
        return this.iConfigs;
    }

    public List<Course> getCourses() {
        return this.iCourses;
    }

    public Section getSection(long sectionId) {
        for (Config config : this.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                for (Section section : subpart.getSections()) {
                    if (section.getId() != sectionId) continue;
                    return section;
                }
            }
        }
        return null;
    }

    public Course getCourse(Student student) {
        if (this.getCourses().isEmpty()) {
            return null;
        }
        if (this.getCourses().size() == 1) {
            return this.getCourses().get(0);
        }
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)request).getCourses()) {
                if (!this.getCourses().contains(course)) continue;
                return course;
            }
        }
        return this.getCourses().get(0);
    }

    public Set<String> getInstructionalTypes() {
        HashSet<String> instructionalTypes = new HashSet<String>();
        for (Config config : this.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                instructionalTypes.add(subpart.getInstructionalType());
            }
        }
        return instructionalTypes;
    }

    public Set<Choice> getChoices(String instructionalType) {
        HashSet<Choice> choices = new HashSet<Choice>();
        for (Config config : this.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!instructionalType.equals(subpart.getInstructionalType())) continue;
                choices.addAll(subpart.getChoices());
            }
        }
        return choices;
    }

    public Set<Subpart> getSubparts(String instructionalType) {
        HashSet<Subpart> subparts = new HashSet<Subpart>();
        for (Config config : this.getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!instructionalType.equals(subpart.getInstructionalType())) continue;
                subparts.add(subpart);
            }
        }
        return subparts;
    }

    public double getMinPenalty() {
        double min = Double.MAX_VALUE;
        for (Config config : this.getConfigs()) {
            min = Math.min(min, config.getMinPenalty());
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMaxPenalty() {
        double max = Double.MIN_VALUE;
        for (Config config : this.getConfigs()) {
            max = Math.max(max, config.getMaxPenalty());
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public String toString() {
        return this.iName;
    }

    public List<Reservation> getReservations() {
        return this.iReservations;
    }

    public boolean hasReservations() {
        return !this.iReservations.isEmpty();
    }

    public double getTotalUnreservedSpace() {
        if (this.iTotalUnreservedSpace == null) {
            this.iTotalUnreservedSpace = this.getTotalUnreservedSpaceNoCache();
        }
        return this.iTotalUnreservedSpace;
    }

    private double getTotalUnreservedSpaceNoCache() {
        double available = 0.0;
        for (Config config : this.getConfigs()) {
            available += (double)config.getLimit();
            if (config.getLimit() >= 0) continue;
            for (Reservation r : this.getReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double reserved = 0.0;
        for (Reservation r : this.getReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            reserved += r.getLimit();
        }
        return Math.max(0.0, available - reserved);
    }

    public double getUnreservedSpace(Request excludeRequest) {
        double available = 0.0;
        for (Config config : this.getConfigs()) {
            available += (double)config.getLimit() - config.getEnrollmentWeight(excludeRequest);
            if (config.getLimit() >= 0) continue;
            for (Reservation r : this.getReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double reserved = 0.0;
        for (Reservation r : this.getReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            reserved += Math.max(0.0, r.getReservedAvailableSpace(excludeRequest));
        }
        return available - reserved;
    }

    public void clearReservationCache() {
        for (Config config : this.getConfigs()) {
            config.clearReservationCache();
        }
        for (Course course : this.getCourses()) {
            for (CourseRequest r : course.getRequests()) {
                r.clearReservationCache();
            }
        }
        this.iTotalUnreservedSpace = null;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Offering)) {
            return false;
        }
        return this.getId() == ((Offering)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }
}

