/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeTimeRequest
extends Request
implements Assignment {
    private TimeLocation iTime = null;
    private HashSet<Enrollment> iEnrollments = new HashSet();

    public FreeTimeRequest(long id, int priority, boolean alternative, Student student, TimeLocation time) {
        super(id, priority, alternative, student);
        this.iTime = time;
    }

    @Override
    public TimeLocation getTime() {
        return this.iTime;
    }

    @Override
    public int getNrRooms() {
        return 0;
    }

    @Override
    public List<RoomLocation> getRooms() {
        return new ArrayList<RoomLocation>(0);
    }

    @Override
    public boolean isOverlapping(Assignment assignment) {
        if (this.isAllowOverlap() || assignment.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignment.getTime() == null) {
            return false;
        }
        if (assignment instanceof FreeTimeRequest) {
            return false;
        }
        return this.getTime().hasIntersection(assignment.getTime());
    }

    @Override
    public boolean isOverlapping(Set<? extends Assignment> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null) {
            return false;
        }
        for (Assignment assignment : assignments) {
            if (assignment.isAllowOverlap() || assignment.getTime() == null) continue;
            if (assignment instanceof FreeTimeRequest) {
                return false;
            }
            if (!this.getTime().hasIntersection(assignment.getTime())) continue;
            return true;
        }
        return false;
    }

    public Enrollment createEnrollment() {
        HashSet<FreeTimeRequest> assignments = new HashSet<FreeTimeRequest>();
        assignments.add(this);
        return new Enrollment(this, 0, null, assignments);
    }

    @Override
    public List<Enrollment> computeEnrollments() {
        ArrayList<Enrollment> enrollments = new ArrayList<Enrollment>(1);
        enrollments.add(this.createEnrollment());
        return enrollments;
    }

    @Override
    public void assigned(Enrollment enrollment) {
        this.iEnrollments.add(enrollment);
    }

    @Override
    public void unassigned(Enrollment enrollment) {
        this.iEnrollments.remove(enrollment);
    }

    @Override
    public Set<Enrollment> getEnrollments() {
        return this.iEnrollments;
    }

    @Override
    public String getName() {
        return (this.isAlternative() ? "A" : "") + (1 + this.getPriority() + (this.isAlternative() ? -this.getStudent().nrRequests() : 0)) + ". Free Time " + this.getTime().getDayHeader() + " " + this.getTime().getStartTimeHeader() + " - " + this.getTime().getEndTimeHeader();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public double getBound() {
        return -this.getWeight() * ((StudentSectioningModel)this.getModel()).getStudentWeights().getBound(this);
    }

    @Override
    public boolean isAllowOverlap() {
        return this.getModel() == null ? true : ((StudentSectioningModel)this.getModel()).getStudentWeights().isFreeTimeAllowOverlaps();
    }

    @Override
    public int compareById(Assignment a) {
        if (a instanceof FreeTimeRequest) {
            return new Long(this.getId()).compareTo(((FreeTimeRequest)a).getId());
        }
        return 1;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.getTime().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof CourseRequest && this.getTime().equals((Object)((FreeTimeRequest)o).getTime());
    }
}

