/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.FreeTimeRequest;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enrollment
extends Value<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private Request iRequest = null;
    private Config iConfig = null;
    private Course iCourse = null;
    private Set<? extends Assignment> iAssignments = null;
    private Double iCachedPenalty = null;
    private int iPriority = 0;
    private Reservation iReservation = null;
    private Long iTimeStamp = null;
    private String iApproval = null;

    public Enrollment(Request request, int priority, Course course, Config config, Set<? extends Assignment> assignments, Reservation reservation) {
        super(request);
        this.iRequest = request;
        this.iConfig = config;
        this.iAssignments = assignments;
        this.iPriority = priority;
        this.iCourse = course;
        if (this.iConfig != null && this.iCourse == null) {
            for (Course c : ((CourseRequest)this.iRequest).getCourses()) {
                if (!c.getOffering().getConfigs().contains(this.iConfig)) continue;
                this.iCourse = c;
                break;
            }
        }
        this.iReservation = reservation;
    }

    public Enrollment(Request request, int priority, Config config, Set<? extends Assignment> assignments) {
        this(request, priority, null, config, assignments, null);
        if (assignments != null) {
            this.guessReservation(true);
        }
    }

    public void guessReservation(boolean onlyAvailable) {
        if (this.iCourse != null) {
            Reservation best = null;
            boolean canAssignOverTheLimit = ((Request)this.variable()).getModel() == null || ((StudentSectioningModel)((Request)this.variable()).getModel()).getReservationCanAssignOverTheLimit();
            for (Reservation reservation : ((CourseRequest)this.iRequest).getReservations(this.iCourse)) {
                if (!reservation.isIncluded(this) || onlyAvailable && reservation.getReservedAvailableSpace(this.iRequest) < this.iRequest.getWeight() && (!reservation.canAssignOverLimit() || !canAssignOverTheLimit)) continue;
                if (best == null || best.getPriority() > reservation.getPriority()) {
                    best = reservation;
                    continue;
                }
                if (best.getPriority() != reservation.getPriority() || !(best.getReservedAvailableSpace(this.iRequest) < reservation.getReservedAvailableSpace(this.iRequest))) continue;
                best = reservation;
            }
            this.iReservation = best;
        }
    }

    public Student getStudent() {
        return this.iRequest.getStudent();
    }

    public Request getRequest() {
        return this.iRequest;
    }

    public boolean isCourseRequest() {
        return this.iConfig != null;
    }

    public Offering getOffering() {
        return this.iConfig == null ? null : this.iConfig.getOffering();
    }

    public Config getConfig() {
        return this.iConfig;
    }

    public Course getCourse() {
        return this.iCourse;
    }

    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public Set<Section> getSections() {
        if (this.isCourseRequest()) {
            return this.iAssignments;
        }
        return new HashSet<Section>();
    }

    public boolean isOverlapping(Enrollment enrl) {
        if (enrl == null || this.isAllowOverlap() || enrl.isAllowOverlap()) {
            return false;
        }
        for (Assignment a : this.getAssignments()) {
            if (!a.isOverlapping(enrl.getAssignments())) continue;
            return true;
        }
        return false;
    }

    public double percentWaitlisted() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        int nrWaitlisted = 0;
        for (Section section : this.getSections()) {
            if (!courseRequest.isWaitlisted(section)) continue;
            ++nrWaitlisted;
        }
        return (double)nrWaitlisted / (double)this.getAssignments().size();
    }

    public double percentSelected() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        int nrSelected = 0;
        for (Section section : this.getSections()) {
            if (!courseRequest.isSelected(section)) continue;
            ++nrSelected;
        }
        return (double)nrSelected / (double)this.getAssignments().size();
    }

    public double percentInitial() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        if (this.getRequest().getInitialAssignment() == null) {
            return 0.0;
        }
        Enrollment inital = (Enrollment)this.getRequest().getInitialAssignment();
        int nrInitial = 0;
        for (Section section : this.getSections()) {
            if (!inital.getAssignments().contains(section)) continue;
            ++nrInitial;
        }
        return (double)nrInitial / (double)this.getAssignments().size();
    }

    public boolean isWaitlisted() {
        if (!this.isCourseRequest()) {
            return false;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        for (Section section : this.getAssignments()) {
            if (courseRequest.isWaitlisted(section)) continue;
            return false;
        }
        return true;
    }

    public boolean isSelected() {
        if (!this.isCourseRequest()) {
            return false;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        for (Section section : this.getSections()) {
            if (courseRequest.isSelected(section)) continue;
            return false;
        }
        return true;
    }

    public double getPenalty() {
        if (this.iCachedPenalty == null) {
            double penalty = 0.0;
            if (this.isCourseRequest()) {
                for (Section section : this.getSections()) {
                    penalty += section.getPenalty();
                }
            }
            this.iCachedPenalty = new Double(penalty / (double)this.getAssignments().size());
        }
        return this.iCachedPenalty;
    }

    @Override
    public double toDouble() {
        return this.toDouble(true);
    }

    public double toDouble(boolean precise) {
        if (precise) {
            return -this.getRequest().getWeight() * ((StudentSectioningModel)((Request)this.variable()).getModel()).getStudentWeights().getWeight(this, this.distanceConflicts(), this.timeOverlappingConflicts());
        }
        if (this.getExtra() != null) {
            return -((Double)this.getExtra()).doubleValue();
        }
        return -this.getRequest().getWeight() * ((StudentSectioningModel)((Request)this.variable()).getModel()).getStudentWeights().getWeight(this);
    }

    @Override
    public String getName() {
        if (this.getRequest() instanceof CourseRequest) {
            Course course = null;
            CourseRequest courseRequest = (CourseRequest)this.getRequest();
            for (Course c : courseRequest.getCourses()) {
                if (!c.getOffering().getConfigs().contains(this.getConfig())) continue;
                course = c;
                break;
            }
            String ret = course == null ? (this.getConfig() == null ? "" : this.getConfig().getName()) : course.getName();
            Iterator<Assignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                Section assignment = (Section)i.next();
                ret = ret + "\n  " + assignment.getLongName() + (i.hasNext() ? "," : "");
            }
            return ret;
        }
        if (this.getRequest() instanceof FreeTimeRequest) {
            return "Free Time " + ((FreeTimeRequest)this.getRequest()).getTime().getLongName();
        }
        String ret = "";
        Iterator<Assignment> i = this.getAssignments().iterator();
        while (i.hasNext()) {
            Assignment assignment = i.next();
            ret = ret + assignment.toString() + (i.hasNext() ? "," : "");
            if (!i.hasNext()) continue;
            ret = ret + "\n  ";
        }
        return ret;
    }

    @Override
    public String toString() {
        if (this.getAssignments().isEmpty()) {
            return "not assigned";
        }
        Set<DistanceConflict.Conflict> dc = this.distanceConflicts();
        Set<TimeOverlapsCounter.Conflict> toc = this.timeOverlappingConflicts();
        int share = 0;
        if (toc != null) {
            for (TimeOverlapsCounter.Conflict c : toc) {
                share += c.getShare();
            }
        }
        String ret = sDF.format(this.toDouble()) + "/" + sDF.format(this.getRequest().getBound()) + (this.getPenalty() == 0.0 ? "" : "/" + sDF.format(this.getPenalty())) + (dc == null || dc.isEmpty() ? "" : "/dc:" + dc.size()) + (share <= 0 ? "" : "/toc:" + share);
        if (this.getRequest() instanceof CourseRequest) {
            ret = ret + " ";
            Iterator<Assignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                Assignment assignment = i.next();
                ret = ret + assignment + (i.hasNext() ? ", " : "");
            }
        }
        if (this.getReservation() != null) {
            ret = "(r) " + ret;
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Enrollment)) {
            return false;
        }
        Enrollment e = (Enrollment)o;
        if (!ToolBox.equals(this.getConfig(), e.getConfig())) {
            return false;
        }
        if (!ToolBox.equals(this.getRequest(), e.getRequest())) {
            return false;
        }
        return ToolBox.equals(this.getAssignments(), e.getAssignments());
    }

    public Set<DistanceConflict.Conflict> distanceConflicts() {
        if (!this.isCourseRequest()) {
            return null;
        }
        if (this.getRequest().getModel() instanceof StudentSectioningModel) {
            DistanceConflict dc = ((StudentSectioningModel)this.getRequest().getModel()).getDistanceConflict();
            if (dc == null) {
                return null;
            }
            return dc.allConflicts(this);
        }
        return null;
    }

    public Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts() {
        if (this.getRequest().getModel() instanceof StudentSectioningModel) {
            TimeOverlapsCounter toc = ((StudentSectioningModel)this.getRequest().getModel()).getTimeOverlaps();
            if (toc == null) {
                return null;
            }
            return toc.allConflicts(this);
        }
        return null;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public int getNrSlots() {
        int ret = 0;
        for (Assignment a : this.getAssignments()) {
            if (a.getTime() == null) continue;
            ret += a.getTime().getLength() * a.getTime().getNrMeetings();
        }
        return ret;
    }

    public Reservation getReservation() {
        return this.iReservation;
    }

    public void setReservation(Reservation reservation) {
        this.iReservation = reservation;
    }

    public Long getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    public String getApproval() {
        return this.iApproval;
    }

    public void setApproval(String approval) {
        this.iApproval = approval;
    }

    public boolean isAllowOverlap() {
        return this.getReservation() != null && this.getReservation().isAllowOverlap();
    }

    public int getLimit() {
        if (!this.isCourseRequest()) {
            return -1;
        }
        Integer limit = null;
        for (Section section : this.getSections()) {
            if (section.getLimit() < 0) continue;
            if (limit == null) {
                limit = section.getLimit();
                continue;
            }
            limit = Math.min(limit, section.getLimit());
        }
        return limit == null ? -1 : limit;
    }
}

