/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.reservation.Reservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private long iId = -1L;
    private String iName = null;
    private Offering iOffering = null;
    private int iLimit = -1;
    private List<Subpart> iSubparts = new ArrayList<Subpart>();
    private double iEnrollmentWeight = 0.0;
    private double iMaxEnrollmentWeight = 0.0;
    private double iMinEnrollmentWeight = 0.0;
    private Set<Enrollment> iEnrollments = new HashSet<Enrollment>();
    private Double iTotalUnreservedSpace = null;
    List<Reservation> iReservations = null;
    List<Reservation> iConfigReservations = null;

    public Config(long id, int limit, String name, Offering offering) {
        this.iId = id;
        this.iLimit = limit;
        this.iName = name;
        this.iOffering = offering;
        this.iOffering.getConfigs().add(this);
    }

    public long getId() {
        return this.iId;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public String getName() {
        return this.iName;
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public List<Subpart> getSubparts() {
        return this.iSubparts;
    }

    public String toString() {
        return this.getName();
    }

    public double getMinPenalty() {
        double min = 0.0;
        for (Subpart subpart : this.getSubparts()) {
            min += subpart.getMinPenalty();
        }
        return min / (double)this.getSubparts().size();
    }

    public double getMaxPenalty() {
        double max = 0.0;
        for (Subpart subpart : this.getSubparts()) {
            max += subpart.getMinPenalty();
        }
        return max / (double)this.getSubparts().size();
    }

    public void assigned(Enrollment enrollment) {
        if (this.iEnrollments.isEmpty()) {
            this.iMinEnrollmentWeight = this.iMaxEnrollmentWeight = enrollment.getRequest().getWeight();
        } else {
            this.iMaxEnrollmentWeight = Math.max(this.iMaxEnrollmentWeight, enrollment.getRequest().getWeight());
            this.iMinEnrollmentWeight = Math.min(this.iMinEnrollmentWeight, enrollment.getRequest().getWeight());
        }
        this.iEnrollments.add(enrollment);
        this.iEnrollmentWeight += enrollment.getRequest().getWeight();
    }

    public void unassigned(Enrollment enrollment) {
        this.iEnrollments.remove(enrollment);
        this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
        if (this.iEnrollments.isEmpty()) {
            this.iMaxEnrollmentWeight = 0.0;
            this.iMinEnrollmentWeight = 0.0;
        } else if (this.iMinEnrollmentWeight != this.iMaxEnrollmentWeight) {
            if (this.iMinEnrollmentWeight == enrollment.getRequest().getWeight()) {
                double newMinEnrollmentWeight = Double.MAX_VALUE;
                for (Enrollment e : this.iEnrollments) {
                    if (e.getRequest().getWeight() == this.iMinEnrollmentWeight) {
                        newMinEnrollmentWeight = this.iMinEnrollmentWeight;
                        break;
                    }
                    newMinEnrollmentWeight = Math.min(newMinEnrollmentWeight, e.getRequest().getWeight());
                }
                this.iMinEnrollmentWeight = newMinEnrollmentWeight;
            }
            if (this.iMaxEnrollmentWeight == enrollment.getRequest().getWeight()) {
                double newMaxEnrollmentWeight = Double.MIN_VALUE;
                for (Enrollment e : this.iEnrollments) {
                    if (e.getRequest().getWeight() == this.iMaxEnrollmentWeight) {
                        newMaxEnrollmentWeight = this.iMaxEnrollmentWeight;
                        break;
                    }
                    newMaxEnrollmentWeight = Math.max(newMaxEnrollmentWeight, e.getRequest().getWeight());
                }
                this.iMaxEnrollmentWeight = newMaxEnrollmentWeight;
            }
        }
    }

    public double getEnrollmentWeight(Request excludeRequest) {
        double weight = this.iEnrollmentWeight;
        if (excludeRequest != null && excludeRequest.getAssignment() != null && this.iEnrollments.contains(excludeRequest.getAssignment())) {
            weight -= excludeRequest.getWeight();
        }
        return weight;
    }

    public Set<Enrollment> getEnrollments() {
        return this.iEnrollments;
    }

    public double getMaxEnrollmentWeight() {
        return this.iMaxEnrollmentWeight;
    }

    public double getMinEnrollmentWeight() {
        return this.iMinEnrollmentWeight;
    }

    public double getUnreservedSpace(Request excludeRequest) {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getConfigReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = (double)this.getLimit() - this.getEnrollmentWeight(excludeRequest);
        for (Reservation r : this.getConfigReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            double reserved = r.getReservedAvailableSpace(excludeRequest);
            available -= Math.max(0.0, reserved);
        }
        return available;
    }

    public double getTotalUnreservedSpace() {
        if (this.iTotalUnreservedSpace == null) {
            this.iTotalUnreservedSpace = this.getTotalUnreservedSpaceNoCache();
        }
        return this.iTotalUnreservedSpace;
    }

    private double getTotalUnreservedSpaceNoCache() {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getConfigReservations()) {
                if (r.isExpired() || !(r.getLimit() < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = this.getLimit();
        double reserved = 0.0;
        double exclusive = 0.0;
        HashSet<Config> configs = new HashSet<Config>();
        block1: for (Reservation r : this.getConfigReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit() < 0.0) {
                return 0.0;
            }
            for (Config s : r.getConfigs()) {
                if (s.equals(this)) continue;
                if (s.getLimit() < 0) continue block1;
                if (!configs.add(s)) continue;
                available += (double)s.getLimit();
            }
            reserved += r.getLimit();
            if (r.getConfigs().size() != 1) continue;
            exclusive += r.getLimit();
        }
        return Math.min(available - reserved, (double)this.getLimit() - exclusive);
    }

    public List<Reservation> getReservations() {
        if (this.iReservations == null) {
            this.iReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getOffering().getReservations()) {
                if (!r.getConfigs().isEmpty() && !r.getConfigs().contains(this)) continue;
                this.iReservations.add(r);
            }
        }
        return this.iReservations;
    }

    public List<Reservation> getConfigReservations() {
        if (this.iConfigReservations == null) {
            this.iConfigReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getOffering().getReservations()) {
                if (r.getConfigs().isEmpty() || !r.getConfigs().contains(this)) continue;
                this.iConfigReservations.add(r);
            }
        }
        return this.iConfigReservations;
    }

    public void clearReservationCache() {
        for (Subpart s : this.getSubparts()) {
            s.clearReservationCache();
        }
        this.iReservations = null;
        this.iConfigReservations = null;
        this.iTotalUnreservedSpace = null;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Config)) {
            return false;
        }
        return this.getId() == ((Config)o).getId();
    }

    public int hashCode() {
        return new Long(this.getId()).hashCode();
    }
}

