/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardSelection
implements NeighbourSelection<Request, Enrollment> {
    private long iIteration = 0L;
    private ValueSelection<Request, Enrollment> iValueSelection = null;
    private VariableSelection<Request, Enrollment> iVariableSelection = null;
    protected long iNrIterations = -1L;

    public StandardSelection(DataProperties properties, VariableSelection<Request, Enrollment> variableSelection, ValueSelection<Request, Enrollment> valueSelection) {
        this.iVariableSelection = variableSelection;
        this.iValueSelection = valueSelection;
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iIteration = solver.currentSolution().getIteration();
        this.iNrIterations = solver.getProperties().getPropertyLong("Neighbour.StandardIterations", -1L);
        if (this.iNrIterations > 0L) {
            Progress.getInstance(solver.currentSolution().getModel()).setPhase("Ifs...", this.iNrIterations);
        }
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (this.iNrIterations < 0L) {
            this.iNrIterations = solution.getModel().unassignedVariables().size();
            Progress.getInstance(solution.getModel()).setPhase("Ifs...", this.iNrIterations);
        }
        if (solution.getModel().unassignedVariables().isEmpty() || solution.getIteration() >= this.iIteration + this.iNrIterations) {
            return null;
        }
        Progress.getInstance(solution.getModel()).incProgress();
        for (int i = 0; i < 10; ++i) {
            Enrollment enrollment;
            Request request = this.iVariableSelection.selectVariable(solution);
            Enrollment enrollment2 = enrollment = request == null ? null : this.iValueSelection.selectValue(solution, request);
            if (enrollment == null || ((Request)enrollment.variable()).getModel().conflictValues(enrollment).contains(enrollment)) continue;
            return new SimpleNeighbour<Request, Enrollment>(request, enrollment);
        }
        return null;
    }
}

