/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import java.util.Set;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.heuristics.selection.ProblemStudentsProvider;
import net.sf.cpsolver.studentsct.heuristics.selection.RandomUnassignmentSelection;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RndUnProblStudSelection
extends RandomUnassignmentSelection {
    private ProblemStudentsProvider iProblemStudentsProvider = null;
    private Set<Student> iProblemStudents = null;

    public RndUnProblStudSelection(DataProperties properties, ProblemStudentsProvider psp) {
        super(properties);
        this.iProblemStudentsProvider = psp;
        this.iRandom = properties.getPropertyDouble("Neighbour.RandomUnassignmentOfProblemStudentProb", 0.9);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.iProblemStudents = this.iProblemStudentsProvider.getProblemStudents();
        Progress.getInstance(solver.currentSolution().getModel()).setPhase("Random unassignment of problematic students...", 1L);
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (!this.iProblemStudents.isEmpty() && Math.random() < this.iRandom) {
            Student student = ToolBox.random(this.iProblemStudents);
            this.iProblemStudents.remove(student);
            return new RandomUnassignmentSelection.UnassignStudentNeighbour(student);
        }
        Progress.getInstance(solution.getModel()).incProgress();
        return null;
    }
}

