/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentRandomOrder;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResectionIncompleteStudentsSelection
extends BranchBoundSelection {
    private static Logger sLog = Logger.getLogger(ResectionIncompleteStudentsSelection.class);

    public ResectionIncompleteStudentsSelection(DataProperties properties) {
        super(properties);
        this.iOrder = new StudentRandomOrder(properties);
        if (properties.getProperty("Neighbour.ResectionIncompleteStudentsOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.ResectionIncompleteStudentsOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to set student order, reason:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Resection incomplete students...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        while (this.iStudentsEnumeration.hasNext()) {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            Student student = (Student)this.iStudentsEnumeration.next();
            Progress.getInstance(solution.getModel()).incProgress();
            if (student.nrAssignedRequests() == 0 || student.isComplete() || (neighbour = this.getSelection(student).select()) == null) continue;
            return neighbour;
        }
        return null;
    }
}

