/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.studentsct.heuristics.RandomizedBacktrackNeighbourSelection;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktrackSelection
implements NeighbourSelection<Request, Enrollment> {
    private RandomizedBacktrackNeighbourSelection iRBtNSel = null;
    private Iterator<Request> iRequestIterator = null;

    public BacktrackSelection(DataProperties properties) {
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        ArrayList<Request> unassigned = new ArrayList<Request>(solver.currentSolution().getModel().unassignedVariables());
        Collections.shuffle(unassigned);
        this.iRequestIterator = unassigned.iterator();
        if (this.iRBtNSel == null) {
            try {
                this.iRBtNSel = new RandomizedBacktrackNeighbourSelection(solver.getProperties());
                this.iRBtNSel.init(solver);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, unassigned.size());
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Backtracking...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        while (this.iRequestIterator.hasNext()) {
            Request request = this.iRequestIterator.next();
            Progress.getInstance(solution.getModel()).incProgress();
            Neighbour<Request, Enrollment> n = this.iRBtNSel.selectNeighbour(solution, request);
            if (n == null || !(n.value() <= 0.0)) continue;
            return n;
        }
        return null;
    }
}

