/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics;

import net.sf.cpsolver.ifs.heuristics.RoundRobinNeighbourSelection;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.heuristics.RouletteWheelRequestSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.PriorityConstructionSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.RandomUnassignmentSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.ResectionIncompleteStudentsSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.ResectionUnassignedStudentsSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.RndUnProblStudSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.StandardSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.SwapStudentSelection;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSctNeighbourSelection
extends RoundRobinNeighbourSelection<Request, Enrollment> {
    private static Logger sLog = Logger.getLogger(StudentSctNeighbourSelection.class);
    private boolean iUseConstruction = false;

    public StudentSctNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iUseConstruction = properties.getPropertyBoolean("Sectioning.UsePriorityConstruction", this.iUseConstruction);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        super.init(solver);
        this.setup(solver);
        solver.setUpdateProgress(false);
    }

    public void setup(Solver<Request, Enrollment> solver) {
        this.registerSelection(this.iUseConstruction ? new PriorityConstructionSelection(solver.getProperties()) : new BranchBoundSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), this.getVariableSelection(), this.getValueSelection()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        SwapStudentSelection swapStudentSelection = new SwapStudentSelection(solver.getProperties());
        this.registerSelection(swapStudentSelection);
        this.registerSelection(new RndUnProblStudSelection(solver.getProperties(), swapStudentSelection));
        this.registerSelection(new ResectionIncompleteStudentsSelection(solver.getProperties()));
        this.registerSelection(new ResectionUnassignedStudentsSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), new RouletteWheelRequestSelection(solver.getProperties()), this.getValueSelection()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        this.registerSelection(new RandomUnassignmentSelection(solver.getProperties()));
    }

    @Override
    public void changeSelection(Solution<Request, Enrollment> solution) {
        super.changeSelection(solution);
        sLog.debug((Object)("Current solution: " + ToolBox.dict2string(solution.getExtendedInfo(), 2)));
    }
}

