/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.heuristics;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomizedBacktrackNeighbourSelection
extends BacktrackNeighbourSelection<Request, Enrollment> {
    private int iMaxValues = 100;

    public RandomizedBacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iMaxValues = properties.getPropertyInt("Neighbour.MaxValues", this.iMaxValues);
    }

    @Override
    protected Iterator<Enrollment> values(Request variable) {
        if (this.iMaxValues > 0 && variable instanceof CourseRequest) {
            return new ArrayList<Enrollment>(((CourseRequest)variable).computeRandomEnrollments(this.iMaxValues)).iterator();
        }
        return variable.values().iterator();
    }
}

