/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.extension;

import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.FreeTimeRequest;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeOverlapsCounter
extends Extension<Request, Enrollment> {
    private static Logger sLog = Logger.getLogger(TimeOverlapsCounter.class);
    private int iTotalNrConflicts = 0;
    private Set<Conflict> iAllConflicts = new HashSet<Conflict>();
    public static boolean sDebug = false;
    private Request iOldVariable = null;
    private Enrollment iUnassignedValue = null;

    public TimeOverlapsCounter(Solver<Request, Enrollment> solver, DataProperties properties) {
        super(solver, properties);
        if (solver != null) {
            ((StudentSectioningModel)solver.currentSolution().getModel()).setTimeOverlaps(this);
        }
    }

    @Override
    public boolean init(Solver<Request, Enrollment> solver) {
        this.iTotalNrConflicts = this.countTotalNrConflicts();
        if (sDebug) {
            this.iAllConflicts = this.computeAllConflicts();
        }
        StudentSectioningModel m = (StudentSectioningModel)solver.currentSolution().getModel();
        for (Conflict c : this.computeAllConflicts()) {
            m.add(c);
        }
        return true;
    }

    public String toString() {
        return "TimeOverlaps";
    }

    public boolean inConflict(Assignment a1, Assignment a2) {
        if (a1.getTime() == null || a2.getTime() == null) {
            return false;
        }
        if (a1 instanceof Section && a2 instanceof Section && ((Section)a1).isToIgnoreStudentConflictsWith(a2.getId())) {
            return false;
        }
        return a1.getTime().hasIntersection(a2.getTime());
    }

    public int share(Assignment a1, Assignment a2) {
        if (!this.inConflict(a1, a2)) {
            return 0;
        }
        return a1.getTime().nrSharedDays(a2.getTime()) * a1.getTime().nrSharedHours(a2.getTime());
    }

    public int nrConflicts(Enrollment e1, Enrollment e2) {
        if (!e1.getStudent().equals(e2.getStudent())) {
            return 0;
        }
        if (e1.getRequest() instanceof FreeTimeRequest && e2.getRequest() instanceof FreeTimeRequest) {
            return 0;
        }
        int cnt = 0;
        for (Assignment s1 : e1.getAssignments()) {
            for (Assignment s2 : e2.getAssignments()) {
                if (!this.inConflict(s1, s2)) continue;
                cnt += this.share(s1, s2);
            }
        }
        return cnt;
    }

    public Set<Conflict> conflicts(Enrollment e1, Enrollment e2) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (!e1.getStudent().equals(e2.getStudent())) {
            return ret;
        }
        if (e1.getRequest() instanceof FreeTimeRequest && e2.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (Assignment s1 : e1.getAssignments()) {
            for (Assignment s2 : e2.getAssignments()) {
                if (!this.inConflict(s1, s2)) continue;
                ret.add(new Conflict(e1.getStudent(), this.share(s1, s2), e1, s1, e2, s2));
            }
        }
        return ret;
    }

    public int nrAllConflicts(Enrollment enrollment) {
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return 0;
        }
        int cnt = 0;
        for (Request request : enrollment.getStudent().getRequests()) {
            if (request.equals(enrollment.getRequest())) continue;
            if (request instanceof FreeTimeRequest) {
                FreeTimeRequest ft = (FreeTimeRequest)request;
                cnt += this.nrConflicts(enrollment, ft.createEnrollment());
                continue;
            }
            if (request.getAssignment() == null || request.equals(this.iOldVariable)) continue;
            cnt += this.nrConflicts(enrollment, (Enrollment)request.getAssignment());
        }
        return cnt;
    }

    public int nrFreeTimeConflicts(Enrollment enrollment) {
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return 0;
        }
        int cnt = 0;
        for (Request request : enrollment.getStudent().getRequests()) {
            if (!(request instanceof FreeTimeRequest)) continue;
            FreeTimeRequest ft = (FreeTimeRequest)request;
            for (Assignment section : enrollment.getAssignments()) {
                cnt += this.share(section, ft);
            }
        }
        return cnt;
    }

    public Set<Conflict> freeTimeConflicts(Enrollment enrollment) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (Request request : enrollment.getStudent().getRequests()) {
            if (!(request instanceof FreeTimeRequest)) continue;
            FreeTimeRequest ft = (FreeTimeRequest)request;
            for (Assignment section : enrollment.getAssignments()) {
                if (!this.inConflict(section, ft)) continue;
                ret.add(new Conflict(enrollment.getStudent(), this.share(section, ft), enrollment, section, ft.createEnrollment(), ft));
            }
        }
        return ret;
    }

    public Set<Conflict> allConflicts(Enrollment enrollment) {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        if (enrollment.getRequest() instanceof FreeTimeRequest) {
            return ret;
        }
        for (Request request : enrollment.getStudent().getRequests()) {
            if (request.equals(enrollment.getRequest())) continue;
            if (request instanceof FreeTimeRequest) {
                FreeTimeRequest ft = (FreeTimeRequest)request;
                ret.addAll(this.conflicts(enrollment, ft.createEnrollment()));
                continue;
            }
            if (request.getAssignment() == null || request.equals(this.iOldVariable)) continue;
            ret.addAll(this.conflicts(enrollment, (Enrollment)request.getAssignment()));
        }
        return ret;
    }

    public void assigned(long iteration, Enrollment value) {
        StudentSectioningModel m = (StudentSectioningModel)((Request)value.variable()).getModel();
        for (Conflict c : this.allConflicts(value)) {
            this.iTotalNrConflicts += c.getShare();
            m.add(c);
        }
        if (sDebug) {
            sLog.debug((Object)("A:" + value.variable() + " := " + value));
            int inc = this.nrAllConflicts(value);
            if (inc != 0) {
                sLog.debug((Object)("-- TOC+" + inc + " A: " + value.variable() + " := " + value));
                for (Conflict c : this.allConflicts(value)) {
                    sLog.debug((Object)("  -- " + c));
                    this.iAllConflicts.add(c);
                    inc -= c.getShare();
                }
                if (inc != 0) {
                    sLog.error((Object)("Different number of conflicts for the assigned value (difference: " + inc + ")!"));
                }
            }
        }
    }

    public void unassigned(long iteration, Enrollment value) {
        StudentSectioningModel m = (StudentSectioningModel)((Request)value.variable()).getModel();
        for (Conflict c : this.allConflicts(value)) {
            this.iTotalNrConflicts -= c.getShare();
            m.remove(c);
        }
        if (sDebug) {
            sLog.debug((Object)("U:" + value.variable() + " := " + value));
            int dec = this.nrAllConflicts(value);
            if (dec != 0) {
                sLog.debug((Object)("-- TOC-" + dec + " U: " + value.variable() + " := " + value));
                for (Conflict c : this.allConflicts(value)) {
                    sLog.debug((Object)("  -- " + c));
                    this.iAllConflicts.remove(c);
                    dec -= c.getShare();
                }
                if (dec != 0) {
                    sLog.error((Object)("Different number of conflicts for the unassigned value (difference: " + dec + ")!"));
                }
            }
        }
    }

    public int getTotalNrConflicts() {
        return this.iTotalNrConflicts;
    }

    public void checkTotalNrConflicts() {
        int total = this.countTotalNrConflicts();
        if (total != this.iTotalNrConflicts) {
            sLog.error((Object)("Number of conflicts does not match (actual: " + total + ", count: " + this.iTotalNrConflicts + ")!"));
            this.iTotalNrConflicts = total;
            if (sDebug) {
                Set<Conflict> conflicts = this.computeAllConflicts();
                for (Conflict c : conflicts) {
                    if (this.iAllConflicts.contains(c)) continue;
                    sLog.debug((Object)("  +add+ " + c));
                }
                for (Conflict c : this.iAllConflicts) {
                    if (conflicts.contains(c)) continue;
                    sLog.debug((Object)("  -rem- " + c));
                }
                for (Conflict c : conflicts) {
                    for (Conflict d : this.iAllConflicts) {
                        if (!c.equals(d) || c.getShare() == d.getShare()) continue;
                        sLog.debug((Object)("  -dif- " + c + " (other: " + d.getShare() + ")"));
                    }
                }
                this.iAllConflicts = conflicts;
            }
        }
    }

    public int countTotalNrConflicts() {
        int total = 0;
        for (Request r1 : this.getModel().variables()) {
            if (r1.getAssignment() == null || r1 instanceof FreeTimeRequest || r1.equals(this.iOldVariable)) continue;
            for (Request r2 : r1.getStudent().getRequests()) {
                if (r2 instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)r2;
                    total += this.nrConflicts((Enrollment)r1.getAssignment(), ft.createEnrollment());
                    continue;
                }
                if (r2.getAssignment() == null || r1.getId() >= r2.getId() || r2.equals(this.iOldVariable)) continue;
                total += this.nrConflicts((Enrollment)r1.getAssignment(), (Enrollment)r2.getAssignment());
            }
        }
        return total;
    }

    public Set<Conflict> computeAllConflicts() {
        HashSet<Conflict> ret = new HashSet<Conflict>();
        for (Request r1 : this.getModel().variables()) {
            if (r1.getAssignment() == null || r1 instanceof FreeTimeRequest || r1.equals(this.iOldVariable)) continue;
            for (Request r2 : r1.getStudent().getRequests()) {
                if (r2 instanceof FreeTimeRequest) {
                    FreeTimeRequest ft = (FreeTimeRequest)r2;
                    ret.addAll(this.conflicts((Enrollment)r1.getAssignment(), ft.createEnrollment()));
                    continue;
                }
                if (r2.getAssignment() == null || r1.getId() >= r2.getId() || r2.equals(this.iOldVariable)) continue;
                ret.addAll(this.conflicts((Enrollment)r1.getAssignment(), (Enrollment)r2.getAssignment()));
            }
        }
        return ret;
    }

    public Set<Conflict> getAllConflicts() {
        return this.iAllConflicts;
    }

    @Override
    public void beforeAssigned(long iteration, Enrollment value) {
        if (value != null) {
            if (((Request)value.variable()).getAssignment() != null) {
                this.iUnassignedValue = (Enrollment)((Request)value.variable()).getAssignment();
                this.unassigned(iteration, (Enrollment)((Request)value.variable()).getAssignment());
            }
            this.iOldVariable = (Request)value.variable();
        }
    }

    @Override
    public void afterAssigned(long iteration, Enrollment value) {
        this.iOldVariable = null;
        this.iUnassignedValue = null;
        if (value != null) {
            this.assigned(iteration, value);
        }
    }

    @Override
    public void afterUnassigned(long iteration, Enrollment value) {
        if (value != null && !value.equals(this.iUnassignedValue)) {
            this.unassigned(iteration, value);
        }
    }

    public static class Conflict {
        private int iShare;
        private Student iStudent;
        private Assignment iA1;
        private Assignment iA2;
        private Enrollment iE1;
        private Enrollment iE2;
        private int iHashCode;

        public Conflict(Student student, int share, Enrollment e1, Assignment a1, Enrollment e2, Assignment a2) {
            this.iStudent = student;
            if (a1.compareById(a2) < 0) {
                this.iA1 = a1;
                this.iA2 = a2;
                this.iE1 = e1;
                this.iE2 = e2;
            } else {
                this.iA1 = a2;
                this.iA2 = a1;
                this.iE1 = e2;
                this.iE2 = e1;
            }
            this.iHashCode = (this.iStudent.getId() + ":" + this.iA1.getId() + ":" + this.iA2.getId()).hashCode();
            this.iShare = share;
        }

        public Student getStudent() {
            return this.iStudent;
        }

        public Assignment getS1() {
            return this.iA1;
        }

        public Assignment getS2() {
            return this.iA2;
        }

        public Request getR1() {
            return this.iE1.getRequest();
        }

        public Request getR2() {
            return this.iE2.getRequest();
        }

        public Enrollment getE1() {
            return this.iE1;
        }

        public Enrollment getE2() {
            return this.iE2;
        }

        public int hashCode() {
            return this.iHashCode;
        }

        public int getShare() {
            return this.iShare;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Conflict)) {
                return false;
            }
            Conflict c = (Conflict)o;
            return this.getStudent().equals(c.getStudent()) && this.getS1().equals(c.getS1()) && this.getS2().equals(c.getS2());
        }

        public String toString() {
            return this.getStudent() + ": (s:" + this.getShare() + ") " + this.getS1() + " -- " + this.getS2();
        }
    }
}

