/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.Set;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentConflict
extends Constraint<Request, Enrollment> {
    public StudentConflict(Student student) {
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
    }

    @Override
    public void computeConflicts(Enrollment enrollment, Set<Enrollment> conflicts) {
        for (Request request : this.assignedVariables()) {
            if (request.equals(enrollment.getRequest()) || !enrollment.isOverlapping((Enrollment)request.getAssignment())) continue;
            conflicts.add((Enrollment)request.getAssignment());
        }
        if (!enrollment.getAssignments().isEmpty() && !enrollment.getStudent().canAssign(enrollment.getRequest())) {
            Enrollment lowestPriorityEnrollment = null;
            int lowestPriority = -1;
            for (Request request : this.assignedVariables()) {
                if (request.equals(enrollment.getRequest()) || lowestPriority >= request.getPriority()) continue;
                lowestPriority = request.getPriority();
                lowestPriorityEnrollment = (Enrollment)request.getAssignment();
            }
            if (lowestPriorityEnrollment != null) {
                conflicts.add(lowestPriorityEnrollment);
            }
        }
    }

    @Override
    public boolean isConsistent(Enrollment e1, Enrollment e2) {
        return !e1.isOverlapping(e2);
    }

    @Override
    public boolean inConflict(Enrollment enrollment) {
        for (Request request : this.assignedVariables()) {
            if (request.equals(enrollment.getRequest()) || !enrollment.isOverlapping((Enrollment)request.getAssignment())) continue;
            return true;
        }
        return !enrollment.getStudent().canAssign(enrollment.getRequest());
    }

    public String toString() {
        return "StudentConflicts";
    }
}

