/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import net.sf.cpsolver.ifs.model.GlobalConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseLimit
extends GlobalConstraint<Request, Enrollment> {
    private boolean iPreferDummyStudents = false;

    public CourseLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("CourseLimit.PreferDummyStudents", false);
    }

    public static double getEnrollmentWeight(Course course, Request request) {
        return course.getEnrollmentWeight(request) + request.getWeight();
    }

    @Override
    public void computeConflicts(Enrollment enrollment, Set<Enrollment> conflicts) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return;
        }
        if (course.getLimit() < 0) {
            return;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(course, enrollment.getRequest());
        if (enrlWeight <= (double)course.getLimit()) {
            return;
        }
        ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(course.getEnrollments().size());
        for (Enrollment e : course.getEnrollments()) {
            if (e.getRequest().equals(enrollment.getRequest())) continue;
            if (conflicts.contains(e)) {
                enrlWeight -= e.getRequest().getWeight();
                continue;
            }
            adepts.add(e);
        }
        while (enrlWeight > (double)course.getLimit()) {
            if (adepts.isEmpty()) {
                conflicts.add(enrollment);
                break;
            }
            ArrayList<Enrollment> best = new ArrayList<Enrollment>();
            boolean bestDummy = false;
            double bestValue = 0.0;
            for (Enrollment adept : adepts) {
                boolean dummy = adept.getStudent().isDummy();
                double value = adept.toDouble(false);
                if (this.iPreferDummyStudents && dummy != bestDummy) {
                    if (!dummy) continue;
                    best.clear();
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    continue;
                }
                if (best.isEmpty() || value > bestValue) {
                    if (best.isEmpty()) {
                        best.clear();
                    }
                    best.add(adept);
                    bestDummy = dummy;
                    bestValue = value;
                    continue;
                }
                if (bestValue != value) continue;
                best.add(adept);
            }
            Enrollment conflict = (Enrollment)ToolBox.random(best);
            adepts.remove(conflict);
            enrlWeight -= conflict.getRequest().getWeight();
            conflicts.add(conflict);
        }
    }

    @Override
    public boolean inConflict(Enrollment enrollment) {
        if (((StudentSectioningModel)this.getModel()).getReservationCanAssignOverTheLimit() && enrollment.getReservation() != null && enrollment.getReservation().canAssignOverLimit()) {
            return false;
        }
        Course course = enrollment.getCourse();
        if (course == null) {
            return false;
        }
        if (course.getLimit() < 0) {
            return false;
        }
        double enrlWeight = CourseLimit.getEnrollmentWeight(course, enrollment.getRequest());
        return enrlWeight > (double)course.getLimit();
    }

    public String toString() {
        return "CourseLimit";
    }
}

