/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct.check;

import java.util.HashMap;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.model.Assignment;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;
import org.apache.log4j.Logger;

public class OverlapCheck {
    private static Logger sLog = Logger.getLogger(OverlapCheck.class);
    private StudentSectioningModel iModel;

    public OverlapCheck(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public boolean check() {
        sLog.info((Object)"Checking for overlaps...");
        boolean ret = true;
        for (Student student : this.getModel().getStudents()) {
            HashMap<TimeLocation, Assignment> times = new HashMap<TimeLocation, Assignment>();
            for (Request request : student.getRequests()) {
                Enrollment enrollment = (Enrollment)request.getAssignment();
                if (enrollment == null) continue;
                for (Assignment assignment : enrollment.getAssignments()) {
                    if (assignment.getTime() == null) continue;
                    for (TimeLocation time : times.keySet()) {
                        if (!time.hasIntersection(assignment.getTime())) continue;
                        sLog.error((Object)("Student " + student + " assignment " + assignment + " overlaps with " + times.get(time)));
                        ret = false;
                    }
                    times.put(assignment.getTime(), assignment);
                }
            }
        }
        return ret;
    }
}

