/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.solver.SolverListener;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;
import net.sf.cpsolver.studentsct.StudentPreferencePenalties;
import net.sf.cpsolver.studentsct.StudentSectioningModel;
import net.sf.cpsolver.studentsct.StudentSectioningXMLLoader;
import net.sf.cpsolver.studentsct.StudentSectioningXMLSaver;
import net.sf.cpsolver.studentsct.check.CourseLimitCheck;
import net.sf.cpsolver.studentsct.check.InevitableStudentConflicts;
import net.sf.cpsolver.studentsct.check.OverlapCheck;
import net.sf.cpsolver.studentsct.check.SectionLimitCheck;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.filter.CombinedStudentFilter;
import net.sf.cpsolver.studentsct.filter.FreshmanStudentFilter;
import net.sf.cpsolver.studentsct.filter.RandomStudentFilter;
import net.sf.cpsolver.studentsct.filter.ReverseStudentFilter;
import net.sf.cpsolver.studentsct.filter.StudentFilter;
import net.sf.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.OnlineSelection;
import net.sf.cpsolver.studentsct.heuristics.selection.SwapStudentSelection;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import net.sf.cpsolver.studentsct.heuristics.studentord.StudentRandomOrder;
import net.sf.cpsolver.studentsct.model.AcademicAreaCode;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.report.CourseConflictTable;
import net.sf.cpsolver.studentsct.report.DistanceConflictTable;
import net.sf.cpsolver.studentsct.report.SectionConflictTable;
import net.sf.cpsolver.studentsct.report.TimeOverlapConflictTable;
import net.sf.cpsolver.studentsct.report.UnbalancedSectionsTable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test {
    private static Logger sLog = Logger.getLogger(Test.class);
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("yyMMdd_HHmmss", Locale.US);
    private static DecimalFormat sDF = new DecimalFormat("0.000");

    public static StudentSectioningModel loadModel(DataProperties cfg) {
        StudentSectioningModel model = null;
        try {
            if (cfg.getProperty("Test.CombineStudents") == null) {
                model = new StudentSectioningModel(cfg);
                new StudentSectioningXMLLoader(model).load();
            } else {
                model = Test.combineStudents(cfg, new File(cfg.getProperty("Test.CombineStudentsLastLike", cfg.getProperty("General.Input", "." + File.separator + "solution.xml"))), new File(cfg.getProperty("Test.CombineStudents")));
            }
            if (cfg.getProperty("Test.ExtraStudents") != null) {
                StudentSectioningXMLLoader extra = new StudentSectioningXMLLoader(model);
                extra.setInputFile(new File(cfg.getProperty("Test.ExtraStudents")));
                extra.setLoadOfferings(false);
                extra.setLoadStudents(true);
                extra.setStudentFilter(new ExtraStudentFilter(model));
                extra.load();
            }
            if (cfg.getProperty("Test.LastLikeCourseDemands") != null) {
                Test.loadLastLikeCourseDemandsXml(model, new File(cfg.getProperty("Test.LastLikeCourseDemands")));
            }
            if (cfg.getProperty("Test.StudentInfos") != null) {
                Test.loadStudentInfoXml(model, new File(cfg.getProperty("Test.StudentInfos")));
            }
            if (cfg.getProperty("Test.CrsReq") != null) {
                Test.loadCrsReqFiles(model, cfg.getProperty("Test.CrsReq"));
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to load model, reason: " + e.getMessage()), (Throwable)e);
            return null;
        }
        if (cfg.getPropertyBoolean("Debug.DistanceConflict", false)) {
            DistanceConflict.sDebug = true;
        }
        if (cfg.getPropertyBoolean("Debug.BranchBoundSelection", false)) {
            BranchBoundSelection.sDebug = true;
        }
        if (cfg.getPropertyBoolean("Debug.SwapStudentsSelection", false)) {
            SwapStudentSelection.sDebug = true;
        }
        if (cfg.getPropertyBoolean("Debug.TimeOverlaps", false)) {
            TimeOverlapsCounter.sDebug = true;
        }
        if (cfg.getProperty("CourseRequest.SameTimePrecise") != null) {
            CourseRequest.sSameTimePrecise = cfg.getPropertyBoolean("CourseRequest.SameTimePrecise", false);
        }
        Logger.getLogger(BacktrackNeighbourSelection.class).setLevel(cfg.getPropertyBoolean("Debug.BacktrackNeighbourSelection", false) ? Level.DEBUG : Level.INFO);
        if (cfg.getPropertyBoolean("Test.FixPriorities", false)) {
            Test.fixPriorities(model);
        }
        return model;
    }

    public static Solution<Request, Enrollment> batchSectioning(DataProperties cfg) {
        StudentSectioningModel model = Test.loadModel(cfg);
        if (model == null) {
            return null;
        }
        if (cfg.getPropertyBoolean("Test.ComputeSectioningInfo", true)) {
            model.clearOnlineSectioningInfos();
        }
        Solution<Request, Enrollment> solution = Test.solveModel(model, cfg);
        Test.printInfo(solution, cfg.getPropertyBoolean("Test.CreateReports", true), cfg.getPropertyBoolean("Test.ComputeSectioningInfo", true), cfg.getPropertyBoolean("Test.RunChecks", true));
        try {
            Solver<Request, Enrollment> solver = new Solver<Request, Enrollment>(cfg);
            solver.setInitalSolution(solution);
            new StudentSectioningXMLSaver(solver).save(new File(new File(cfg.getProperty("General.Output", ".")), "solution.xml"));
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save solution, reason: " + e.getMessage()), (Throwable)e);
        }
        Test.saveInfoToXML(solution, null, new File(new File(cfg.getProperty("General.Output", ".")), "info.xml"));
        return solution;
    }

    public static Solution<Request, Enrollment> onlineSectioning(DataProperties cfg) throws Exception {
        StudentSectioningModel model = Test.loadModel(cfg);
        if (model == null) {
            return null;
        }
        Solution<Request, Enrollment> solution = new Solution<Request, Enrollment>(model, 0L, 0.0);
        solution.addSolutionListener(new TestSolutionListener());
        double startTime = JProf.currentTimeSec();
        Solver<Request, Enrollment> solver = new Solver<Request, Enrollment>(cfg);
        solver.setInitalSolution(solution);
        solver.initSolver();
        OnlineSelection onlineSelection = new OnlineSelection(cfg);
        onlineSelection.init(solver);
        double totalPenalty = 0.0;
        double minPenalty = 0.0;
        double maxPenalty = 0.0;
        double minAvEnrlPenalty = 0.0;
        double maxAvEnrlPenalty = 0.0;
        double totalPrefPenalty = 0.0;
        double minPrefPenalty = 0.0;
        double maxPrefPenalty = 0.0;
        double minAvEnrlPrefPenalty = 0.0;
        double maxAvEnrlPrefPenalty = 0.0;
        int nrChoices = 0;
        int nrEnrollments = 0;
        int nrCourseRequests = 0;
        int chChoices = 0;
        int chCourseRequests = 0;
        int chStudents = 0;
        int choiceLimit = model.getProperties().getPropertyInt("Test.ChoicesLimit", -1);
        File outDir = new File(model.getProperties().getProperty("General.Output", "."));
        outDir.mkdirs();
        PrintWriter pw = new PrintWriter(new FileWriter(new File(outDir, "choices.csv")));
        List<Student> students = model.getStudents();
        try {
            Class<?> studentOrdClass = Class.forName(model.getProperties().getProperty("Test.StudentOrder", StudentRandomOrder.class.getName()));
            StudentOrder studentOrd = (StudentOrder)studentOrdClass.getConstructor(DataProperties.class).newInstance(model.getProperties());
            students = studentOrd.order(model.getStudents());
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to reorder students, reason: " + e.getMessage()), (Throwable)e);
        }
        for (Student student : students) {
            if (student.nrAssignedRequests() > 0) continue;
            sLog.info((Object)("Sectioning student: " + student));
            BranchBoundSelection.Selection selection = onlineSelection.getSelection(student);
            BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select();
            if (neighbour != null) {
                StudentPreferencePenalties penalties = null;
                if (selection instanceof OnlineSelection.EpsilonSelection) {
                    OnlineSelection.EpsilonSelection epsSelection = (OnlineSelection.EpsilonSelection)selection;
                    penalties = epsSelection.getPenalties();
                    for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                        Request r = student.getRequests().get(i);
                        if (!(r instanceof CourseRequest)) continue;
                        ++nrCourseRequests;
                        ++chCourseRequests;
                        int chChoicesThisRq = 0;
                        CourseRequest request = (CourseRequest)r;
                        for (Enrollment x : request.getAvaiableEnrollments()) {
                            ++nrEnrollments;
                            if (!epsSelection.isAllowed(i, x)) continue;
                            ++nrChoices;
                            if (choiceLimit > 0 && chChoicesThisRq >= choiceLimit) continue;
                            ++chChoices;
                            ++chChoicesThisRq;
                        }
                    }
                    if (++chStudents == 100) {
                        pw.println(sDF.format((double)chChoices / (double)chCourseRequests));
                        pw.flush();
                        chStudents = 0;
                        chChoices = 0;
                        chCourseRequests = 0;
                    }
                }
                for (int i = 0; i < neighbour.getAssignment().length; ++i) {
                    Enrollment enrollment;
                    if (neighbour.getAssignment()[i] == null || !((enrollment = neighbour.getAssignment()[i]).getRequest() instanceof CourseRequest)) continue;
                    CourseRequest request = (CourseRequest)enrollment.getRequest();
                    double[] avEnrlMinMax = Test.getMinMaxAvailableEnrollmentPenalty(request);
                    minAvEnrlPenalty += avEnrlMinMax[0];
                    maxAvEnrlPenalty += avEnrlMinMax[1];
                    totalPenalty += enrollment.getPenalty();
                    minPenalty += request.getMinPenalty();
                    maxPenalty += request.getMaxPenalty();
                    if (penalties == null) continue;
                    double[] avEnrlPrefMinMax = penalties.getMinMaxAvailableEnrollmentPenalty(enrollment.getRequest());
                    minAvEnrlPrefPenalty += avEnrlPrefMinMax[0];
                    maxAvEnrlPrefPenalty += avEnrlPrefMinMax[1];
                    totalPrefPenalty += penalties.getPenalty(enrollment);
                    minPrefPenalty += penalties.getMinPenalty(enrollment.getRequest());
                    maxPrefPenalty += penalties.getMaxPenalty(enrollment.getRequest());
                }
                neighbour.assign(solution.getIteration());
                sLog.info((Object)("Student " + student + " enrolls into " + neighbour));
                onlineSelection.updateSpace(student);
            } else {
                sLog.warn((Object)"No solution found.");
            }
            solution.update(JProf.currentTimeSec() - startTime);
        }
        if (chCourseRequests > 0) {
            pw.println(sDF.format((double)chChoices / (double)chCourseRequests));
        }
        pw.flush();
        pw.close();
        solution.saveBest();
        Test.printInfo(solution, cfg.getPropertyBoolean("Test.CreateReports", true), false, cfg.getPropertyBoolean("Test.RunChecks", true));
        HashMap<String, String> extra = new HashMap<String, String>();
        sLog.info((Object)("Overall penalty is " + Test.getPerc(totalPenalty, minPenalty, maxPenalty) + "% (" + sDF.format(totalPenalty) + "/" + sDF.format(minPenalty) + ".." + sDF.format(maxPenalty) + ")"));
        extra.put("Overall penalty", Test.getPerc(totalPenalty, minPenalty, maxPenalty) + "% (" + sDF.format(totalPenalty) + "/" + sDF.format(minPenalty) + ".." + sDF.format(maxPenalty) + ")");
        extra.put("Overall available enrollment penalty", Test.getPerc(totalPenalty, minAvEnrlPenalty, maxAvEnrlPenalty) + "% (" + sDF.format(totalPenalty) + "/" + sDF.format(minAvEnrlPenalty) + ".." + sDF.format(maxAvEnrlPenalty) + ")");
        if (onlineSelection.isUseStudentPrefPenalties()) {
            sLog.info((Object)("Overall preference penalty is " + Test.getPerc(totalPrefPenalty, minPrefPenalty, maxPrefPenalty) + "% (" + sDF.format(totalPrefPenalty) + "/" + sDF.format(minPrefPenalty) + ".." + sDF.format(maxPrefPenalty) + ")"));
            extra.put("Overall preference penalty", Test.getPerc(totalPrefPenalty, minPrefPenalty, maxPrefPenalty) + "% (" + sDF.format(totalPrefPenalty) + "/" + sDF.format(minPrefPenalty) + ".." + sDF.format(maxPrefPenalty) + ")");
            extra.put("Overall preference available enrollment penalty", Test.getPerc(totalPrefPenalty, minAvEnrlPrefPenalty, maxAvEnrlPrefPenalty) + "% (" + sDF.format(totalPrefPenalty) + "/" + sDF.format(minAvEnrlPrefPenalty) + ".." + sDF.format(maxAvEnrlPrefPenalty) + ")");
            extra.put("Average number of choices", sDF.format((double)nrChoices / (double)nrCourseRequests) + " (" + nrChoices + "/" + nrCourseRequests + ")");
            extra.put("Average number of enrollments", sDF.format((double)nrEnrollments / (double)nrCourseRequests) + " (" + nrEnrollments + "/" + nrCourseRequests + ")");
        }
        try {
            new StudentSectioningXMLSaver(solver).save(new File(new File(cfg.getProperty("General.Output", ".")), "solution.xml"));
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save solution, reason: " + e.getMessage()), (Throwable)e);
        }
        Test.saveInfoToXML(solution, extra, new File(new File(cfg.getProperty("General.Output", ".")), "info.xml"));
        return solution;
    }

    public static double[] getMinMaxEnrollmentPenalty(CourseRequest request) {
        List<Enrollment> enrollments = request.values();
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = enrollment.getPenalty();
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public static double[] getMinMaxAvailableEnrollmentPenalty(CourseRequest request) {
        List<Enrollment> enrollments = request.getAvaiableEnrollments();
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = enrollment.getPenalty();
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public static String getPerc(double value, double min, double max) {
        if (max == min) {
            return sDF.format(100.0);
        }
        return sDF.format(100.0 - 100.0 * (value - min) / (max - min));
    }

    public static void printInfo(Solution<Request, Enrollment> solution, boolean computeTables, boolean computeSectInfos, boolean runChecks) {
        StudentSectioningModel model = (StudentSectioningModel)solution.getModel();
        if (computeTables) {
            if (solution.getModel().assignedVariables().size() > 0) {
                try {
                    File outDir = new File(model.getProperties().getProperty("General.Output", "."));
                    outDir.mkdirs();
                    CourseConflictTable cct = new CourseConflictTable((StudentSectioningModel)solution.getModel());
                    cct.createTable(true, false).save(new File(outDir, "conflicts-lastlike.csv"));
                    cct.createTable(false, true).save(new File(outDir, "conflicts-real.csv"));
                    DistanceConflictTable dct = new DistanceConflictTable((StudentSectioningModel)solution.getModel());
                    dct.createTable(true, false).save(new File(outDir, "distances-lastlike.csv"));
                    dct.createTable(false, true).save(new File(outDir, "distances-real.csv"));
                    SectionConflictTable sct = new SectionConflictTable((StudentSectioningModel)solution.getModel(), SectionConflictTable.Type.OVERLAPS);
                    sct.createTable(true, false).save(new File(outDir, "time-conflicts-lastlike.csv"));
                    sct.createTable(false, true).save(new File(outDir, "time-conflicts-real.csv"));
                    SectionConflictTable ust = new SectionConflictTable((StudentSectioningModel)solution.getModel(), SectionConflictTable.Type.UNAVAILABILITIES);
                    ust.createTable(true, false).save(new File(outDir, "availability-conflicts-lastlike.csv"));
                    ust.createTable(false, true).save(new File(outDir, "availability-conflicts-real.csv"));
                    SectionConflictTable ct = new SectionConflictTable((StudentSectioningModel)solution.getModel(), SectionConflictTable.Type.OVERLAPS_AND_UNAVAILABILITIES);
                    ct.createTable(true, false).save(new File(outDir, "section-conflicts-lastlike.csv"));
                    ct.createTable(false, true).save(new File(outDir, "section-conflicts-real.csv"));
                    UnbalancedSectionsTable ubt = new UnbalancedSectionsTable((StudentSectioningModel)solution.getModel());
                    ubt.createTable(true, false).save(new File(outDir, "unbalanced-lastlike.csv"));
                    ubt.createTable(false, true).save(new File(outDir, "unbalanced-real.csv"));
                    TimeOverlapConflictTable toc = new TimeOverlapConflictTable((StudentSectioningModel)solution.getModel());
                    toc.createTable(true, false).save(new File(outDir, "time-overlaps-lastlike.csv"));
                    toc.createTable(false, true).save(new File(outDir, "time-overlaps-real.csv"));
                }
                catch (IOException e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            solution.saveBest();
        }
        if (computeSectInfos) {
            model.computeOnlineSectioningInfos();
        }
        if (runChecks) {
            Object ch;
            try {
                if (model.getProperties().getPropertyBoolean("Test.InevitableStudentConflictsCheck", false) && !((InevitableStudentConflicts)(ch = new InevitableStudentConflicts(model))).check()) {
                    ((InevitableStudentConflicts)ch).getCSVFile().save(new File(new File(model.getProperties().getProperty("General.Output", ".")), "inevitable-conflicts.csv"));
                }
            }
            catch (IOException e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
            new OverlapCheck(model).check();
            new SectionLimitCheck(model).check();
            try {
                ch = new CourseLimitCheck(model);
                if (!((CourseLimitCheck)ch).check()) {
                    ((CourseLimitCheck)ch).getCSVFile().save(new File(new File(model.getProperties().getProperty("General.Output", ".")), "course-limits.csv"));
                }
            }
            catch (IOException e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        sLog.info((Object)("Best solution found after " + solution.getBestTime() + " seconds (" + solution.getBestIteration() + " iterations)."));
        sLog.info((Object)("Info: " + ToolBox.dict2string(solution.getExtendedInfo(), 2)));
    }

    public static Solution<Request, Enrollment> solveModel(StudentSectioningModel model, DataProperties cfg) {
        Solver<Request, Enrollment> solver = new Solver<Request, Enrollment>(cfg);
        Solution<Request, Enrollment> solution = new Solution<Request, Enrollment>(model, 0L, 0.0);
        solver.setInitalSolution(solution);
        if (cfg.getPropertyBoolean("Test.Verbose", false)) {
            solver.addSolverListener(new SolverListener<Request, Enrollment>(){

                @Override
                public boolean variableSelected(long iteration, Request variable) {
                    return true;
                }

                @Override
                public boolean valueSelected(long iteration, Request variable, Enrollment value) {
                    return true;
                }

                @Override
                public boolean neighbourSelected(long iteration, Neighbour<Request, Enrollment> neighbour) {
                    sLog.debug((Object)("Select[" + iteration + "]: " + neighbour));
                    return true;
                }
            });
        }
        solution.addSolutionListener(new TestSolutionListener());
        solver.start();
        try {
            solver.getSolverThread().join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        solution = solver.lastSolution();
        solution.restoreBest();
        Test.printInfo(solution, false, false, false);
        return solution;
    }

    public static double getLastLikeStudentWeight(Course course, int real, int lastLike) {
        int projected = course.getProjected();
        int limit = course.getLimit();
        if (course.getLimit() < 0) {
            sLog.debug((Object)("  -- Course " + course.getName() + " is unlimited."));
            return 1.0;
        }
        if (projected <= 0) {
            sLog.warn((Object)("  -- No projected demand for course " + course.getName() + ", using course limit (" + limit + ")"));
            projected = limit;
        } else if (limit < projected) {
            sLog.warn((Object)("  -- Projected number of students is over course limit for course " + course.getName() + " (" + Math.round(projected) + ">" + limit + ")"));
            projected = limit;
        }
        if (lastLike == 0) {
            sLog.warn((Object)("  -- No last like info for course " + course.getName()));
            return 1.0;
        }
        double weight = (double)Math.max(0, projected - real) / (double)lastLike;
        sLog.debug((Object)("  -- last like student weight for " + course.getName() + " is " + weight + " (lastLike=" + lastLike + ", real=" + real + ", projected=" + projected + ")"));
        return weight;
    }

    public static void loadLastLikeCourseDemandsXml(StudentSectioningModel model, File xml) {
        try {
            Document document = new SAXReader().read(xml);
            Element root = document.getRootElement();
            HashMap<Course, ArrayList<CourseRequest>> requests = new HashMap<Course, ArrayList<CourseRequest>>();
            long reqId = 0L;
            Iterator i = root.elementIterator("student");
            while (i.hasNext()) {
                Element studentEl = (Element)i.next();
                Student student = new Student(Long.parseLong(studentEl.attributeValue("externalId")));
                student.setDummy(true);
                int priority = 0;
                HashSet<Course> reqCourses = new HashSet<Course>();
                Iterator j = studentEl.elementIterator("studentCourse");
                while (j.hasNext()) {
                    Element courseEl = (Element)j.next();
                    String subjectArea = courseEl.attributeValue("subject");
                    String courseNbr = courseEl.attributeValue("courseNumber");
                    Course course = null;
                    block4: for (Offering offering : model.getOfferings()) {
                        for (Course c : offering.getCourses()) {
                            if (!c.getSubjectArea().equals(subjectArea) || !c.getCourseNumber().equals(courseNbr)) continue;
                            course = c;
                            break block4;
                        }
                    }
                    if (course == null && courseNbr.charAt(courseNbr.length() - 1) >= 'A' && courseNbr.charAt(courseNbr.length() - 1) <= 'Z') {
                        String courseNbrNoSfx = courseNbr.substring(0, courseNbr.length() - 1);
                        block6: for (Offering offering2 : model.getOfferings()) {
                            for (Course c : offering2.getCourses()) {
                                if (!c.getSubjectArea().equals(subjectArea) || !c.getCourseNumber().equals(courseNbrNoSfx)) continue;
                                course = c;
                                break block6;
                            }
                        }
                    }
                    if (course == null) {
                        sLog.warn((Object)("Course " + subjectArea + " " + courseNbr + " not found."));
                        continue;
                    }
                    if (!reqCourses.add(course)) {
                        sLog.warn((Object)("Course " + subjectArea + " " + courseNbr + " already requested."));
                        continue;
                    }
                    ArrayList<Course> courses = new ArrayList<Course>(1);
                    courses.add(course);
                    CourseRequest courseRequest = new CourseRequest(reqId++, priority++, false, student, courses, false, null);
                    ArrayList<CourseRequest> requestsThisCourse = (ArrayList<CourseRequest>)requests.get(course);
                    if (requestsThisCourse == null) {
                        requestsThisCourse = new ArrayList<CourseRequest>();
                        requests.put(course, requestsThisCourse);
                    }
                    requestsThisCourse.add(courseRequest);
                }
                if (student.getRequests().isEmpty()) continue;
                model.addStudent(student);
            }
            for (Map.Entry entry : requests.entrySet()) {
                Course course = (Course)entry.getKey();
                List requestsThisCourse = (List)entry.getValue();
                double weight = Test.getLastLikeStudentWeight(course, 0, requestsThisCourse.size());
                for (Request request : requestsThisCourse) {
                    request.setWeight(weight);
                }
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void loadCrsReqFiles(StudentSectioningModel model, String files) {
        try {
            boolean lastLike = model.getProperties().getPropertyBoolean("Test.CrsReqIsLastLike", true);
            boolean shuffleIds = model.getProperties().getPropertyBoolean("Test.CrsReqShuffleStudentIds", true);
            boolean tryWithoutSuffix = model.getProperties().getPropertyBoolean("Test.CrsReqTryWithoutSuffix", false);
            HashMap<Long, Student> students = new HashMap<Long, Student>();
            long reqId = 0L;
            StringTokenizer stk = new StringTokenizer(files, ";");
            while (stk.hasMoreTokens()) {
                String line;
                String file = stk.nextToken();
                sLog.debug((Object)("Loading " + file + " ..."));
                Iterator in = new BufferedReader(new FileReader(file));
                int lineIndex = 0;
                while ((line = ((BufferedReader)((Object)in)).readLine()) != null) {
                    char code;
                    ++lineIndex;
                    if (line.length() <= 150 || (code = line.charAt(13)) == 'H' || code == 'T') continue;
                    long studentId = Long.parseLong(line.substring(14, 23));
                    Student student = (Student)students.get(new Long(studentId));
                    if (student == null) {
                        student = new Student(studentId);
                        if (lastLike) {
                            student.setDummy(true);
                        }
                        students.put(new Long(studentId), student);
                        sLog.debug((Object)("  -- loading student " + studentId + " ..."));
                    } else {
                        sLog.debug((Object)("  -- updating student " + studentId + " ..."));
                    }
                    line = line.substring(150);
                    while (line.length() >= 20) {
                        String subjectArea = line.substring(0, 4).trim();
                        String courseNbr = line.substring(4, 8).trim();
                        if (subjectArea.length() == 0 || courseNbr.length() == 0) {
                            line = line.substring(20);
                            continue;
                        }
                        char action = line.charAt(19);
                        sLog.debug((Object)("    -- requesting " + subjectArea + " " + courseNbr + " (action:" + action + ") ..."));
                        Course course = null;
                        block5: for (Offering offering : model.getOfferings()) {
                            for (Course c : offering.getCourses()) {
                                if (!c.getSubjectArea().equals(subjectArea) || !c.getCourseNumber().equals(courseNbr)) continue;
                                course = c;
                                break block5;
                            }
                        }
                        if (course == null && tryWithoutSuffix && courseNbr.charAt(courseNbr.length() - 1) >= 'A' && courseNbr.charAt(courseNbr.length() - 1) <= 'Z') {
                            String courseNbrNoSfx = courseNbr.substring(0, courseNbr.length() - 1);
                            block7: for (Offering offering3 : model.getOfferings()) {
                                for (Course c : offering3.getCourses()) {
                                    if (!c.getSubjectArea().equals(subjectArea) || !c.getCourseNumber().equals(courseNbrNoSfx)) continue;
                                    course = c;
                                    break block7;
                                }
                            }
                        }
                        if (course == null) {
                            if (courseNbr.charAt(courseNbr.length() - 1) < 'A' || courseNbr.charAt(courseNbr.length() - 1) > 'Z') {
                                sLog.warn((Object)("      -- course " + subjectArea + " " + courseNbr + " not found (file " + file + ", line " + lineIndex + ")"));
                            }
                        } else {
                            CourseRequest courseRequest = null;
                            for (Request request : student.getRequests()) {
                                if (!(request instanceof CourseRequest) || !((CourseRequest)request).getCourses().contains(course)) continue;
                                courseRequest = (CourseRequest)request;
                                break;
                            }
                            if (action == 'A') {
                                if (courseRequest == null) {
                                    ArrayList<Course> arrayList = new ArrayList<Course>(1);
                                    arrayList.add(course);
                                    courseRequest = new CourseRequest(reqId++, student.getRequests().size(), false, student, arrayList, false, null);
                                } else {
                                    sLog.warn((Object)("      -- request for course " + course + " is already present"));
                                }
                            } else if (action == 'D') {
                                if (courseRequest == null) {
                                    sLog.warn((Object)("      -- request for course " + course + " is not present -- cannot be dropped"));
                                } else {
                                    student.getRequests().remove(courseRequest);
                                }
                            } else if (action == 'C') {
                                if (courseRequest == null) {
                                    sLog.warn((Object)("      -- request for course " + course + " is not present -- cannot be changed"));
                                }
                            } else {
                                sLog.warn((Object)("      -- unknown action " + action));
                            }
                        }
                        line = line.substring(20);
                    }
                }
                ((BufferedReader)((Object)in)).close();
            }
            HashMap<Course, ArrayList<Request>> requests = new HashMap<Course, ArrayList<Request>>();
            HashSet<Long> studentIds = new HashSet<Long>();
            for (Student student : students.values()) {
                if (!student.getRequests().isEmpty()) {
                    model.addStudent(student);
                }
                if (shuffleIds) {
                    long newId = -1L;
                    while (!studentIds.add(new Long(newId = 1L + (long)(9.99999999E8 * Math.random())))) {
                    }
                    student.setId(newId);
                }
                if (!student.isDummy()) continue;
                for (Request request : student.getRequests()) {
                    if (!(request instanceof CourseRequest)) continue;
                    Course course = ((CourseRequest)request).getCourses().get(0);
                    ArrayList<Request> requestsThisCourse = (ArrayList<Request>)requests.get(course);
                    if (requestsThisCourse == null) {
                        requestsThisCourse = new ArrayList<Request>();
                        requests.put(course, requestsThisCourse);
                    }
                    requestsThisCourse.add(request);
                }
            }
            Collections.sort(model.getStudents(), new Comparator<Student>(){

                @Override
                public int compare(Student o1, Student o2) {
                    return Double.compare(o1.getId(), o2.getId());
                }
            });
            for (Map.Entry entry : requests.entrySet()) {
                Course course = (Course)entry.getKey();
                List requestsThisCourse = (List)entry.getValue();
                double weight = Test.getLastLikeStudentWeight(course, 0, requestsThisCourse.size());
                for (Request request : requestsThisCourse) {
                    request.setWeight(weight);
                }
            }
            if (model.getProperties().getProperty("Test.EtrChk") != null) {
                StringTokenizer stk2 = new StringTokenizer(model.getProperties().getProperty("Test.EtrChk"), ";");
                while (stk2.hasMoreTokens()) {
                    String line;
                    String file = stk2.nextToken();
                    sLog.debug((Object)("Loading " + file + " ..."));
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    while ((line = in.readLine()) != null) {
                        char code;
                        if (line.length() < 55 || (code = line.charAt(12)) == 'H' || code == 'T' || code == 'D' || code == 'K') continue;
                        long studentId = Long.parseLong(line.substring(2, 11));
                        Student student = (Student)students.get(new Long(studentId));
                        if (student == null) {
                            sLog.info((Object)("  -- student " + studentId + " not found"));
                            continue;
                        }
                        sLog.info((Object)("  -- reading student " + studentId));
                        String area = line.substring(15, 18).trim();
                        if (area.length() == 0) continue;
                        String clasf = line.substring(18, 20).trim();
                        String major = line.substring(21, 24).trim();
                        String minor = line.substring(24, 27).trim();
                        student.getAcademicAreaClasiffications().clear();
                        student.getMajors().clear();
                        student.getMinors().clear();
                        student.getAcademicAreaClasiffications().add(new AcademicAreaCode(area, clasf));
                        if (major.length() > 0) {
                            student.getMajors().add(new AcademicAreaCode(area, major));
                        }
                        if (minor.length() <= 0) continue;
                        student.getMinors().add(new AcademicAreaCode(area, minor));
                    }
                }
            }
            int without = 0;
            for (Student student : students.values()) {
                if (!student.getAcademicAreaClasiffications().isEmpty()) continue;
                ++without;
            }
            Test.fixPriorities(model);
            sLog.info((Object)("Students without academic area: " + without));
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void fixPriorities(StudentSectioningModel model) {
        for (Student student : model.getStudents()) {
            Collections.sort(student.getRequests(), new Comparator<Request>(){

                @Override
                public int compare(Request r1, Request r2) {
                    int cmp = Double.compare(r1.getPriority(), r2.getPriority());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return Double.compare(r1.getId(), r2.getId());
                }
            });
            int priority = 0;
            for (Request request : student.getRequests()) {
                if (priority == request.getPriority()) continue;
                sLog.debug((Object)("Change priority of " + request + " to " + priority));
                request.setPriority(priority);
            }
        }
    }

    public static void loadStudentInfoXml(StudentSectioningModel model, File xml) {
        try {
            sLog.info((Object)("Loading student infos from " + xml));
            Document document = new SAXReader().read(xml);
            Element root = document.getRootElement();
            HashMap<Long, Student> studentTable = new HashMap<Long, Student>();
            for (Student student : model.getStudents()) {
                studentTable.put(new Long(student.getId()), student);
            }
            Iterator i = root.elementIterator("student");
            while (i.hasNext()) {
                Iterator j;
                Element studentEl = (Element)i.next();
                Student student = (Student)studentTable.get(Long.valueOf(studentEl.attributeValue("externalId")));
                if (student == null) {
                    sLog.debug((Object)(" -- student " + studentEl.attributeValue("externalId") + " not found"));
                    continue;
                }
                sLog.debug((Object)(" -- loading info for student " + student));
                student.getAcademicAreaClasiffications().clear();
                if (studentEl.element("studentAcadAreaClass") != null) {
                    j = studentEl.element("studentAcadAreaClass").elementIterator("acadAreaClass");
                    while (j.hasNext()) {
                        Element studentAcadAreaClassElement = (Element)j.next();
                        student.getAcademicAreaClasiffications().add(new AcademicAreaCode(studentAcadAreaClassElement.attributeValue("academicArea"), studentAcadAreaClassElement.attributeValue("academicClass")));
                    }
                }
                sLog.debug((Object)("   -- acad areas classifs " + student.getAcademicAreaClasiffications()));
                student.getMajors().clear();
                if (studentEl.element("studentMajors") != null) {
                    j = studentEl.element("studentMajors").elementIterator("major");
                    while (j.hasNext()) {
                        Element studentMajorElement = (Element)j.next();
                        student.getMajors().add(new AcademicAreaCode(studentMajorElement.attributeValue("academicArea"), studentMajorElement.attributeValue("code")));
                    }
                }
                sLog.debug((Object)("   -- majors " + student.getMajors()));
                student.getMinors().clear();
                if (studentEl.element("studentMinors") != null) {
                    j = studentEl.element("studentMinors").elementIterator("minor");
                    while (j.hasNext()) {
                        Element studentMinorElement = (Element)j.next();
                        student.getMinors().add(new AcademicAreaCode(studentMinorElement.attributeValue("academicArea", ""), studentMinorElement.attributeValue("code", "")));
                    }
                }
                sLog.debug((Object)("   -- minors " + student.getMinors()));
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveInfoToXML(Solution<Request, Enrollment> solution, HashMap<String, String> extra, File file) {
        FileOutputStream fos = null;
        try {
            Document document = DocumentHelper.createDocument();
            document.addComment("Solution Info");
            Element root = document.addElement("info");
            TreeSet<Map.Entry<String, String>> entrySet = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            });
            entrySet.addAll(solution.getExtendedInfo().entrySet());
            if (extra != null) {
                entrySet.addAll(extra.entrySet());
            }
            for (Map.Entry<String, String> entry : entrySet) {
                root.addElement("property").addAttribute("name", entry.getKey()).setText(entry.getValue());
            }
            fos = new FileOutputStream(file);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to save info, reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void fixWeights(StudentSectioningModel model) {
        Course course;
        CourseRequest courseRequest;
        HashMap<Course, Integer> lastLike = new HashMap<Course, Integer>();
        HashMap real = new HashMap();
        HashSet<Long> lastLikeIds = new HashSet<Long>();
        HashSet<Long> realIds = new HashSet<Long>();
        for (Student student : model.getStudents()) {
            if (student.isDummy()) {
                if (!lastLikeIds.add(new Long(student.getId()))) {
                    sLog.error((Object)("Two last-like student with id " + student.getId()));
                }
            } else if (!realIds.add(new Long(student.getId()))) {
                sLog.error((Object)("Two real student with id " + student.getId()));
            }
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                courseRequest = (CourseRequest)request;
                course = courseRequest.getCourses().get(0);
                Integer cnt = (Integer)(student.isDummy() ? lastLike : real).get(course);
                (student.isDummy() ? lastLike : real).put(course, new Integer((cnt == null ? 0 : cnt) + 1));
            }
        }
        for (Student student : new ArrayList<Student>(model.getStudents())) {
            if (student.isDummy() && realIds.contains(new Long(student.getId()))) {
                sLog.warn((Object)("There is both last-like and real student with id " + student.getId()));
                long newId = -1L;
                while (realIds.contains(new Long(newId = 1L + (long)(9.99999999E8 * Math.random()))) || lastLikeIds.contains(new Long(newId))) {
                }
                lastLikeIds.remove(new Long(student.getId()));
                lastLikeIds.add(new Long(newId));
                student.setId(newId);
                sLog.warn((Object)("  -- last-like student id changed to " + student.getId()));
            }
            for (Request request : new ArrayList<Request>(student.getRequests())) {
                if (!student.isDummy()) {
                    request.setWeight(1.0);
                    continue;
                }
                if (request instanceof CourseRequest) {
                    courseRequest = (CourseRequest)request;
                    course = courseRequest.getCourses().get(0);
                    Integer lastLikeCnt = (Integer)lastLike.get(course);
                    Integer realCnt = (Integer)real.get(course);
                    courseRequest.setWeight(Test.getLastLikeStudentWeight(course, realCnt == null ? 0 : realCnt, lastLikeCnt == null ? 0 : lastLikeCnt));
                } else {
                    request.setWeight(1.0);
                }
                if (!(request.getWeight() <= 0.0)) continue;
                model.removeVariable(request);
                student.getRequests().remove(request);
            }
            if (!student.getRequests().isEmpty()) continue;
            model.getStudents().remove(student);
        }
    }

    public static StudentSectioningModel combineStudents(DataProperties cfg, File lastLikeStudentData, File realStudentData) {
        try {
            RandomStudentFilter rnd = new RandomStudentFilter(1.0);
            StudentSectioningModel model = null;
            StringTokenizer stk = new StringTokenizer(cfg.getProperty("Test.CombineAcceptProb", "1.0"), ",");
            while (stk.hasMoreTokens()) {
                double acceptProb = Double.parseDouble(stk.nextToken());
                sLog.info((Object)("Test.CombineAcceptProb=" + acceptProb));
                rnd.setProbability(acceptProb);
                CombinedStudentFilter batchFilter = new CombinedStudentFilter(new ReverseStudentFilter(new FreshmanStudentFilter()), rnd, 0);
                model = new StudentSectioningModel(cfg);
                StudentSectioningXMLLoader loader = new StudentSectioningXMLLoader(model);
                loader.setLoadStudents(false);
                loader.load();
                StudentSectioningXMLLoader lastLikeLoader = new StudentSectioningXMLLoader(model);
                lastLikeLoader.setInputFile(lastLikeStudentData);
                lastLikeLoader.setLoadOfferings(false);
                lastLikeLoader.setLoadStudents(true);
                lastLikeLoader.load();
                StudentSectioningXMLLoader realLoader = new StudentSectioningXMLLoader(model);
                realLoader.setInputFile(realStudentData);
                realLoader.setLoadOfferings(false);
                realLoader.setLoadStudents(true);
                realLoader.setStudentFilter(batchFilter);
                realLoader.load();
                Test.fixWeights(model);
                Test.fixPriorities(model);
                Solver<Request, Enrollment> solver = new Solver<Request, Enrollment>(model.getProperties());
                solver.setInitalSolution(model);
                new StudentSectioningXMLSaver(solver).save(new File(new File(model.getProperties().getProperty("General.Output", ".")), "solution-r" + (int)(100.0 * acceptProb) + ".xml"));
            }
            return model;
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to combine students, reason: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            DataProperties cfg = new DataProperties();
            cfg.setProperty("Termination.Class", "net.sf.cpsolver.ifs.termination.GeneralTerminationCondition");
            cfg.setProperty("Termination.StopWhenComplete", "true");
            cfg.setProperty("Termination.TimeOut", "600");
            cfg.setProperty("Comparator.Class", "net.sf.cpsolver.ifs.solution.GeneralSolutionComparator");
            cfg.setProperty("Value.Class", "net.sf.cpsolver.studentsct.heuristics.EnrollmentSelection");
            cfg.setProperty("Value.WeightConflicts", "1.0");
            cfg.setProperty("Value.WeightNrAssignments", "0.0");
            cfg.setProperty("Variable.Class", "net.sf.cpsolver.ifs.heuristics.GeneralVariableSelection");
            cfg.setProperty("Neighbour.Class", "net.sf.cpsolver.studentsct.heuristics.StudentSctNeighbourSelection");
            cfg.setProperty("General.SaveBestUnassigned", "0");
            cfg.setProperty("Extensions.Classes", "net.sf.cpsolver.ifs.extension.ConflictStatistics;net.sf.cpsolver.studentsct.extension.DistanceConflict;net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter");
            cfg.setProperty("Data.Initiative", "puWestLafayetteTrdtn");
            cfg.setProperty("Data.Term", "Fal");
            cfg.setProperty("Data.Year", "2007");
            cfg.setProperty("General.Input", "pu-sectll-fal07-s.xml");
            if (args.length >= 1) {
                cfg.load(new FileInputStream(args[0]));
            }
            cfg.putAll((Map<?, ?>)System.getProperties());
            if (args.length >= 2) {
                cfg.setProperty("General.Input", args[1]);
            }
            if (args.length >= 3) {
                File logFile = new File(ToolBox.configureLogging(args[2] + File.separator + sDateFormat.format(new Date()), cfg, false, false));
                cfg.setProperty("General.Output", logFile.getParentFile().getAbsolutePath());
            } else if (cfg.getProperty("General.Output") != null) {
                cfg.setProperty("General.Output", cfg.getProperty("General.Output", ".") + File.separator + sDateFormat.format(new Date()));
                ToolBox.configureLogging(cfg.getProperty("General.Output", "."), cfg, false, false);
            } else {
                ToolBox.configureLogging();
                cfg.setProperty("General.Output", System.getProperty("user.home", ".") + File.separator + "Sectioning-Test" + File.separator + sDateFormat.format(new Date()));
            }
            if (args.length >= 4 && "online".equals(args[3])) {
                Test.onlineSectioning(cfg);
            } else if (args.length >= 4 && "simple".equals(args[3])) {
                cfg.setProperty("Sectioning.UseOnlinePenalties", "false");
                Test.onlineSectioning(cfg);
            } else {
                Test.batchSectioning(cfg);
            }
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestSolutionListener
    implements SolutionListener<Request, Enrollment> {
        @Override
        public void solutionUpdated(Solution<Request, Enrollment> solution) {
            StudentSectioningModel m = (StudentSectioningModel)solution.getModel();
            if (m.getTimeOverlaps() != null && TimeOverlapsCounter.sDebug) {
                m.getTimeOverlaps().checkTotalNrConflicts();
            }
            if (m.getDistanceConflict() != null && DistanceConflict.sDebug) {
                m.getDistanceConflict().checkAllConflicts();
            }
        }

        @Override
        public void getInfo(Solution<Request, Enrollment> solution, Map<String, String> info) {
        }

        @Override
        public void getInfo(Solution<Request, Enrollment> solution, Map<String, String> info, Collection<Request> variables) {
        }

        @Override
        public void bestCleared(Solution<Request, Enrollment> solution) {
        }

        @Override
        public void bestSaved(Solution<Request, Enrollment> solution) {
            sLog.debug((Object)("**BEST** " + solution.getModel().toString() + ", TM:" + sDF.format(solution.getTime() / 3600.0) + "h"));
        }

        @Override
        public void bestRestored(Solution<Request, Enrollment> solution) {
        }
    }

    public static class ExtraStudentFilter
    implements StudentFilter {
        HashSet<Long> iIds = new HashSet();

        public ExtraStudentFilter(StudentSectioningModel model) {
            for (Student student : model.getStudents()) {
                this.iIds.add(new Long(student.getId()));
            }
        }

        public boolean accept(Student student) {
            return !this.iIds.contains(new Long(student.getId()));
        }
    }
}

