/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.ConstraintListener;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.studentsct.constraint.ConfigLimit;
import net.sf.cpsolver.studentsct.constraint.CourseLimit;
import net.sf.cpsolver.studentsct.constraint.LinkedSections;
import net.sf.cpsolver.studentsct.constraint.RequiredReservation;
import net.sf.cpsolver.studentsct.constraint.ReservationLimit;
import net.sf.cpsolver.studentsct.constraint.SectionLimit;
import net.sf.cpsolver.studentsct.constraint.StudentConflict;
import net.sf.cpsolver.studentsct.extension.DistanceConflict;
import net.sf.cpsolver.studentsct.extension.TimeOverlapsCounter;
import net.sf.cpsolver.studentsct.model.Config;
import net.sf.cpsolver.studentsct.model.Course;
import net.sf.cpsolver.studentsct.model.CourseRequest;
import net.sf.cpsolver.studentsct.model.Enrollment;
import net.sf.cpsolver.studentsct.model.Offering;
import net.sf.cpsolver.studentsct.model.Request;
import net.sf.cpsolver.studentsct.model.Section;
import net.sf.cpsolver.studentsct.model.Student;
import net.sf.cpsolver.studentsct.model.Subpart;
import net.sf.cpsolver.studentsct.weights.PriorityStudentWeights;
import net.sf.cpsolver.studentsct.weights.StudentWeights;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSectioningModel
extends Model<Request, Enrollment> {
    private static Logger sLog = Logger.getLogger(StudentSectioningModel.class);
    protected static DecimalFormat sDecimalFormat = new DecimalFormat("0.000");
    private List<Student> iStudents = new ArrayList<Student>();
    private List<Offering> iOfferings = new ArrayList<Offering>();
    private List<LinkedSections> iLinkedSections = new ArrayList<LinkedSections>();
    private Set<Student> iCompleteStudents = new HashSet<Student>();
    private double iTotalValue = 0.0;
    private DataProperties iProperties;
    private DistanceConflict iDistanceConflict = null;
    private TimeOverlapsCounter iTimeOverlaps = null;
    private int iNrDummyStudents = 0;
    private int iNrDummyRequests = 0;
    private int iNrAssignedDummyRequests = 0;
    private int iNrCompleteDummyStudents = 0;
    private double iTotalDummyWeight = 0.0;
    private double iTotalCRWeight = 0.0;
    private double iTotalDummyCRWeight = 0.0;
    private double iAssignedCRWeight = 0.0;
    private double iAssignedDummyCRWeight = 0.0;
    private double iReservedSpace = 0.0;
    private double iTotalReservedSpace = 0.0;
    private StudentWeights iStudentWeights = null;
    private boolean iReservationCanAssignOverTheLimit;
    protected double iProjectedStudentWeight = 0.01;
    private int iMaxDomainSize = -1;

    public StudentSectioningModel(DataProperties properties) {
        this.iReservationCanAssignOverTheLimit = properties.getPropertyBoolean("Reservation.CanAssignOverTheLimit", false);
        this.iAssignedVariables = new HashSet();
        this.iUnassignedVariables = new HashSet();
        this.iPerturbVariables = new HashSet();
        this.iStudentWeights = new PriorityStudentWeights(properties);
        this.iMaxDomainSize = properties.getPropertyInt("Sectioning.MaxDomainSize", this.iMaxDomainSize);
        if (properties.getPropertyBoolean("Sectioning.SectionLimit", true)) {
            SectionLimit sectionLimit = new SectionLimit(properties);
            this.addGlobalConstraint(sectionLimit);
            if (properties.getPropertyBoolean("Sectioning.SectionLimit.Debug", false)) {
                sectionLimit.addConstraintListener(new ConstraintListener<Enrollment>(){

                    @Override
                    public void constraintBeforeAssigned(long iteration, Constraint<?, Enrollment> constraint, Enrollment enrollment, Set<Enrollment> unassigned) {
                        if (enrollment.getStudent().isDummy()) {
                            for (Enrollment conflict : unassigned) {
                                if (conflict.getStudent().isDummy()) continue;
                                sLog.warn((Object)("Enrolment of a real student " + conflict.getStudent() + " is unassigned " + "\n  -- " + conflict + "\ndue to an enrollment of a dummy student " + enrollment.getStudent() + " " + "\n  -- " + enrollment));
                            }
                        }
                    }

                    @Override
                    public void constraintAfterAssigned(long iteration, Constraint<?, Enrollment> constraint, Enrollment assigned, Set<Enrollment> unassigned) {
                    }
                });
            }
        }
        if (properties.getPropertyBoolean("Sectioning.ConfigLimit", true)) {
            ConfigLimit configLimit = new ConfigLimit(properties);
            this.addGlobalConstraint(configLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.CourseLimit", true)) {
            CourseLimit courseLimit = new CourseLimit(properties);
            this.addGlobalConstraint(courseLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.ReservationLimit", true)) {
            ReservationLimit reservationLimit = new ReservationLimit(properties);
            this.addGlobalConstraint(reservationLimit);
        }
        if (properties.getPropertyBoolean("Sectioning.RequiredReservations", true)) {
            RequiredReservation requiredReservation = new RequiredReservation();
            this.addGlobalConstraint(requiredReservation);
        }
        try {
            Class<?> studentWeightsClass = Class.forName(properties.getProperty("StudentWeights.Class", PriorityStudentWeights.class.getName()));
            this.iStudentWeights = (StudentWeights)studentWeightsClass.getConstructor(DataProperties.class).newInstance(properties);
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to create custom student weighting model (" + e.getMessage() + "), using default."), (Throwable)e);
            this.iStudentWeights = new PriorityStudentWeights(properties);
        }
        this.iProjectedStudentWeight = properties.getPropertyDouble("StudentWeights.ProjectedStudentWeight", this.iProjectedStudentWeight);
        this.iProperties = properties;
    }

    public boolean getReservationCanAssignOverTheLimit() {
        return this.iReservationCanAssignOverTheLimit;
    }

    public StudentWeights getStudentWeights() {
        return this.iStudentWeights;
    }

    public void setStudentWeights(StudentWeights weights) {
        this.iStudentWeights = weights;
    }

    public List<Student> getStudents() {
        return this.iStudents;
    }

    public Set<Student> getCompleteStudents() {
        return this.iCompleteStudents;
    }

    public void addStudent(Student student) {
        this.iStudents.add(student);
        if (student.isDummy()) {
            ++this.iNrDummyStudents;
        }
        for (Request request : student.getRequests()) {
            this.addVariable(request);
        }
        if (this.getProperties().getPropertyBoolean("Sectioning.StudentConflict", true)) {
            this.addConstraint(new StudentConflict(student));
        }
        if (student.isComplete()) {
            this.iCompleteStudents.add(student);
        }
    }

    @Override
    public void addVariable(Request request) {
        super.addVariable(request);
        if (request instanceof CourseRequest) {
            this.iTotalCRWeight += request.getWeight();
        }
        if (request.getStudent().isDummy()) {
            ++this.iNrDummyRequests;
            this.iTotalDummyWeight += request.getWeight();
            if (request instanceof CourseRequest) {
                this.iTotalDummyCRWeight += request.getWeight();
            }
        }
    }

    public void requestWeightsChanged() {
        this.iTotalCRWeight = 0.0;
        this.iTotalDummyWeight = 0.0;
        this.iTotalDummyCRWeight = 0.0;
        this.iAssignedCRWeight = 0.0;
        this.iAssignedDummyCRWeight = 0.0;
        this.iNrDummyRequests = 0;
        this.iNrAssignedDummyRequests = 0;
        this.iTotalReservedSpace = 0.0;
        this.iReservedSpace = 0.0;
        for (Request request : this.variables()) {
            boolean cr = request instanceof CourseRequest;
            if (cr) {
                this.iTotalCRWeight += request.getWeight();
            }
            if (request.getStudent().isDummy()) {
                this.iTotalDummyWeight += request.getWeight();
                ++this.iNrDummyRequests;
                if (cr) {
                    this.iTotalDummyCRWeight += request.getWeight();
                }
            }
            if (request.getAssignment() == null) continue;
            if (cr) {
                this.iAssignedCRWeight += request.getWeight();
            }
            if (((Enrollment)request.getAssignment()).getReservation() != null) {
                this.iReservedSpace += request.getWeight();
            }
            if (cr && ((CourseRequest)request).hasReservations()) {
                this.iTotalReservedSpace += request.getWeight();
            }
            if (!request.getStudent().isDummy()) continue;
            ++this.iNrAssignedDummyRequests;
            if (!cr) continue;
            this.iAssignedDummyCRWeight += request.getWeight();
        }
    }

    public void removeStudent(Student student) {
        this.iStudents.remove(student);
        if (student.isDummy()) {
            --this.iNrDummyStudents;
        }
        if (student.isComplete()) {
            this.iCompleteStudents.remove(student);
        }
        Constraint conflict = null;
        for (Request request : student.getRequests()) {
            for (Constraint c : request.constraints()) {
                if (!(c instanceof StudentConflict)) continue;
                conflict = (StudentConflict)c;
                break;
            }
            if (conflict != null) {
                conflict.removeVariable(request);
            }
            this.removeVariable(request);
        }
        if (conflict != null) {
            this.removeConstraint(conflict);
        }
    }

    @Override
    public void removeVariable(Request request) {
        super.removeVariable(request);
        if (request instanceof CourseRequest) {
            CourseRequest cr = (CourseRequest)request;
            for (Course course : cr.getCourses()) {
                course.getRequests().remove(request);
            }
        }
        if (request.getStudent().isDummy()) {
            --this.iNrDummyRequests;
            this.iTotalDummyWeight -= request.getWeight();
            if (request instanceof CourseRequest) {
                this.iTotalDummyCRWeight -= request.getWeight();
            }
        }
        if (request instanceof CourseRequest) {
            this.iTotalCRWeight -= request.getWeight();
        }
    }

    public List<Offering> getOfferings() {
        return this.iOfferings;
    }

    public void addOffering(Offering offering) {
        this.iOfferings.add(offering);
    }

    public void addLinkedSections(Section ... sections) {
        LinkedSections constraint = new LinkedSections(sections);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    public void addLinkedSections(Collection<Section> sections) {
        LinkedSections constraint = new LinkedSections(sections);
        this.iLinkedSections.add(constraint);
        constraint.createConstraints();
    }

    public List<LinkedSections> getLinkedSections() {
        return this.iLinkedSections;
    }

    public int nrComplete() {
        return this.getCompleteStudents().size();
    }

    @Override
    public Map<String, String> getInfo() {
        int nrLastLikeStudents;
        Map<String, String> info = super.getInfo();
        if (!this.getStudents().isEmpty()) {
            info.put("Students with complete schedule", sDoubleFormat.format(100.0 * (double)this.nrComplete() / (double)this.getStudents().size()) + "% (" + this.nrComplete() + "/" + this.getStudents().size() + ")");
        }
        if (this.getDistanceConflict() != null && this.getDistanceConflict().getTotalNrConflicts() != 0) {
            info.put("Student distance conflicts", String.valueOf(this.getDistanceConflict().getTotalNrConflicts()));
        }
        if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts() != 0) {
            info.put("Time overlapping conflicts", String.valueOf(this.getTimeOverlaps().getTotalNrConflicts()));
        }
        if ((nrLastLikeStudents = this.getNrLastLikeStudents(false)) != 0 && nrLastLikeStudents != this.getStudents().size()) {
            int nrRealStudents = this.getStudents().size() - nrLastLikeStudents;
            int nrLastLikeCompleteStudents = this.getNrCompleteLastLikeStudents(false);
            int nrRealCompleteStudents = this.getCompleteStudents().size() - nrLastLikeCompleteStudents;
            if (nrLastLikeStudents > 0) {
                info.put("Projected students with complete schedule", sDecimalFormat.format(100.0 * (double)nrLastLikeCompleteStudents / (double)nrLastLikeStudents) + "% (" + nrLastLikeCompleteStudents + "/" + nrLastLikeStudents + ")");
            }
            if (nrRealStudents > 0) {
                info.put("Real students with complete schedule", sDecimalFormat.format(100.0 * (double)nrRealCompleteStudents / (double)nrRealStudents) + "% (" + nrRealCompleteStudents + "/" + nrRealStudents + ")");
            }
            int nrLastLikeRequests = this.getNrLastLikeRequests(false);
            int nrRealRequests = this.variables().size() - nrLastLikeRequests;
            int nrLastLikeAssignedRequests = this.getNrAssignedLastLikeRequests(false);
            int nrRealAssignedRequests = this.assignedVariables().size() - nrLastLikeAssignedRequests;
            if (nrLastLikeRequests > 0) {
                info.put("Projected assigned requests", sDecimalFormat.format(100.0 * (double)nrLastLikeAssignedRequests / (double)nrLastLikeRequests) + "% (" + nrLastLikeAssignedRequests + "/" + nrLastLikeRequests + ")");
            }
            if (nrRealRequests > 0) {
                info.put("Real assigned requests", sDecimalFormat.format(100.0 * (double)nrRealAssignedRequests / (double)nrRealRequests) + "% (" + nrRealAssignedRequests + "/" + nrRealRequests + ")");
            }
            if (this.iTotalCRWeight > 0.0) {
                info.put("Assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedCRWeight / this.iTotalCRWeight) + "% (" + (int)Math.round(this.iAssignedCRWeight) + "/" + (int)Math.round(this.iTotalCRWeight) + ")");
                if (this.iTotalDummyCRWeight != this.iTotalCRWeight) {
                    if (this.iTotalDummyCRWeight > 0.0) {
                        info.put("Projected assigned course requests", sDecimalFormat.format(100.0 * this.iAssignedDummyCRWeight / this.iTotalDummyCRWeight) + "% (" + (int)Math.round(this.iAssignedDummyCRWeight) + "/" + (int)Math.round(this.iTotalDummyCRWeight) + ")");
                    }
                    info.put("Real assigned course requests", sDecimalFormat.format(100.0 * (this.iAssignedCRWeight - this.iAssignedDummyCRWeight) / (this.iTotalCRWeight - this.iTotalDummyCRWeight)) + "% (" + (int)Math.round(this.iAssignedCRWeight - this.iAssignedDummyCRWeight) + "/" + (int)Math.round(this.iTotalCRWeight - this.iTotalDummyCRWeight) + ")");
                }
            }
            if (this.getDistanceConflict() != null && this.getDistanceConflict().getTotalNrConflicts() > 0) {
                info.put("Student distance conflicts", String.valueOf(this.getDistanceConflict().getTotalNrConflicts()));
            }
            if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts() > 0) {
                info.put("Time overlapping conflicts", String.valueOf(this.getTimeOverlaps().getTotalNrConflicts()));
            }
        }
        if (this.iTotalReservedSpace > 0.0) {
            info.put("Reservations", sDoubleFormat.format(100.0 * this.iReservedSpace / this.iTotalReservedSpace) + "% (" + Math.round(this.iReservedSpace) + "/" + Math.round(this.iTotalReservedSpace) + ")");
        }
        return info;
    }

    public double getTotalValue(boolean precise) {
        if (precise) {
            double total = 0.0;
            for (Request request : this.assignedVariables()) {
                total += request.getWeight() * this.iStudentWeights.getWeight((Enrollment)request.getAssignment());
            }
            if (this.iDistanceConflict != null) {
                for (DistanceConflict.Conflict conflict : this.iDistanceConflict.computeAllConflicts()) {
                    total -= this.avg(conflict.getR1().getWeight(), conflict.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(conflict);
                }
            }
            if (this.iTimeOverlaps != null) {
                for (TimeOverlapsCounter.Conflict conflict : this.iTimeOverlaps.computeAllConflicts()) {
                    total -= conflict.getR1().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(conflict.getE1(), conflict);
                    total -= conflict.getR2().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(conflict.getE2(), conflict);
                }
            }
            return -total;
        }
        return this.iTotalValue;
    }

    @Override
    public double getTotalValue() {
        return this.iTotalValue;
    }

    @Override
    public void afterAssigned(long iteration, Enrollment enrollment) {
        super.afterAssigned(iteration, enrollment);
        Student student = enrollment.getStudent();
        if (student.isComplete()) {
            this.iCompleteStudents.add(student);
        }
        double value = enrollment.getRequest().getWeight() * this.iStudentWeights.getWeight(enrollment);
        this.iTotalValue -= value;
        enrollment.setExtra(value);
        if (enrollment.isCourseRequest()) {
            this.iAssignedCRWeight += enrollment.getRequest().getWeight();
        }
        if (enrollment.getReservation() != null) {
            this.iReservedSpace += enrollment.getRequest().getWeight();
        }
        if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
            this.iTotalReservedSpace += enrollment.getRequest().getWeight();
        }
        if (student.isDummy()) {
            ++this.iNrAssignedDummyRequests;
            if (enrollment.isCourseRequest()) {
                this.iAssignedDummyCRWeight += enrollment.getRequest().getWeight();
            }
            if (student.isComplete()) {
                ++this.iNrCompleteDummyStudents;
            }
        }
    }

    @Override
    public void afterUnassigned(long iteration, Enrollment enrollment) {
        Double value;
        super.afterUnassigned(iteration, enrollment);
        Student student = enrollment.getStudent();
        if (this.iCompleteStudents.contains(student) && !student.isComplete()) {
            this.iCompleteStudents.remove(student);
            if (student.isDummy()) {
                --this.iNrCompleteDummyStudents;
            }
        }
        if ((value = (Double)enrollment.getExtra()) == null) {
            value = enrollment.getRequest().getWeight() * this.iStudentWeights.getWeight(enrollment);
        }
        this.iTotalValue += value.doubleValue();
        enrollment.setExtra(null);
        if (enrollment.isCourseRequest()) {
            this.iAssignedCRWeight -= enrollment.getRequest().getWeight();
        }
        if (enrollment.getReservation() != null) {
            this.iReservedSpace -= enrollment.getRequest().getWeight();
        }
        if (enrollment.isCourseRequest() && ((CourseRequest)enrollment.getRequest()).hasReservations()) {
            this.iTotalReservedSpace -= enrollment.getRequest().getWeight();
        }
        if (student.isDummy()) {
            --this.iNrAssignedDummyRequests;
            if (enrollment.isCourseRequest()) {
                this.iAssignedDummyCRWeight -= enrollment.getRequest().getWeight();
            }
        }
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void clearOnlineSectioningInfos() {
        for (Offering offering : this.iOfferings) {
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        section.setSpaceExpected(0.0);
                        section.setSpaceHeld(0.0);
                    }
                }
            }
        }
    }

    public void computeOnlineSectioningInfos() {
        this.clearOnlineSectioningInfos();
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            for (Request request : student.getRequests()) {
                if (!(request instanceof CourseRequest)) continue;
                CourseRequest courseRequest = (CourseRequest)request;
                Enrollment enrollment = (Enrollment)courseRequest.getAssignment();
                if (enrollment != null) {
                    for (Section section : enrollment.getSections()) {
                        section.setSpaceHeld(courseRequest.getWeight() + section.getSpaceHeld());
                    }
                }
                ArrayList<Enrollment> feasibleEnrollments = new ArrayList<Enrollment>();
                int totalLimit = 0;
                for (Enrollment enrl : courseRequest.values()) {
                    boolean overlaps = false;
                    for (Request otherRequest : student.getRequests()) {
                        Enrollment otherErollment;
                        if (otherRequest.equals(courseRequest) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)otherRequest.getAssignment()) == null || !enrl.isOverlapping(otherErollment)) continue;
                        overlaps = true;
                        break;
                    }
                    if (overlaps) continue;
                    feasibleEnrollments.add(enrl);
                    if (totalLimit < 0) continue;
                    int limit = enrl.getLimit();
                    if (limit < 0) {
                        totalLimit = -1;
                        continue;
                    }
                    totalLimit += limit;
                }
                double increment = courseRequest.getWeight() / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
                for (Enrollment feasibleEnrollment : feasibleEnrollments) {
                    for (Section section : feasibleEnrollment.getSections()) {
                        if (totalLimit > 0) {
                            section.setSpaceExpected(section.getSpaceExpected() + increment * (double)feasibleEnrollment.getLimit());
                            continue;
                        }
                        section.setSpaceExpected(section.getSpaceExpected() + increment);
                    }
                }
            }
        }
    }

    public double getUnassignedRequestWeight() {
        double weight = 0.0;
        for (Request request : this.unassignedVariables()) {
            weight += request.getWeight();
        }
        return weight;
    }

    public double getTotalRequestWeight() {
        double weight = 0.0;
        for (Request request : this.unassignedVariables()) {
            weight += request.getWeight();
        }
        return weight;
    }

    public void setDistanceConflict(DistanceConflict dc) {
        this.iDistanceConflict = dc;
    }

    public DistanceConflict getDistanceConflict() {
        return this.iDistanceConflict;
    }

    public void setTimeOverlaps(TimeOverlapsCounter toc) {
        this.iTimeOverlaps = toc;
    }

    public TimeOverlapsCounter getTimeOverlaps() {
        return this.iTimeOverlaps;
    }

    public double avgUnassignPriority() {
        double totalPriority = 0.0;
        for (Request request : this.unassignedVariables()) {
            if (request.isAlternative()) continue;
            totalPriority += (double)request.getPriority();
        }
        return 1.0 + totalPriority / (double)this.unassignedVariables().size();
    }

    public double avgNrRequests() {
        double totalRequests = 0.0;
        int totalStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.nrRequests() == 0) continue;
            totalRequests += (double)student.nrRequests();
            ++totalStudents;
        }
        return totalRequests / (double)totalStudents;
    }

    public int getNrLastLikeStudents(boolean precise) {
        if (!precise) {
            return this.iNrDummyStudents;
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getStudents()) {
            if (!student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrRealStudents(boolean precise) {
        if (!precise) {
            return this.getStudents().size() - this.iNrDummyStudents;
        }
        int nrRealStudents = 0;
        for (Student student : this.getStudents()) {
            if (student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getNrCompleteLastLikeStudents(boolean precise) {
        if (!precise) {
            return this.iNrCompleteDummyStudents;
        }
        int nrLastLikeStudents = 0;
        for (Student student : this.getCompleteStudents()) {
            if (!student.isDummy()) continue;
            ++nrLastLikeStudents;
        }
        return nrLastLikeStudents;
    }

    public int getNrCompleteRealStudents(boolean precise) {
        if (!precise) {
            return this.getCompleteStudents().size() - this.iNrCompleteDummyStudents;
        }
        int nrRealStudents = 0;
        for (Student student : this.getCompleteStudents()) {
            if (student.isDummy()) continue;
            ++nrRealStudents;
        }
        return nrRealStudents;
    }

    public int getNrLastLikeRequests(boolean precise) {
        if (!precise) {
            return this.iNrDummyRequests;
        }
        int nrLastLikeRequests = 0;
        for (Request request : this.variables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrRealRequests(boolean precise) {
        if (!precise) {
            return this.variables().size() - this.iNrDummyRequests;
        }
        int nrRealRequests = 0;
        for (Request request : this.variables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    public int getNrAssignedLastLikeRequests(boolean precise) {
        if (!precise) {
            return this.iNrAssignedDummyRequests;
        }
        int nrLastLikeRequests = 0;
        for (Request request : this.assignedVariables()) {
            if (!request.getStudent().isDummy()) continue;
            ++nrLastLikeRequests;
        }
        return nrLastLikeRequests;
    }

    public int getNrAssignedRealRequests(boolean precise) {
        if (!precise) {
            return this.assignedVariables().size() - this.iNrAssignedDummyRequests;
        }
        int nrRealRequests = 0;
        for (Request request : this.assignedVariables()) {
            if (request.getStudent().isDummy()) continue;
            ++nrRealRequests;
        }
        return nrRealRequests;
    }

    @Override
    public Map<String, String> getExtendedInfo() {
        Map<String, String> info = this.getInfo();
        double dc = 0.0;
        if (this.getDistanceConflict() != null && this.getDistanceConflict().getTotalNrConflicts() != 0) {
            Set<DistanceConflict.Conflict> conf = this.getDistanceConflict().getAllConflicts();
            for (DistanceConflict.Conflict c : conf) {
                dc += this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(c);
            }
            if (!conf.isEmpty()) {
                info.put("Student distance conflicts", conf.size() + " (weighted: " + sDecimalFormat.format(dc) + ")");
            }
        }
        double toc = 0.0;
        if (this.getTimeOverlaps() != null && this.getTimeOverlaps().getTotalNrConflicts() != 0) {
            Set<TimeOverlapsCounter.Conflict> conf = this.getTimeOverlaps().getAllConflicts();
            int share = 0;
            for (TimeOverlapsCounter.Conflict c : conf) {
                toc += c.getR1().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE1(), c);
                toc += c.getR2().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE2(), c);
                share += c.getShare();
            }
            if (toc != 0.0) {
                info.put("Time overlapping conflicts", share + " (average: " + sDecimalFormat.format(5.0 * (double)share / (double)this.getStudents().size()) + " min, weighted: " + sDoubleFormat.format(toc) + ")");
            }
        }
        double disbWeight = 0.0;
        int disbSections = 0;
        int disb10Sections = 0;
        int disb10Limit = this.getProperties().getPropertyInt("Info.ListDisbalancedSections", 0);
        TreeSet<String> disb10SectionList = disb10Limit == 0 ? null : new TreeSet<String>();
        for (Offering offering : this.getOfferings()) {
            for (Config config : offering.getConfigs()) {
                double enrl = config.getEnrollmentWeight(null);
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getSections().size() <= 1) continue;
                    if (subpart.getLimit() > 0) {
                        double ratio = enrl / (double)subpart.getLimit();
                        for (Section section : subpart.getSections()) {
                            double desired = ratio * (double)section.getLimit();
                            disbWeight += Math.abs(section.getEnrollmentWeight(null) - desired);
                            ++disbSections;
                            if (!(Math.abs(desired - section.getEnrollmentWeight(null)) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                            ++disb10Sections;
                            if (disb10SectionList == null) continue;
                            disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                        }
                        continue;
                    }
                    for (Section section : subpart.getSections()) {
                        double desired = enrl / (double)subpart.getSections().size();
                        disbWeight += Math.abs(section.getEnrollmentWeight(null) - desired);
                        ++disbSections;
                        if (!(Math.abs(desired - section.getEnrollmentWeight(null)) >= Math.max(1.0, 0.1 * desired))) continue;
                        ++disb10Sections;
                        if (disb10SectionList == null) continue;
                        disb10SectionList.add(section.getSubpart().getConfig().getOffering().getName() + " " + section.getSubpart().getName() + " " + section.getName());
                    }
                }
            }
        }
        if (disbSections != 0) {
            info.put("Average disbalance", sDecimalFormat.format(disbWeight / (double)disbSections) + " (" + sDecimalFormat.format(this.iAssignedCRWeight == 0.0 ? 0.0 : 100.0 * disbWeight / this.iAssignedCRWeight) + "%)");
            String list = "";
            if (disb10SectionList != null) {
                int i = 0;
                for (String section : disb10SectionList) {
                    if (i == disb10Limit) {
                        list = list + "<br>...";
                        break;
                    }
                    list = list + "<br>" + section;
                    ++i;
                }
            }
            info.put("Sections disbalanced by 10% or more", disb10Sections + " (" + sDecimalFormat.format(disbSections == 0 ? 0.0 : 100.0 * (double)disb10Sections / (double)disbSections) + "%)" + list);
        }
        return info;
    }

    @Override
    public void restoreBest() {
        this.restoreBest(new Comparator<Request>(){

            @Override
            public int compare(Request r1, Request r2) {
                Enrollment e1 = (Enrollment)r1.getBestAssignment();
                Enrollment e2 = (Enrollment)r2.getBestAssignment();
                if (e1.getReservation() != null && e2.getReservation() == null) {
                    return -1;
                }
                if (e1.getReservation() == null && e2.getReservation() != null) {
                    return 1;
                }
                if (r1.getBestAssignmentIteration() != r2.getBestAssignmentIteration()) {
                    return r1.getBestAssignmentIteration() < r2.getBestAssignmentIteration() ? -1 : 1;
                }
                return r1.compareTo(r2);
            }
        });
    }

    @Override
    public String toString() {
        return (this.getNrRealStudents(false) > 0 ? "RRq:" + this.getNrAssignedRealRequests(false) + "/" + this.getNrRealRequests(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DRq:" + this.getNrAssignedLastLikeRequests(false) + "/" + this.getNrLastLikeRequests(false) + ", " : "") + (this.getNrRealStudents(false) > 0 ? "RS:" + this.getNrCompleteRealStudents(false) + "/" + this.getNrRealStudents(false) + ", " : "") + (this.getNrLastLikeStudents(false) > 0 ? "DS:" + this.getNrCompleteLastLikeStudents(false) + "/" + this.getNrLastLikeStudents(false) + ", " : "") + "V:" + sDecimalFormat.format(-this.getTotalValue()) + (this.getDistanceConflict() == null ? "" : ", DC:" + this.getDistanceConflict().getTotalNrConflicts()) + (this.getTimeOverlaps() == null ? "" : ", TOC:" + this.getTimeOverlaps().getTotalNrConflicts()) + ", %:" + sDecimalFormat.format(-100.0 * this.getTotalValue() / ((double)(this.getStudents().size() - this.iNrDummyStudents) + (this.iProjectedStudentWeight < 0.0 ? (double)this.iNrDummyStudents * (this.iTotalDummyWeight / (double)this.iNrDummyRequests) : this.iProjectedStudentWeight * this.iTotalDummyWeight)));
    }

    public double avg(double w1, double w2) {
        return Math.sqrt(w1 * w2);
    }

    public void add(DistanceConflict.Conflict c) {
        this.iTotalValue += this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(c);
    }

    public void remove(DistanceConflict.Conflict c) {
        this.iTotalValue -= this.avg(c.getR1().getWeight(), c.getR2().getWeight()) * this.iStudentWeights.getDistanceConflictWeight(c);
    }

    public void add(TimeOverlapsCounter.Conflict c) {
        this.iTotalValue += c.getR1().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE1(), c);
        this.iTotalValue += c.getR2().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE2(), c);
    }

    public void remove(TimeOverlapsCounter.Conflict c) {
        this.iTotalValue -= c.getR1().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE1(), c);
        this.iTotalValue -= c.getR2().getWeight() * this.iStudentWeights.getTimeOverlapConflictWeight(c.getE2(), c);
    }

    public int getMaxDomainSize() {
        return this.iMaxDomainSize;
    }

    public void setMaxDomainSize(int maxDomainSize) {
        this.iMaxDomainSize = maxDomainSize;
    }
}

