/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.split;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.criteria.StudentBackToBackConflicts;
import net.sf.cpsolver.exam.criteria.StudentDirectConflicts;
import net.sf.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSplitter
extends ExamCriterion {
    private long iLastSplitId = 0L;
    private Map<Exam, List<Exam>> iChildren = new HashMap<Exam, List<Exam>>();
    private Map<Exam, Exam> iParent = new HashMap<Exam, Exam>();
    private Criterion<Exam, ExamPlacement> iStudentDirectConflicts;
    private Criterion<Exam, ExamPlacement> iStudentMoreThan2ADayConflicts;
    private Criterion<Exam, ExamPlacement> iStudentBackToBackConflicts;
    private Map<Exam, List<ExamPlacement>> iBestSplit = null;

    public ExamSplitter() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iStudentDirectConflicts = solver.currentSolution().getModel().getCriterion(StudentDirectConflicts.class);
        this.iStudentMoreThan2ADayConflicts = solver.currentSolution().getModel().getCriterion(StudentMoreThan2ADayConflicts.class);
        this.iStudentBackToBackConflicts = solver.currentSolution().getModel().getCriterion(StudentBackToBackConflicts.class);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.ExamSplitWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "examSplitWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return this.iStudentDirectConflicts != null ? this.iStudentDirectConflicts.getWeight() / 2.0 : 500.0;
    }

    private boolean isDayBreakBackToBack() {
        return ((StudentBackToBackConflicts)this.iStudentBackToBackConflicts).isDayBreakBackToBack();
    }

    public boolean canSplit(Exam exam) {
        return !this.iParent.containsKey(exam);
    }

    public Exam parent(Exam exam) {
        return this.iParent.containsKey(exam) ? this.iParent.get(exam) : exam;
    }

    public List<Exam> children(Exam parent) {
        return this.iChildren.get(parent);
    }

    public Exam split(Exam parent, long iteration, ExamPlacement placement) {
        if (!this.canSplit(parent)) {
            return null;
        }
        Exam child = new Exam(--this.iLastSplitId, parent.getName(), parent.getLength(), parent.hasAltSeating(), parent.getMaxRooms(), parent.getMinSize(), parent.getPeriodPlacements(), parent.getRoomPlacements());
        child.setSizeOverride(parent.getSizeOverride());
        child.setPrintOffset(parent.getPrintOffset());
        child.setAveragePeriod(parent.getAveragePeriod());
        child.getOwners().addAll(parent.getOwners());
        this.iParent.put(child, parent);
        List<Exam> children = this.iChildren.get(parent);
        if (children == null) {
            children = new ArrayList<Exam>();
            this.iChildren.put(parent, children);
        }
        children.add(child);
        this.iValue += 1.0;
        parent.getModel().addVariable(child);
        for (ExamRoomPlacement room : child.getRoomPlacements()) {
            room.getRoom().addVariable(child);
        }
        if (placement != null) {
            child.assign(iteration, new ExamPlacement(child, placement.getPeriodPlacement(), placement.getRoomPlacements()));
        }
        this.shuffle(parent, iteration);
        return child;
    }

    public boolean canMerge(Exam exam) {
        return this.iParent.containsKey(exam);
    }

    public Exam merge(Exam child, long iteration) {
        if (!this.canMerge(child)) {
            return null;
        }
        Exam parent = this.iParent.get(child);
        this.iParent.remove(child);
        List<Exam> children = this.iChildren.get(parent);
        children.remove(child);
        this.iValue -= 1.0;
        ExamPlacement parentPlacement = (ExamPlacement)parent.getAssignment();
        if (parentPlacement != null) {
            parent.unassign(iteration);
        }
        if (child.getAssignment() != null) {
            child.unassign(iteration);
        }
        for (ExamStudent student : new ArrayList<ExamStudent>(child.getStudents())) {
            student.removeVariable(child);
            student.addVariable(parent);
        }
        for (ExamRoomPlacement room : child.getRoomPlacements()) {
            room.getRoom().removeVariable(child);
        }
        parent.getModel().removeVariable(child);
        if (parentPlacement != null) {
            parent.assign(iteration, parentPlacement);
        }
        this.shuffle(parent, iteration);
        return parent;
    }

    public double delta(ExamStudent student, ExamPlacement oldPlacement, ExamPlacement newPlacement) {
        Set<Exam> examsInADay;
        Set<Exam> examsNextPeriod;
        ExamPeriod next;
        Set<Exam> examsPrevPeriod;
        ExamPeriod prev;
        Set<Exam> examsThisPeriod;
        ExamPeriod period;
        Exam exam;
        double delta = 0.0;
        if (oldPlacement != null) {
            exam = (Exam)oldPlacement.variable();
            period = oldPlacement.getPeriod();
            examsThisPeriod = student.getExams(period);
            if (examsThisPeriod.size() > (examsThisPeriod.contains(exam) ? 1 : 0)) {
                delta -= this.iStudentDirectConflicts.getWeight();
            }
            if ((prev = period.prev()) != null && (prev.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsPrevPeriod = student.getExams(prev)).size() > (examsPrevPeriod.contains(exam) ? 1 : 0)) {
                delta -= this.iStudentBackToBackConflicts.getWeight();
            }
            if ((next = period.next()) != null && (next.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsNextPeriod = student.getExams(next)).size() > (examsNextPeriod.contains(exam) ? 1 : 0)) {
                delta -= this.iStudentBackToBackConflicts.getWeight();
            }
            if ((examsInADay = student.getExamsADay(period)).size() > (examsInADay.contains(exam) ? 3 : 2)) {
                delta -= this.iStudentMoreThan2ADayConflicts.getWeight();
            }
        }
        if (newPlacement != null) {
            exam = (Exam)newPlacement.variable();
            period = newPlacement.getPeriod();
            examsThisPeriod = student.getExams(period);
            if (examsThisPeriod.size() > (examsThisPeriod.contains(exam) ? 1 : 0)) {
                delta += this.iStudentDirectConflicts.getWeight();
            }
            if ((prev = period.prev()) != null && (prev.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsPrevPeriod = student.getExams(prev)).size() > (examsPrevPeriod.contains(exam) ? 1 : 0)) {
                delta += this.iStudentBackToBackConflicts.getWeight();
            }
            if ((next = period.next()) != null && (next.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsNextPeriod = student.getExams(next)).size() > (examsNextPeriod.contains(exam) ? 1 : 0)) {
                delta += this.iStudentBackToBackConflicts.getWeight();
            }
            if ((examsInADay = student.getExamsADay(period)).size() > (examsInADay.contains(exam) ? 3 : 2)) {
                delta += this.iStudentMoreThan2ADayConflicts.getWeight();
            }
        }
        return delta;
    }

    /*
     * WARNING - void declaration
     */
    public void shuffle(Exam exam, long iteration) {
        Exam parent = this.iParent.containsKey(exam) ? this.iParent.get(exam) : exam;
        List<Exam> children = this.iChildren.get(parent);
        if (children != null && !children.isEmpty()) {
            HashMap assignments = new HashMap();
            if (parent.getAssignment() != null) {
                assignments.put(parent, parent.getAssignment());
                parent.unassign(iteration);
            }
            for (Exam child : children) {
                if (child.getAssignment() == null) continue;
                assignments.put(child, child.getAssignment());
                child.unassign(iteration);
            }
            for (ExamStudent student : new ArrayList<ExamStudent>(parent.getStudents())) {
                void var9_8;
                Object var9_9 = null;
                double delta = 0.0;
                for (Exam x : children) {
                    double d = this.delta(student, (ExamPlacement)assignments.get(parent), (ExamPlacement)assignments.get(x));
                    if (var9_8 != null && !(d < delta)) continue;
                    delta = d;
                    Exam exam2 = x;
                }
                if (var9_8 == null || !(delta < 0.0)) continue;
                student.removeVariable(parent);
                student.addVariable(var9_8);
            }
            for (Exam child : children) {
                for (ExamStudent student : new ArrayList<ExamStudent>(child.getStudents())) {
                    Exam other = parent;
                    double delta = this.delta(student, (ExamPlacement)assignments.get(child), (ExamPlacement)assignments.get(parent));
                    for (Exam x : children) {
                        double d;
                        if (x.equals(child) || !((d = this.delta(student, (ExamPlacement)assignments.get(child), (ExamPlacement)assignments.get(x))) < delta)) continue;
                        delta = d;
                        other = x;
                    }
                    if (other == null || !(delta < 0.0)) continue;
                    student.removeVariable(child);
                    student.addVariable(other);
                }
            }
            ExamPlacement parentPlacement = (ExamPlacement)assignments.get(parent);
            if (parentPlacement != null) {
                parent.assign(iteration, parentPlacement);
            }
            for (Exam exam3 : children) {
                ExamPlacement placement = (ExamPlacement)assignments.get(exam3);
                if (placement == null) continue;
                exam3.assign(iteration, placement);
            }
        }
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return 0.0;
    }

    @Override
    public double[] getBounds(Collection<Exam> exams) {
        return new double[]{0.0, 0.0};
    }

    public String toString() {
        return "XX:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (!this.iChildren.isEmpty()) {
            int parents = 0;
            String split = "";
            for (Exam parent : new TreeSet<Exam>(this.iChildren.keySet())) {
                List<Exam> children = this.iChildren.get(parent);
                if (children.isEmpty()) continue;
                split = split + "\n  ";
                ++parents;
                split = split + parent.getName() + ": " + parent.getStudents().size() + " (" + (parent.getAssignment() == null ? "N/A" : ((ExamPlacement)parent.getAssignment()).getPeriod()) + ")";
                for (Exam child : children) {
                    split = split + " + " + child.getStudents().size() + " (" + (child.getAssignment() == null ? "N/A" : ((ExamPlacement)child.getAssignment()).getPeriod()) + ")";
                }
            }
            if (parents > 0) {
                info.put("Examination Splits", parents + split);
            }
        }
    }

    @Override
    public void bestSaved() {
        super.bestSaved();
        if (this.iBestSplit == null) {
            this.iBestSplit = new Hashtable<Exam, List<ExamPlacement>>();
        } else {
            this.iBestSplit.clear();
        }
        for (Map.Entry<Exam, List<Exam>> entry : this.iChildren.entrySet()) {
            Exam parent = entry.getKey();
            ArrayList placements = new ArrayList();
            for (Exam child : entry.getValue()) {
                if (child.getAssignment() == null) continue;
                placements.add(child.getAssignment());
            }
            if (placements.isEmpty()) continue;
            this.iBestSplit.put(parent, placements);
        }
    }

    @Override
    public void bestRestored() {
        super.bestRestored();
        for (Exam parent : new ArrayList<Exam>(this.iChildren.keySet())) {
            int i;
            ArrayList children = new ArrayList(this.iChildren.get(parent));
            List<ExamPlacement> placements = this.iBestSplit.get(parent);
            int n = i = placements == null ? 0 : placements.size();
            while (i < children.size()) {
                this.merge((Exam)children.get(i), 0L);
                ++i;
            }
        }
        this.iValue = 0.0;
        for (Exam parent : this.iBestSplit.keySet()) {
            List<ExamPlacement> placements = this.iBestSplit.get(parent);
            for (int i = 0; i < placements.size(); ++i) {
                List<Exam> children = this.iChildren.get(parent);
                if (children == null || children.size() <= i) {
                    this.split(parent, 0L, placements.get(i));
                    continue;
                }
                children.get(i).assign(0L, new ExamPlacement(children.get(i), placements.get(i).getPeriodPlacement(), placements.get(i).getRoomPlacements()));
            }
            this.iValue += (double)placements.size();
        }
    }
}

